#!/usr/bin/perl
# $Id: probeTestDataToFtp.pl 468 2016-09-09 12:40:36Z miw $
########################################################################

use Net::FTP;
use strict;

$| = 1; # turn autoflushing on, otherwise some debug output lines will not be printed in time, especially the last ones!

@ARGV==5 || die "ARGV must have 5 elements\n";
my ($topspinPath, $probeId, $inspectionLotName, $x, $y)=@ARGV;

my $dir="/incoming/PROBETESTDATA";
my $zipFileName=$probeId.'_'.$inspectionLotName.'_results.zip';
my $backupSource=$topspinPath.'/npt/ProbesWithoutFactoryTest/'.$zipFileName;
my $backupTarget=$zipFileName;
my $host='ftp.bruker.ch';

my $ftp = Net::FTP->new($host) || die "Unable to connect to $host: $@";
$ftp->login(encrypt($x), encrypt($y)) || die "Unable to connect to $host: $@";
if ($ftp->cwd($dir)) {
    $ftp->binary();
    if (!$ftp->put($backupSource, $backupTarget)) {
        $ftp->quit;
        die "Unable to put $backupSource to $backupTarget: $@";
    }
} else {
    $ftp->quit;
    die "Unable to change directory to $dir: $@";
}
$ftp->quit;

sub encrypt() {
    my $text=$_[0];
    $text=~tr/A-Za-z0-9/n-za-mN-ZA-M5-90-4/;
    return $text;
}
