#!/usr/bin/perl
# $Id: probeTestDataToZip.pl 1814 2021-01-19 15:20:21Z miw $
########################################################################
require 5.10.1;		 # minimum required perl version

use Archive::Zip;
use Cwd;
use strict;

$| = 1; # turn autoflushing on, otherwise some debug output lines will not be printed in time, especially the last ones!

@ARGV==3 || die "ARGV must have 3 elements\n";
my ($probeId, $inspectionLotNumber, $testMode)=@ARGV;

my $zip = Archive::Zip->new();

chdir("npt");

my $acceptanceTestPath='Probes/'.$probeId.'/'.$testMode.'/';
my $topShimStatistics=$acceptanceTestPath.'statistics/NPT_TopShimStatistic.xml';
addFileToZip($topShimStatistics);

my $inspectionLotPath=$acceptanceTestPath.$inspectionLotNumber.'/';
my $inspectionLot=$inspectionLotPath.$inspectionLotNumber.'.xml';
addFileToZipAbortIfNotExist($inspectionLot);

my $resultsPath=$inspectionLotPath.'Results/';
my $spectraPdf=$resultsPath.'customer_'.$inspectionLotNumber.'.pdf';
addFileToZipAbortIfNotExist($spectraPdf);
my $measurementTime=$resultsPath.$inspectionLotNumber.'.xml';
addFileToZipAbortIfNotExist($measurementTime);
my $dataControl=$resultsPath.'NptDataControl_'.$inspectionLotNumber.'.xml';
addFileToZipAbortIfNotExist($dataControl);

my $picsPath='../conf/instr/remote_spect/probeheads/';
my $picsPh=$picsPath.$probeId.'.ph';
addFileToZip($picsPh);
my $picsPar=$picsPath.$probeId.'.par';
addFileToZip($picsPar);

my $dataPath='../data/npt/'.$probeId.'/'.$testMode.'/'.$inspectionLotNumber.'/';
my @listOfExperiments = ();
findFilesInDir($dataPath, '^NPT_', \@listOfExperiments, 0, 0);

foreach my $experimentName(@listOfExperiments) {
	my $experimentPath=$dataPath.'/'.$experimentName.'/';
	my @listOfExpnos = ();
	findFilesInDir($experimentPath, '^[0-9][0-9]*$', \@listOfExpnos, 0, 0);

	foreach my $expno(@listOfExpnos) {
		my $expnoPath=$experimentPath.'/'.$expno.'/';
		my $expInfoFile=$expnoPath.'/ExpInfo.xml';
		if (-r $expInfoFile) {
			my $procnoPath=$expnoPath.'/pdata/1/'.$experimentName;
			my $lFile=$procnoPath.'.l';
			my $rFile=$procnoPath.'.r';
			my $pdfFile=$procnoPath.'.pdf';
			if ((-r $lFile) && (-r $rFile) && (-r $pdfFile)) {
				addFileToZip($expInfoFile);
				addFileToZip($lFile);
				addFileToZip($rFile);
				addFileToZip($pdfFile);
			}
		}
	}
}

my $zipFile='ProbesWithoutFactoryTest/'.$probeId.'_'.$inspectionLotNumber.'_results.zip';
unless ($zip->writeToFileNamed($zipFile) == Archive::Zip::AZ_OK) {
	die "Error during creation of zip file!\n";
}

sub addFileToZipAbortIfNotExist() {
	my $file=$_[0];
	if ( ( -r $file ) && ( ( -f $file ) || ( -l $file ) ) ) {
		$zip->addFile($file);
	} else {
		die "File $file is not readable!\nCreation of zip file was aborted!\n";
	}
}

sub addFileToZip() {
	my $file=$_[0];
	if ( ( -r $file ) && ( ( -f $file ) || ( -l $file ) ) ) {
		$zip->addFile($file);
	}
}

sub findFilesInDir($ $ \@ $ $) {
	my $dirName = $_[0];
	my $searchToken = $_[1];
	my $containerRef = $_[2];
	my $addDirPath = $_[3];
	my $negateToken = $_[4];

	if( ! opendir(INC, $dirName)) {
		print_log("Unable to open $dirName: $!\n");
		return;	
	}

	if($addDirPath) {
		my @dummyList = ();

		if( $negateToken) {
			@dummyList = grep( ! /^$searchToken/, readdir(INC));
		} else {
			@dummyList = grep(/^$searchToken/, readdir(INC));
		}
	
		foreach my $entry (@dummyList) {
			push(@{$containerRef}, $dirName.$entry);
		}
	} else {
		if( $negateToken) {
			@{$containerRef} = grep( ! /^$searchToken/, readdir(INC));
		} else {
			@{$containerRef} = grep(/^$searchToken/, readdir(INC));
		}
	}

	closedir(INC);
}
