/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.DateUtil;
import com.toedter.calendar.IDateEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.MaskFormatter;

public class JTextFieldDateEditor
extends JFormattedTextField
implements IDateEditor,
CaretListener,
FocusListener,
ActionListener {
    private static final long serialVersionUID = -8901842591101625304L;
    protected Date date;
    protected SimpleDateFormat dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
    protected MaskFormatter maskFormatter;
    protected String datePattern;
    protected String maskPattern;
    protected char placeholder;
    protected Color darkGreen;
    protected DateUtil dateUtil;
    private boolean isMaskVisible;
    private boolean ignoreDatePatternChange;
    private int hours;
    private int minutes;
    private int seconds;
    private int millis;
    private Calendar calendar;

    public JTextFieldDateEditor() {
        this(false, null, null, ' ');
    }

    public JTextFieldDateEditor(String string, String string2, char c2) {
        this(true, string, string2, c2);
    }

    public JTextFieldDateEditor(boolean bl, String string, String string2, char c2) {
        this.dateFormatter.setLenient(false);
        this.setDateFormatString(string);
        if (string != null) {
            this.ignoreDatePatternChange = true;
        }
        this.placeholder = c2;
        this.maskPattern = string2 == null ? this.createMaskFromDatePattern(this.datePattern) : string2;
        this.setToolTipText(this.datePattern);
        this.setMaskVisible(bl);
        this.addCaretListener(this);
        this.addFocusListener(this);
        this.addActionListener(this);
        this.darkGreen = new Color(0, 150, 0);
        this.calendar = Calendar.getInstance();
        this.dateUtil = new DateUtil();
    }

    public Date getDate() {
        try {
            this.calendar.setTime(this.dateFormatter.parse(this.getText()));
            this.calendar.set(11, this.hours);
            this.calendar.set(12, this.minutes);
            this.calendar.set(13, this.seconds);
            this.calendar.set(14, this.millis);
            this.date = this.calendar.getTime();
        }
        catch (ParseException parseException) {
            this.date = null;
        }
        return this.date;
    }

    public void setDate(Date date) {
        this.setDate(date, true);
    }

    protected void setDate(Date date, boolean bl) {
        Date date2 = this.date;
        this.date = date;
        if (date == null) {
            this.setText("");
        } else {
            this.calendar.setTime(date);
            this.hours = this.calendar.get(11);
            this.minutes = this.calendar.get(12);
            this.seconds = this.calendar.get(13);
            this.millis = this.calendar.get(14);
            String string = this.dateFormatter.format(date);
            try {
                this.setText(string);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        if (date != null && this.dateUtil.checkDate(date)) {
            this.setForeground(Color.BLACK);
        }
        if (bl) {
            this.firePropertyChange("date", date2, date);
        }
    }

    public void setDateFormatString(String string) {
        if (this.ignoreDatePatternChange) {
            return;
        }
        try {
            this.dateFormatter.applyPattern(string);
        }
        catch (RuntimeException runtimeException) {
            this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
            this.dateFormatter.setLenient(false);
        }
        this.datePattern = this.dateFormatter.toPattern();
        this.setToolTipText(this.datePattern);
        this.setDate(this.date, false);
    }

    public String getDateFormatString() {
        return this.datePattern;
    }

    public JComponent getUiComponent() {
        return this;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        String string = this.getText().trim();
        String string2 = this.maskPattern.replace('#', this.placeholder);
        if (string.length() == 0 || string.equals(string2)) {
            this.setForeground(Color.BLACK);
            return;
        }
        try {
            Date date = this.dateFormatter.parse(this.getText());
            if (this.dateUtil.checkDate(date)) {
                this.setForeground(this.darkGreen);
            } else {
                this.setForeground(Color.RED);
            }
        }
        catch (Exception exception) {
            this.setForeground(Color.RED);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.checkText();
    }

    private void checkText() {
        try {
            Date date = this.dateFormatter.parse(this.getText());
            this.setDate(date, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void setLocale(Locale locale) {
        if (locale == this.getLocale() || this.ignoreDatePatternChange) {
            return;
        }
        super.setLocale(locale);
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
        this.setToolTipText(this.dateFormatter.toPattern());
        this.setDate(this.date, false);
        this.doLayout();
    }

    public String createMaskFromDatePattern(String string) {
        String string2 = "GyMdkHmsSEDFwWahKzZ";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            boolean bl = false;
            for (int j = 0; j < string2.length(); ++j) {
                if (string2.charAt(j) != c2) continue;
                string3 = string3 + "#";
                bl = true;
                break;
            }
            if (bl) continue;
            string3 = string3 + c2;
        }
        return string3;
    }

    public boolean isMaskVisible() {
        return this.isMaskVisible;
    }

    public void setMaskVisible(boolean bl) {
        this.isMaskVisible = bl;
        if (bl && this.maskFormatter == null) {
            try {
                this.maskFormatter = new MaskFormatter(this.createMaskFromDatePattern(this.datePattern));
                this.maskFormatter.setPlaceholderCharacter(this.placeholder);
                this.maskFormatter.install(this);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.datePattern != null) {
            return new JTextField(this.datePattern).getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.checkText();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            super.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
    }

    public Date getMaxSelectableDate() {
        return this.dateUtil.getMaxSelectableDate();
    }

    public Date getMinSelectableDate() {
        return this.dateUtil.getMinSelectableDate();
    }

    public void setMaxSelectableDate(Date date) {
        this.dateUtil.setMaxSelectableDate(date);
        this.checkText();
    }

    public void setMinSelectableDate(Date date) {
        this.dateUtil.setMinSelectableDate(date);
        this.checkText();
    }

    public void setSelectableDateRange(Date date, Date date2) {
        this.dateUtil.setSelectableDateRange(date, date2);
        this.checkText();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JTextFieldDateEditor");
        JTextFieldDateEditor jTextFieldDateEditor = new JTextFieldDateEditor();
        jTextFieldDateEditor.setDate(new Date());
        jFrame.getContentPane().add(jTextFieldDateEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

