/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util.treetable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class ExternalCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -9139037834271761092L;
    private final ActionListener okActionListener;
    private final ActionListener cancelActionListener;
    private Object currentValue;
    protected Component parent;

    protected abstract Object getValue();

    protected abstract void setValue(Object var1);

    protected abstract void showDialog();

    public ExternalCellEditor(Component parent) {
        super(new JTextField(""));
        this.parent = parent;
        this.okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalCellEditor.this.currentValue = ExternalCellEditor.this.getValue();
                ExternalCellEditor.this.fireEditingStopped();
            }
        };
        this.cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalCellEditor.this.fireEditingCanceled();
            }
        };
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentValue = value;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExternalCellEditor.this.edit();
            }
        });
        return table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    private void edit() {
        this.setValue(this.currentValue);
        this.showDialog();
    }

    public ActionListener getOkActionListener() {
        return this.okActionListener;
    }

    public ActionListener getCancelActionListener() {
        return this.cancelActionListener;
    }
}

