/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util.treetable;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class BooleanCellRenderer
extends JCheckBox
implements TableCellRenderer,
UIResource {
    private static final long serialVersionUID = -3382483242353201361L;
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final TableCellRenderer emptyRenderer = new DefaultTableCellRenderer();

    public BooleanCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return emptyRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setSelected((Boolean)value);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }
}

