/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SizeLimitedFileOutputStream
extends OutputStream {
    private FileOutputStream instance;
    private final File file;
    private final long byteLimit;
    private long byteSize;

    public SizeLimitedFileOutputStream(long byteLimit, File file, boolean append) throws FileNotFoundException {
        this.instance = new FileOutputStream(file, append);
        this.file = file;
        this.byteLimit = byteLimit;
        this.byteSize = append ? file.length() : 0L;
    }

    public SizeLimitedFileOutputStream(long byteLimit, File file) throws FileNotFoundException {
        this(byteLimit, file, false);
    }

    private void checkSize() throws IOException {
        if (this.byteSize < this.byteLimit) {
            return;
        }
        this.instance.close();
        this.instance = new FileOutputStream(this.file);
        this.byteSize = 0L;
    }

    @Override
    public synchronized void write(int b2) throws IOException {
        ++this.byteSize;
        this.checkSize();
        this.instance.write(b2);
    }

    @Override
    public synchronized void write(byte[] b2) throws IOException {
        this.byteSize += (long)b2.length;
        this.checkSize();
        this.instance.write(b2);
    }

    @Override
    public synchronized void write(byte[] b2, int off, int len) throws IOException {
        this.byteSize += (long)len;
        this.checkSize();
        this.instance.write(b2, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.instance.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.instance.close();
    }
}

