/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.img.Images;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;

public abstract class ProgressTask<R> {
    private static final ImageIcon ICON = new ImageIcon(Images.class.getResource("ServiceGuiIcon48.png"));
    private static final ThreadLocal<ProgressTask> instance = new ThreadLocal();
    protected final JFrame frame;
    protected final SwingWorker worker = new SwingWorker<R, Void>(){

        @Override
        protected R doInBackground() throws Exception {
            instance.set(ProgressTask.this);
            Object result = ProgressTask.this.work();
            instance.remove();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                ProgressTask.this.done(this.get());
            }
            catch (ExecutionException e) {
                ProgressTask.this.error(e);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                ProgressTask.this.frame.dispose();
            }
        }
    };
    private final JLabel label;
    private final JLabel progressLabel;
    private final JProgressBar progressBar;

    public ProgressTask(JFrame root) {
        this.frame = new JFrame();
        this.frame.setIconImages(SGUtils.PROGRAM_ICONS);
        this.frame.setBounds(100, 100, 330, 90);
        this.frame.setLocationRelativeTo(root);
        this.frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.frame.setResizable(false);
        this.frame.setUndecorated(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{96, 166, 35, 30, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        this.frame.getContentPane().setLayout(gridBagLayout);
        ((JPanel)this.frame.getContentPane()).setBorder(new LineBorder(Color.GRAY, 1));
        JLabel icon = new JLabel("");
        icon.setIcon(ICON);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.gridheight = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.frame.getContentPane().add((Component)icon, gbc);
        this.label = new JLabel();
        gbc = new GridBagConstraints();
        gbc.anchor = 16;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.frame.getContentPane().add((Component)this.label, gbc);
        this.progressLabel = new JLabel("");
        GridBagConstraints _progressLabel = new GridBagConstraints();
        _progressLabel.anchor = 14;
        _progressLabel.insets = new Insets(0, 0, 5, 5);
        _progressLabel.gridx = 2;
        _progressLabel.gridy = 0;
        this.frame.getContentPane().add((Component)this.progressLabel, _progressLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setIndeterminate(true);
        GridBagConstraints _progressBar = new GridBagConstraints();
        _progressBar.gridwidth = 2;
        _progressBar.fill = 2;
        _progressBar.insets = new Insets(0, 0, 0, 5);
        _progressBar.anchor = 11;
        _progressBar.gridx = 1;
        _progressBar.gridy = 1;
        this.frame.getContentPane().add((Component)this.progressBar, _progressBar);
    }

    public abstract R work() throws Exception;

    public abstract void done(R var1);

    public void error(ExecutionException e) {
        SGUtils.err("Exception in task: " + e.getMessage(), new Object[0]);
    }

    public void start(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressTask.this.label.setText(status);
                ProgressTask.this.frame.setVisible(true);
            }
        });
        this.worker.execute();
    }

    private static boolean hasModal() {
        return instance.get() != null;
    }

    public static void update(String text) {
        if (ProgressTask.hasModal()) {
            instance.get().updateInstance(text);
        } else {
            SGUtils.log(text, new Object[0]);
        }
    }

    public static void update(int percent) {
        if (ProgressTask.hasModal()) {
            instance.get().updateInstance(percent);
        }
    }

    protected void updateInstance(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressTask.this.label.setText(text);
            }
        });
    }

    protected void updateInstance(final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (percent < 0 || percent > 100) {
                    ProgressTask.this.progressBar.setIndeterminate(true);
                    ProgressTask.this.progressLabel.setText("");
                    SGUtils.log("Funny percentage: %d", percent);
                    ProgressTask.this.progressBar.setIndeterminate(true);
                    return;
                }
                ProgressTask.this.progressBar.setIndeterminate(false);
                ProgressTask.this.progressBar.setValue(percent);
                ProgressTask.this.progressLabel.setText(percent + "%");
            }
        });
    }
}

