/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import ch.bruker.jac.servicegui.SGUtils;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.areas.DefaultAreaRenderer2D;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.LabelPointRenderer;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.ui.DrawablePanel;
import de.erichseifert.gral.ui.InteractivePanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.geom.Ellipse2D;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Random;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PlotFrame
extends JDialog {
    private final JPanel contentPane;
    private XYPlot plot;
    private DataTable data;
    public int markerSize = 0;
    public Color markerColor = Color.BLACK;
    public int strokeWidth = 2;
    public Color strokeColor = Color.BLACK;
    public boolean fill = false;
    public Color fillColor = new Color(1.0f, 0.8f, 0.1f, 0.4f);
    private Component parent;

    public static void main(String[] args) throws InterruptedException {
        final PlotFrame xy = new PlotFrame(null, "Test plot", "asdf", "qwer");
        final DataSource[] wolke = new DataTable[1];
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int i;
                    Random random = new Random();
                    for (i = 10; i >= 0; --i) {
                        xy.add(random.nextDouble(), random.nextDouble() * 23.0);
                    }
                    xy.fill = true;
                    xy.draw();
                    xy.fill = false;
                    for (i = 200; i >= 0; --i) {
                        xy.add(random.nextGaussian() / 2.0 + 0.5, random.nextGaussian() + 1.0);
                    }
                    xy.strokeWidth = 0;
                    xy.markerSize = 5;
                    xy.markerColor = new Color(136, 228, 0, 107);
                    wolke[0] = xy.draw();
                    xy.finish(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Thread.sleep(2000L);
        System.out.println("\u00e4ndern!");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                xy.erase(wolke[0]);
                xy.setTitle("m\u00fcesli");
                xy.strokeWidth = 5;
                xy.add(0.0, 0.0);
                xy.add(3.0, 10.0);
                xy.draw();
                xy.finish(true);
            }
        });
        Thread.sleep(2000L);
        System.out.println("l\u00f6schen!");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                xy.clear();
            }
        });
        Thread.sleep(2000L);
        System.out.println("Neu!");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                xy.clear();
                xy.setTitle("Vier Punkte, drei Kanten");
                xy.strokeWidth = 3;
                xy.markerColor = Color.CYAN;
                xy.add(1.0, 1.0);
                xy.add(2.0, 1.0);
                xy.add(2.0, 2.0);
                xy.add(1.0, 2.0);
                xy.draw();
                xy.finish(true);
            }
        });
    }

    public PlotFrame(Frame owner, String title, String xLabel, String yLabel) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setBounds(100, 100, 672, 567);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.setTitle(title);
        this.setIconImages(SGUtils.PROGRAM_ICONS);
        this.plot = new XYPlot(new DataSource[0]);
        this.plot.getAxisRenderer("x").getLabel().setText(xLabel);
        this.plot.getAxisRenderer("y").getLabel().setText(yLabel);
        this.plot.getTitle().setText(title);
        this.data = new DataTable(Double.class, Double.class);
    }

    public DataSource draw() {
        this.plot.add(this.data);
        DefaultPointRenderer2D points = new DefaultPointRenderer2D();
        if (this.markerSize > 0) {
            points.setShape(new Ellipse2D.Float(-this.markerSize, -this.markerSize, this.markerSize * 2, this.markerSize * 2));
            points.setColor(this.markerColor);
        } else {
            points.setShape(null);
        }
        this.plot.setPointRenderers(this.data, points, new PointRenderer[0]);
        DefaultLineRenderer2D lines = new DefaultLineRenderer2D();
        lines.setStroke(new BasicStroke(this.strokeWidth));
        lines.setColor(this.strokeColor);
        this.plot.setLineRenderers(this.data, lines, new LineRenderer[0]);
        if (this.fill) {
            DefaultAreaRenderer2D areas = new DefaultAreaRenderer2D();
            areas.setColor(this.fillColor);
            this.plot.setAreaRenderers(this.data, areas, new AreaRenderer[0]);
        }
        DataTable ret = this.data;
        this.data = new DataTable(Double.class, Double.class);
        return ret;
    }

    public void label(double x, double y, final String label, double alignment) {
        DataTable data = new DataTable(Double.class, Double.class);
        data.add(Double.valueOf(x), Double.valueOf(y));
        this.plot.add(data);
        LabelPointRenderer labelPointRenderer = new LabelPointRenderer();
        labelPointRenderer.setAlignmentX(alignment);
        labelPointRenderer.setFormat(new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                return toAppendTo.append(label);
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }
        });
        this.plot.setPointRenderers(data, labelPointRenderer, new PointRenderer[0]);
    }

    public void finish(boolean interactive) {
        if (this.plot.getInsets().equals(new Insets2D.Double(0.0))) {
            this.plot.setInsets(new Insets2D.Double(20.0, 60.0, 60.0, 60.0));
        }
        Axis x = this.plot.getAxis("x");
        Axis y = this.plot.getAxis("y");
        this.addPadding(x, 5);
        this.addPadding(y, 5);
        DrawablePanel drawablePanel = interactive ? new InteractivePanel(this.plot) : new DrawablePanel(this.plot);
        this.contentPane.removeAll();
        this.contentPane.add(drawablePanel);
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
    }

    public void setMargins(int top, int left, int bottom, int right) {
        this.plot.setInsets(new Insets2D.Double(top, left, bottom, right));
    }

    private void addPadding(Axis axis, int percent) {
        double padding = (float)(axis.getRange() * (double)percent / 100.0);
        axis.setRange(axis.getMin().doubleValue() - padding, axis.getMax().doubleValue() + padding);
    }

    public void erase(DataSource data) {
        this.plot.remove(data);
    }

    public void add(double x, double y) {
        this.data.add(Double.valueOf(x), Double.valueOf(y));
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.plot != null) {
            this.plot.getTitle().setText(title);
        }
    }

    public void clear() {
        String xLabel = this.plot.getAxisRenderer("x").getLabel().getText();
        String yLabel = this.plot.getAxisRenderer("y").getLabel().getText();
        String title = this.plot.getTitle().getText();
        this.plot = new XYPlot(new DataSource[0]);
        this.plot.getAxisRenderer("x").getLabel().setText(xLabel);
        this.plot.getAxisRenderer("y").getLabel().setText(yLabel);
        this.plot.getTitle().setText(title);
        this.data = new DataTable(Double.class, Double.class);
    }

    public void setParent(Component parent) {
        this.setLocationRelativeTo(parent);
        this.parent = parent;
    }

    public AxisRenderer getAxisRenderer(String axis) {
        return this.plot.getAxisRenderer(axis);
    }
}

