/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import ch.bruker.util.BUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordUtils {
    private static final Random RANDOM = new SecureRandom();
    private static final String ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final int ITERATIONS = 10000;
    private static final int KEY_LENGTH = 256;

    public static String getSalt(int length) {
        StringBuilder returnValue = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            returnValue.append(ALPHABET.charAt(RANDOM.nextInt(ALPHABET.length())));
        }
        return new String(returnValue);
    }

    private static byte[] hash(char[] password, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 10000, 256);
        Arrays.fill(password, '\u0000');
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] byArray = skf.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException e1) {
            throw new AssertionError((Object)("Error while hashing a password: " + e1.getMessage()));
        }
        catch (InvalidKeySpecException e2) {
            throw new AssertionError((Object)("Error while hashing a password: " + e2.getMessage()));
        }
        finally {
            spec.clearPassword();
        }
    }

    public static String generateSecurePassword(String password, String salt) {
        String returnValue = "";
        try {
            byte[] securePassword = PasswordUtils.hash(password.toCharArray(), salt.getBytes());
            returnValue = BUtil.binaryDataToBase64String(securePassword, securePassword.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static boolean verifyUserPassword(String providedPassword, String securedPassword, String salt) {
        boolean returnValue = false;
        try {
            String newSecurePassword = PasswordUtils.generateSecurePassword(providedPassword, salt);
            returnValue = newSecurePassword.equalsIgnoreCase(securedPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }
}

