/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JDateTimeField
extends JTextField {
    private DateTimeFormatter formatter = null;
    private DateTime dateTime;

    public JDateTimeField(String pattern, DateTimeZone zone) {
        this(DateTimeFormat.forPattern(pattern).withZone(zone));
    }

    public JDateTimeField(DateTimeFormatter formatter) {
        this.setFormatter(formatter);
        this.setColumns((int)((double)formatter.print(0L).length() * 0.8));
        this.setHorizontalAlignment(0);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JDateTimeField.this.parse();
                super.focusLost(e);
            }
        });
    }

    @Override
    protected void fireActionPerformed() {
        this.parse();
        super.fireActionPerformed();
    }

    private void parse() {
        try {
            this.dateTime = this.formatter.parseDateTime(this.getText());
        }
        catch (IllegalArgumentException iae) {
            if (this.dateTime != null) {
                this.setDateTime(this.dateTime);
            }
            this.selectAll();
        }
    }

    @Override
    public void setText(String t) {
        this.parse();
        super.setText(t);
    }

    private void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public void setDateTime(ReadableInstant instant) {
        super.setText(this.formatter.print(instant));
    }

    public DateTime getDateTime() {
        this.parse();
        return this.dateTime;
    }
}

