/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

public class FixedOrderTabbedPane {
    private Map<Component, Integer> order;
    private JTabbedPane tabbedPane;

    public FixedOrderTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        this.tabbedPane = new JTabbedPane(tabPlacement, tabLayoutPolicy);
        this.order = new HashMap<Component, Integer>();
    }

    public JTabbedPane getPane() {
        return this.tabbedPane;
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        this.tabbedPane.addMouseListener(mouseAdapter);
    }

    public TabbedPaneUI getUI() {
        return this.tabbedPane.getUI();
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public Component getSelectedComponent() {
        return this.tabbedPane.getSelectedComponent();
    }

    public String getTitleAt(int selectedIndex) {
        return this.tabbedPane.getTitleAt(selectedIndex);
    }

    public void addChangeListener(ChangeListener listener) {
        this.tabbedPane.addChangeListener(listener);
    }

    public void setMnemonicAt(int tabIndex, int mnemonic) {
        this.tabbedPane.setMnemonicAt(tabIndex, mnemonic);
    }

    public Component add(String title, Component component) {
        if (component != null) {
            if (!this.order.containsKey(component)) {
                this.order.put(component, this.order.size());
                return this.tabbedPane.add(title, component);
            }
            int orderedIndex = this.order.get(component);
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                Integer index;
                Component c2 = this.tabbedPane.getComponentAt(i);
                if (c2 == null || (index = this.order.get(c2)) == null || index <= orderedIndex) continue;
                this.tabbedPane.add(component, title, i);
                return component;
            }
            return this.tabbedPane.add(title, component);
        }
        return component;
    }

    public void remove(Component component) {
        this.tabbedPane.remove(component);
    }

    public void setSelectedComponent(Component c2) {
        this.tabbedPane.setSelectedComponent(c2);
    }

    public int indexOfComponent(Component component) {
        return this.tabbedPane.indexOfComponent(component);
    }
}

