/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileDumpInputStream
extends FilterInputStream {
    private final FileOutputStream dumper;

    public FileDumpInputStream(InputStream in, File dump) {
        super(in);
        try {
            Files.createParentDirs(dump);
            this.dumper = new FileOutputStream(dump, false);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create cache at " + dump);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long skippedLen = ByteStreams.copy(ByteStreams.limit(this.in, n), this.dumper);
        ByteStreams.skipFully(this.in, skippedLen);
        return skippedLen;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int readLen = this.in.read(b2, off, len);
        if (readLen != -1) {
            this.dumper.write(b2, off, readLen);
        }
        return readLen;
    }

    @Override
    public int read() throws IOException {
        int data = this.in.read();
        if (data != -1) {
            this.dumper.write(data);
        }
        return data;
    }

    @Override
    public void close() throws IOException {
        ByteStreams.copy(this.in, this.dumper);
        this.dumper.close();
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

