/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import ch.bruker.jac.servicegui.FileDropHandler;
import ch.bruker.jac.servicegui.net.JacDeviceScanner;
import ch.bruker.util.JOptionPaneTB;
import ch.bruker.util.NewOptionsListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DynamicSelectionDialog
implements NewOptionsListener {
    public static final String LOCAL_LOGFILE_STRING = "Local Log File\u2026";
    private final JPanel selectionPanel;
    private final JLabel state;
    private final JList selection;
    private final DefaultListModel listModel;
    private final JButton reScan;
    private boolean doubleClicked;

    public DynamicSelectionDialog(String text, List<?> options, final JacDeviceScanner scanner) {
        if (text == null) {
            text = "Please choose from the following options:";
        }
        this.selectionPanel = new JPanel();
        this.selectionPanel.setLayout(new GridBagLayout());
        JLabel description = new JLabel(text);
        this.selectionPanel.add((Component)description, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.listModel = new DefaultListModel();
        if (options != null) {
            for (Object option : options) {
                this.listModel.addElement(option);
            }
        }
        int rem = this.selectionPanel.getFontMetrics(this.selectionPanel.getFont()).getHeight();
        this.selection = new JList(this.listModel);
        this.selection.setSelectedIndex(0);
        this.selection.setSelectionMode(0);
        this.selection.setLayoutOrientation(0);
        this.selection.setVisibleRowCount(4);
        this.selection.setFixedCellHeight(rem);
        this.selection.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DynamicSelectionDialog.this.doubleClicked = true;
                    JDialog dialog = (JDialog)SwingUtilities.getWindowAncestor(DynamicSelectionDialog.this.selectionPanel);
                    dialog.dispatchEvent(new WindowEvent(dialog, 201));
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.selection);
        this.selectionPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 5, 5), 0, 0));
        this.state = new JLabel("");
        this.selectionPanel.add((Component)this.state, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.reScan = new JButton("Re-Scan");
        this.reScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scanner.reScan();
            }
        });
        this.selectionPanel.add((Component)this.reScan, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.selectionPanel.setTransferHandler(new FileDropHandler(new FileDropHandler.FileDropCallback(){

            @Override
            public void process(File file) {
                DynamicSelectionDialog.this.listModel.addElement(file);
                DynamicSelectionDialog.this.selection.setSelectedIndex(DynamicSelectionDialog.this.listModel.getSize() - 1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DynamicSelectionDialog.this.doubleClicked = true;
                        SwingUtilities.windowForComponent(DynamicSelectionDialog.this.selectionPanel).dispose();
                    }
                });
            }
        }));
        this.selectionPanel.setPreferredSize(new Dimension(18 * rem, 26 * rem));
    }

    @Override
    public void started(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicSelectionDialog.this.state.setText(message);
            }
        });
    }

    @Override
    public void newOptionAvailable(final Object newOption) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicSelectionDialog.this.listModel.addElement(newOption);
            }
        });
    }

    @Override
    public void done(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicSelectionDialog.this.state.setText(message);
            }
        });
    }

    @Override
    public void clear(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicSelectionDialog.this.state.setText(message);
                boolean containsLocal = DynamicSelectionDialog.this.listModel.contains(DynamicSelectionDialog.LOCAL_LOGFILE_STRING);
                DynamicSelectionDialog.this.listModel.removeAllElements();
                if (containsLocal) {
                    DynamicSelectionDialog.this.listModel.addElement(DynamicSelectionDialog.LOCAL_LOGFILE_STRING);
                }
            }
        });
    }

    public Object show(Component parent, List<? extends Image> iconImages) {
        int status = JOptionPaneTB.showOptionDialog(parent, this.selectionPanel, "Please Choose", 2, 3, null, null, null, iconImages);
        if (status == 0 || this.doubleClicked) {
            return this.selection.getSelectedValue();
        }
        return null;
    }

    public void addPanel(JPanel panel) {
        this.selectionPanel.add((Component)panel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 15, 5), 0, 0));
    }
}

