/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class DirSelector
extends JPanel {
    private final JTextField text;

    public DirSelector(String path) {
        final JFileChooser dialog = new JFileChooser(path);
        dialog.setDialogTitle("Select path");
        dialog.setFileSelectionMode(1);
        this.text = new JTextField();
        this.text.setText(path);
        this.text.setPreferredSize(new Dimension(200, 22));
        JButton button = new JButton(UIManager.getIcon("FileView.directoryIcon"));
        button.setMargin(new Insets(-3, 3, -1, 3));
        button.setPreferredSize(new Dimension(22, 22));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setCurrentDirectory(new File(DirSelector.this.text.getText()));
                int returnValue = dialog.showDialog(DirSelector.this.getParent(), "Select");
                if (returnValue == 0) {
                    File file = dialog.getSelectedFile();
                    DirSelector.this.text.setText(file.getPath());
                }
            }
        });
        this.add(this.text);
        this.add(button);
    }

    public String getPath() {
        return this.text.getText();
    }
}

