/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import ch.bruker.util.BUtil;
import java.io.Serializable;
import java.util.TreeMap;
import java.util.Vector;

public class Bis
implements Serializable {
    private static final long serialVersionUID = 4126524221340026171L;
    protected final Vector<Group> completeGroupList = new Vector();
    public final TreeMap<String, Vector<Group>> groupListMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    protected final byte[] rawData;
    public BisGroup bisGroup = null;
    public ProductionGroup productionGroup = null;
    public NameGroup nameGroup = null;

    public Bis(byte[] data) {
        Bis.verifyChecksum(data);
        this.rawData = new byte[data.length];
        System.arraycopy(data, 0, this.rawData, 0, data.length);
        try {
            this.parseData(data);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Corrupt BIS file", e);
        }
        Group group = this.getBisGroup();
        if (group == null) {
            throw new RuntimeException("Corrupt BIS file: no 'Bis' group");
        }
        this.bisGroup = new BisGroup(group);
        group = this.getProductionGroup();
        if (group == null) {
            throw new RuntimeException("Corrupt BIS file: no 'Production' group");
        }
        this.productionGroup = new ProductionGroup(group);
        group = this.getNameGroup();
        if (group == null) {
            throw new RuntimeException("Corrupt BIS file: no 'Name' group");
        }
        this.nameGroup = new NameGroup(group);
    }

    public static byte[] updateChecksum(byte[] data) {
        byte[] updatedBis;
        int a2 = 0;
        byte b2 = 0;
        byte[] endToken = "$endbis,".getBytes();
        int endTokenIndex = 0;
        int dataIndex = 0;
        while (endTokenIndex < endToken.length) {
            if (dataIndex == data.length) {
                throw new RuntimeException("'EndBis' group not found");
            }
            byte d = data[dataIndex++];
            a2 = (byte)(a2 + d);
            b2 = (byte)(a2 + b2);
            if ((byte)Character.toLowerCase(d) == endToken[endTokenIndex]) {
                ++endTokenIndex;
                continue;
            }
            endTokenIndex = 0;
        }
        byte s1 = (byte)(-a2 - b2);
        byte s2 = b2;
        String calculatedChecksum = BUtil.getHexString(s1) + BUtil.getHexString(s2);
        if (data.length != dataIndex + 7) {
            updatedBis = new byte[dataIndex + 7];
            System.arraycopy(data, 0, updatedBis, 0, dataIndex);
        } else {
            updatedBis = data;
        }
        updatedBis[dataIndex++] = (byte)calculatedChecksum.charAt(0);
        updatedBis[dataIndex++] = (byte)calculatedChecksum.charAt(1);
        updatedBis[dataIndex++] = 44;
        updatedBis[dataIndex++] = (byte)calculatedChecksum.charAt(2);
        updatedBis[dataIndex++] = (byte)calculatedChecksum.charAt(3);
        updatedBis[dataIndex++] = 35;
        updatedBis[dataIndex++] = 0;
        return updatedBis;
    }

    private static void verifyChecksum(byte[] data) {
        int a2 = 0;
        byte b2 = 0;
        byte[] endToken = "$endbis,".getBytes();
        int endTokenIndex = 0;
        int dataIndex = new String(data).indexOf("$");
        if (dataIndex < 0 || dataIndex + 4 > data.length || !"$bis".equalsIgnoreCase(new String(data, dataIndex, 4).toLowerCase())) {
            throw new RuntimeException("'Bis' group not found");
        }
        while (endTokenIndex < endToken.length) {
            if (dataIndex == data.length) {
                throw new RuntimeException("'EndBis' group not found");
            }
            byte d = data[dataIndex++];
            a2 = (byte)(a2 + d);
            b2 = (byte)(a2 + b2);
            if ((byte)Character.toLowerCase(d) == endToken[endTokenIndex]) {
                ++endTokenIndex;
                continue;
            }
            endTokenIndex = 0;
        }
        byte s1 = (byte)(-a2 - b2);
        byte s2 = b2;
        String calculatedChecksum = BUtil.getHexString(s1) + BUtil.getHexString(s2);
        byte[] readChecksumBuffer = new byte[4];
        int readChecksumBufferIndex = 0;
        while (readChecksumBufferIndex < 4) {
            byte d;
            if (dataIndex == data.length) {
                throw new RuntimeException("checksum not found");
            }
            if ((d = data[dataIndex++]) == 32 || d == 44 || d == 35) continue;
            readChecksumBuffer[readChecksumBufferIndex++] = d;
        }
        String readChecksum = new String(readChecksumBuffer).toUpperCase();
        if (!readChecksum.equals(calculatedChecksum)) {
            throw new RuntimeException("BIS checksum error: read checksum = [" + readChecksum + "], calculated checksum = [" + calculatedChecksum + "]");
        }
    }

    protected void parseData(byte[] data) {
        IntHolder index = new IntHolder();
        while (index.value < data.length) {
            while (data[index.value] != 36) {
                ++index.value;
                if (index.value < data.length) continue;
                return;
            }
            Group group = this.readGroup(data, index);
            this.completeGroupList.add(group);
            Vector<Group> groupList = this.groupListMap.get(group.getName());
            if (groupList == null) {
                groupList = new Vector();
                this.groupListMap.put(group.getName(), groupList);
            }
            groupList.add(group);
        }
    }

    protected Group readGroup(byte[] data, IntHolder index) {
        Vector<String> tokenList = new Vector<String>();
        while (data[index.value] != 35) {
            while (data[index.value] == 36 || data[index.value] == 44) {
                ++index.value;
            }
            int startIndex = index.value;
            while (data[index.value] != 35 && data[index.value] != 44) {
                ++index.value;
            }
            int endIndex = index.value;
            tokenList.add(new String(data, startIndex, endIndex - startIndex).trim());
        }
        return new Group(tokenList);
    }

    public Vector<Group> getCompleteGroupList() {
        return this.completeGroupList;
    }

    public Group getGroup(int index) {
        return this.completeGroupList.get(index);
    }

    public Vector<Group> getGroupList(String name) {
        return this.groupListMap.get(name);
    }

    public String toString() {
        return new String(this.rawData);
    }

    private Group getBisGroup() {
        Vector<Group> groupList = this.groupListMap.get("bis");
        if (groupList != null) {
            return groupList.firstElement();
        }
        return null;
    }

    private Group getProductionGroup() {
        Vector<Group> groupList = this.groupListMap.get("production");
        if (groupList == null) {
            groupList = this.groupListMap.get("prd");
        }
        if (groupList != null) {
            return groupList.firstElement();
        }
        return null;
    }

    private Group getNameGroup() {
        Vector<Group> groupList = this.groupListMap.get("name");
        if (groupList == null) {
            groupList = this.groupListMap.get("nam");
        }
        if (groupList != null) {
            return groupList.firstElement();
        }
        System.out.println("No name or name group in BIS, returning third entry");
        return this.completeGroupList.elementAt(2);
    }

    public final class NameGroup
    implements Serializable {
        private static final long serialVersionUID = -7906347029251686363L;
        private final Group group;

        public String getName() {
            return this.group.getStringEntry(0);
        }

        public NameGroup(Group group) {
            this.group = group;
        }
    }

    public final class ProductionGroup
    implements Serializable {
        private static final long serialVersionUID = -1763838688788587645L;
        private final Group group;

        public String getProductID() {
            return this.group.getStringEntry(0);
        }

        public String getSerialNumber() {
            return this.group.getStringEntry(1);
        }

        public String getECL() {
            return this.group.getStringEntry(2);
        }

        public String getVariant() {
            return this.group.getStringEntry(3);
        }

        public String getLocation() {
            return this.group.getStringEntry(4);
        }

        public String getProductionDate() {
            return this.group.getStringEntry(5);
        }

        public ProductionGroup(Group group) {
            this.group = group;
        }
    }

    public final class BisGroup
    implements Serializable {
        private static final long serialVersionUID = -3590076769280240690L;
        private final Group group;

        public int getBisVersion() {
            return this.group.getIntegerEntry(0);
        }

        public String getBisDate() {
            return this.group.getStringEntry(1);
        }

        public int getBisSize() {
            return this.group.getIntegerEntry(2);
        }

        public String getBisType() {
            return this.group.getStringEntry(3);
        }

        public int getBisTypeVersion() {
            return this.group.getIntegerEntry(4);
        }

        public BisGroup(Group group) {
            this.group = group;
        }
    }

    public final class Group
    implements Serializable {
        private static final long serialVersionUID = -4859468716262727172L;
        private final String name;
        private final String version;
        private final int majorVersion;
        private final int minorVersion;
        private final String[] entryList;

        Group(Vector<String> tokenList) {
            int offset;
            String tmpName = tokenList.get(0);
            if (tmpName.equalsIgnoreCase("einheit")) {
                tmpName = "Name";
            }
            this.name = tmpName;
            if (this.name.equalsIgnoreCase("bis") || this.name.equalsIgnoreCase("production") || this.name.equalsIgnoreCase("prd") || this.name.equalsIgnoreCase("name") || this.name.equalsIgnoreCase("nam") || this.name.equalsIgnoreCase("endbis")) {
                offset = 1;
                this.version = "";
                this.majorVersion = 0;
                this.minorVersion = 0;
            } else {
                offset = 2;
                this.version = tokenList.get(1);
                int splitIndex = this.version.indexOf(46);
                if (splitIndex == -1) {
                    this.majorVersion = Integer.parseInt(this.version);
                    this.minorVersion = 0;
                } else {
                    this.majorVersion = Integer.parseInt(this.version.substring(0, splitIndex));
                    this.minorVersion = Integer.parseInt(this.version.substring(splitIndex + 1));
                }
            }
            this.entryList = new String[tokenList.size() - offset];
            for (int i = 0; i < this.entryList.length; ++i) {
                this.entryList[i] = tokenList.get(i + offset);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public int getNumberOfEntries() {
            return this.entryList.length;
        }

        public boolean isEmptyEntry(int entryIndex) {
            return this.entryList[entryIndex].isEmpty();
        }

        public String getStringEntry(int entryIndex) {
            return this.entryList[entryIndex];
        }

        public int getIntegerEntry(int entryIndex) {
            return Integer.parseInt(this.entryList[entryIndex]);
        }

        public double getDoubleEntry(int entryIndex) {
            return Double.parseDouble(this.entryList[entryIndex]);
        }

        public String[] getStringListEntry(int entryIndex) {
            return this.entryList[entryIndex].split("/");
        }

        public int[] getIntegerListEntry(int entryIndex) {
            String[] stringList = this.getStringListEntry(entryIndex);
            int[] intList = new int[stringList.length];
            for (int i = 0; i < stringList.length; ++i) {
                intList[i] = Integer.parseInt(stringList[i]);
            }
            return intList;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('$');
            buffer.append(this.name);
            if (!this.version.isEmpty()) {
                buffer.append(", ");
                buffer.append(this.version);
            }
            for (int i = 0; i < this.entryList.length; ++i) {
                buffer.append(", ");
                buffer.append(this.entryList[i]);
            }
            buffer.append('#');
            return buffer.toString();
        }
    }

    protected final class IntHolder {
        int value = 0;

        protected IntHolder() {
        }
    }
}

