/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import java.io.Closeable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;

public final class BUtil {
    public static final boolean isWindows;
    private static final byte[] BINARY_VALUE_TO_BASE64_CODE_LIST;
    private static final byte[] BASE64_CODE_TO_BINARY_VALUE_LIST;

    public static String getBinaryString(byte value) {
        return Integer.toBinaryString(Integer.MIN_VALUE | value & 0xFF).substring(24);
    }

    public static String getBinaryString(short value) {
        return BUtil.getBinaryString((byte)(value >> 8)) + " " + BUtil.getBinaryString((byte)(value & 0xFF));
    }

    public static String getHexString(byte value) {
        return Integer.toHexString(Integer.MIN_VALUE | value & 0xFF).substring(6).toUpperCase();
    }

    public static String getHexString(short value) {
        return Integer.toHexString(Integer.MIN_VALUE | value).substring(4).toUpperCase();
    }

    public static byte getByteFrom2Hex(byte hexhigh, byte hexlow) {
        return (byte)(BUtil.hex2bin((char)hexhigh) << 4 & BUtil.hex2bin((char)hexlow));
    }

    public static int hex2bin(char hex) {
        if (hex >= '0' && hex <= '9') {
            return hex - 48;
        }
        if (hex >= 'A' && hex <= 'F') {
            return hex - 65 + 10;
        }
        if (hex >= 'a' && hex <= 'f') {
            return hex - 97 + 10;
        }
        return 0;
    }

    public static String removeSpecificCharacter(String s, char c2) {
        StringBuffer stringBuffer = new StringBuffer(s.length());
        stringBuffer.append(s);
        int current = 0;
        for (int i = 0; i < s.length(); ++i) {
            char cur = s.charAt(i);
            if (cur == c2) continue;
            stringBuffer.setCharAt(current++, cur);
        }
        return stringBuffer.toString();
    }

    private static void addCode(int value, int base64Code) {
        BUtil.BINARY_VALUE_TO_BASE64_CODE_LIST[value] = (byte)base64Code;
        BUtil.BASE64_CODE_TO_BINARY_VALUE_LIST[base64Code] = (byte)value;
    }

    public static String binaryStringToBase64String(String binaryString) {
        return new String(BUtil.binaryDataToBase64Data(binaryString.getBytes(), binaryString.length()));
    }

    public static String binaryDataToBase64String(byte[] binaryData, int length) {
        return new String(BUtil.binaryDataToBase64Data(binaryData, length));
    }

    public static byte[] binaryDataToBase64Data(byte[] binaryData, int length) {
        if (length == 0) {
            return new byte[0];
        }
        int numberOfGroups = (length + 2) / 3;
        byte[] base64Data = new byte[numberOfGroups << 2];
        int i = 0;
        int j = 0;
        for (int group = 0; group < numberOfGroups; ++group) {
            byte b0 = binaryData[i++];
            base64Data[j++] = BINARY_VALUE_TO_BASE64_CODE_LIST[b0 >> 2 & 0x3F];
            if (i < length) {
                byte b1 = binaryData[i++];
                base64Data[j++] = BINARY_VALUE_TO_BASE64_CODE_LIST[b0 << 4 & 0x30 | b1 >> 4 & 0xF];
                if (i < length) {
                    byte b2 = binaryData[i++];
                    base64Data[j++] = BINARY_VALUE_TO_BASE64_CODE_LIST[b1 << 2 & 0x3C | b2 >> 6 & 3];
                    base64Data[j++] = BINARY_VALUE_TO_BASE64_CODE_LIST[b2 & 0x3F];
                    continue;
                }
                base64Data[j++] = BINARY_VALUE_TO_BASE64_CODE_LIST[b1 << 2 & 0x3C];
                base64Data[j++] = 61;
                continue;
            }
            base64Data[j++] = BINARY_VALUE_TO_BASE64_CODE_LIST[b0 << 4 & 0x30];
            base64Data[j++] = 61;
            base64Data[j++] = 61;
        }
        return base64Data;
    }

    public static String base64StringToBinaryString(String base64DataString) {
        return new String(BUtil.base64DataToBinaryData(base64DataString.getBytes()));
    }

    public static byte[] base64StringToBinaryData(String base64DataString) {
        return BUtil.base64DataToBinaryData(base64DataString.getBytes());
    }

    public static byte[] base64DataToBinaryData(byte[] base64Data) {
        if (base64Data.length == 0) {
            return new byte[0];
        }
        if ((base64Data.length & 3) != 0) {
            throw new RuntimeException("illegal length of base64 string: " + base64Data.length);
        }
        int numberOfGroups = base64Data.length >> 2;
        int stuffing = 0;
        if (base64Data[base64Data.length - 2] == 61) {
            stuffing = 2;
        } else if (base64Data[base64Data.length - 1] == 61) {
            stuffing = 1;
        }
        byte[] binaryData = new byte[3 * numberOfGroups - stuffing];
        int i = 0;
        int j = 0;
        for (int group = 0; group < numberOfGroups; ++group) {
            byte b0 = BASE64_CODE_TO_BINARY_VALUE_LIST[base64Data[i++]];
            byte b1 = BASE64_CODE_TO_BINARY_VALUE_LIST[base64Data[i++]];
            byte b2 = BASE64_CODE_TO_BINARY_VALUE_LIST[base64Data[i++]];
            byte b3 = BASE64_CODE_TO_BINARY_VALUE_LIST[base64Data[i++]];
            binaryData[j++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
            if (j < binaryData.length) {
                binaryData[j++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
            }
            if (j >= binaryData.length) continue;
            binaryData[j++] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
        }
        return binaryData;
    }

    public static void sortListAscending(double[] list) {
        int k;
        int j;
        int i;
        block0: for (i = 0; i < list.length; ++i) {
            j = i;
            while (j != 0) {
                int n;
                k = (j - 1) / 2;
                if (!(list[n] < list[j])) continue block0;
                BUtil.swap(list, j, k);
                j = k;
            }
        }
        for (i = list.length - 1; i >= 0; --i) {
            BUtil.swap(list, 0, i);
            j = 0;
            while (2 * j + 2 < i && (list[2 * j + 1] > list[j] || list[2 * j + 2] > list[j])) {
                k = list[2 * j + 1] > list[2 * j + 2] ? 2 * j + 1 : 2 * j + 2;
                BUtil.swap(list, j, k);
                j = k;
            }
            k = 2 * j + 1;
            if (k >= i || !(list[k] > list[j])) continue;
            BUtil.swap(list, j, k);
        }
    }

    public static void sortListDescending(double[] list) {
        int k;
        int j;
        int i;
        block0: for (i = 0; i < list.length; ++i) {
            j = i;
            while (j != 0) {
                int n;
                k = (j - 1) / 2;
                if (!(list[n] > list[j])) continue block0;
                BUtil.swap(list, j, k);
                j = k;
            }
        }
        for (i = list.length - 1; i >= 0; --i) {
            BUtil.swap(list, 0, i);
            j = 0;
            while (2 * j + 2 < i && (list[2 * j + 1] < list[j] || list[2 * j + 2] < list[j])) {
                k = list[2 * j + 1] < list[2 * j + 2] ? 2 * j + 1 : 2 * j + 2;
                BUtil.swap(list, j, k);
                j = k;
            }
            k = 2 * j + 1;
            if (k >= i || !(list[k] < list[j])) continue;
            BUtil.swap(list, j, k);
        }
    }

    private static void swap(double[] list, int i, int j) {
        double buffer = list[i];
        list[i] = list[j];
        list[j] = buffer;
    }

    public static String getSystemProperties() {
        StringBuffer buffer = new StringBuffer(10000);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            buffer.append(entry.getKey().toString() + " = " + entry.getValue().toString() + "\n");
        }
        return buffer.toString();
    }

    public static final String getFormattedTime(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd;HH:mm:ss:SSS");
        return dateFormat.format(time);
    }

    public static final String getFormattedTime(long time, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd;HH:mm:ss");
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(time);
    }

    public static String getFormattedCurrentTime() {
        return BUtil.getFormattedTime(System.currentTimeMillis());
    }

    public static void closeIgnoringExceptions(Closeable c2) {
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static InetAddress getAddressToInterface(String interfaceId) {
        try {
            NetworkInterface matchingIfc = null;
            ArrayList<NetworkInterface> ifcs = Collections.list(NetworkInterface.getNetworkInterfaces());
            block2: for (NetworkInterface ifc : ifcs) {
                if (ifc.getName().equals(interfaceId)) {
                    matchingIfc = ifc;
                    break;
                }
                ArrayList<NetworkInterface> subIfcs = Collections.list(ifc.getSubInterfaces());
                for (NetworkInterface subIfc : subIfcs) {
                    if (!subIfc.getName().equals(interfaceId)) continue;
                    matchingIfc = subIfc;
                    break block2;
                }
            }
            if (matchingIfc == null) {
                return null;
            }
            ArrayList<InetAddress> addresses = Collections.list(matchingIfc.getInetAddresses());
            for (InetAddress address : addresses) {
                if (!(address instanceof Inet4Address)) continue;
                return address;
            }
            return null;
        }
        catch (SocketException e) {
            return null;
        }
    }

    public static boolean isReal(float value) {
        return !Float.isInfinite(value) && !Float.isNaN(value);
    }

    public static boolean isUnReal(float value) {
        return Float.isInfinite(value) || Float.isNaN(value);
    }

    static {
        int i;
        isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        BINARY_VALUE_TO_BASE64_CODE_LIST = new byte[64];
        BASE64_CODE_TO_BINARY_VALUE_LIST = new byte[256];
        for (i = 0; i < 26; ++i) {
            BUtil.addCode(i, 65 + i);
            BUtil.addCode(i + 26, 97 + i);
        }
        for (i = 0; i < 10; ++i) {
            BUtil.addCode(i + 52, 48 + i);
        }
        BUtil.addCode(62, 43);
        BUtil.addCode(63, 47);
    }

    public static class ListReverser<T>
    implements Iterable<T> {
        private ListIterator<T> listIterator;

        public ListReverser(List<T> wrappedList) {
            this.listIterator = wrappedList.listIterator(wrappedList.size());
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return ListReverser.this.listIterator.hasPrevious();
                }

                @Override
                public T next() {
                    return ListReverser.this.listIterator.previous();
                }

                @Override
                public void remove() {
                    ListReverser.this.listIterator.remove();
                }
            };
        }
    }
}

