/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.util;

import ch.bruker.util.BUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BFileUtil {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final String PATH_SEPARATOR = "/";

    public static void addFilesToExistingZip(File inputZipFile, File outputZipFile, File[] files, File pathToBeRemoved, File pathToBeAdded) throws Exception {
        File tempFile = null;
        ZipInputStream zin = null;
        ZipOutputStream out = null;
        Closeable in = null;
        try {
            if (outputZipFile == null) {
                tempFile = File.createTempFile(inputZipFile.getName(), null);
                tempFile.delete();
                boolean renameOk = false;
                try {
                    renameOk = inputZipFile.renameTo(tempFile);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!renameOk) {
                    try {
                        tempFile = new File(inputZipFile.getPath() + ".tmp");
                        tempFile.delete();
                        renameOk = inputZipFile.renameTo(tempFile);
                    }
                    catch (Exception e) {
                        renameOk = false;
                    }
                }
                if (!renameOk) {
                    throw new IOException("could not rename the file " + inputZipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
                }
                zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(tempFile), 65536));
                out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(inputZipFile), 65536));
            } else {
                zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(inputZipFile), 65536));
                out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputZipFile), 65536));
            }
            for (int i = 0; i < files.length; ++i) {
                BFileUtil.addFileOrDireytroyToZip(out, files[i], pathToBeRemoved, pathToBeAdded);
            }
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                int len;
                String name = entry.getName();
                try {
                    out.putNextEntry(new ZipEntry(name));
                }
                catch (ZipException e) {
                    entry = zin.getNextEntry();
                    continue;
                }
                byte[] buf = new byte[65536];
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                entry = zin.getNextEntry();
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(out);
                BUtil.closeIgnoringExceptions(zin);
                BUtil.closeIgnoringExceptions(in);
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
        }
        BUtil.closeIgnoringExceptions(out);
        BUtil.closeIgnoringExceptions(zin);
        BUtil.closeIgnoringExceptions(in);
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addFileOrDireytroyToZip(ZipOutputStream out, File file, File pathToBeRemoved, File pathToBeAdded) throws Exception {
        BufferedInputStream in = null;
        if (file.isDirectory()) {
            if (file.getName().equals(".svn")) {
                return;
            }
            File[] dirList = file.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                BFileUtil.addFileOrDireytroyToZip(out, dirList[i], pathToBeRemoved, pathToBeAdded);
            }
            return;
        }
        byte[] buf = new byte[65536];
        in = new BufferedInputStream(new FileInputStream(file), 65536);
        try {
            String newPathToBeAdded;
            String name = file.getPath().replace(File.separator, PATH_SEPARATOR);
            String newPathToBeRemoved = pathToBeRemoved.getPath().replace(File.separator, PATH_SEPARATOR);
            int begin = name.lastIndexOf(newPathToBeRemoved);
            if (0 <= begin && newPathToBeRemoved.length() > 0) {
                name = name.substring(begin + newPathToBeRemoved.length());
                File newFile = BFileUtil.cleanFilePath(new File(name));
                name = newFile.getPath().replace(File.separator, PATH_SEPARATOR);
            }
            if (pathToBeAdded != null && (newPathToBeAdded = pathToBeAdded.getPath().replace(File.separator, PATH_SEPARATOR)).length() > 0) {
                name = newPathToBeAdded + PATH_SEPARATOR + name;
            }
            out.putNextEntry(new ZipEntry(name));
        }
        catch (ZipException e) {
            BUtil.closeIgnoringExceptions(in);
            BUtil.closeIgnoringExceptions(in);
            return;
        }
        try {
            int len;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(in);
                throw throwable;
            }
        }
        BUtil.closeIgnoringExceptions(in);
        return;
    }

    private static File cleanFilePath(File file) {
        File newFile = file;
        String path = file.getPath();
        if (path.startsWith(File.separator)) {
            newFile = new File(path.substring(File.separator.length(), path.length()));
        } else if (path.startsWith(PATH_SEPARATOR)) {
            newFile = new File(path.substring(1, path.length()));
        }
        return newFile;
    }

    public static String readFirstLineOfFile(String filename) throws IOException {
        return BFileUtil.readFirstLineOfFile(new File(filename));
    }

    public static String readFirstLineOfFile(File file) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            string = line = reader.readLine();
        }
        catch (IOException ioe) {
            try {
                throw ioe;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(reader);
                throw throwable;
            }
        }
        BUtil.closeIgnoringExceptions(reader);
        return string;
    }

    public static void writeTextFile(String filename, String cont) throws Exception {
        BFileUtil.writeTextFile(new File(filename), cont);
    }

    public static void writeTextFile(File file, String cont) throws Exception {
        FileWriter fos = null;
        try {
            fos = new FileWriter(file);
            fos.write(cont);
            fos.flush();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(fos);
                throw throwable;
            }
        }
        BUtil.closeIgnoringExceptions(fos);
    }

    public static void appendToTextFile(File file, String cont) throws Exception {
        FileWriter fos = null;
        try {
            fos = new FileWriter(file, true);
            fos.write(cont);
            fos.flush();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(fos);
                throw throwable;
            }
        }
        BUtil.closeIgnoringExceptions(fos);
    }

    public static byte[] readFile(String filename) throws Exception {
        return BFileUtil.readFile(new File(filename));
    }

    public static byte[] readFile(File file) throws Exception {
        byte[] byArray;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inStream.read(data);
            byArray = data;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(inStream);
                throw throwable;
            }
        }
        BUtil.closeIgnoringExceptions(inStream);
        return byArray;
    }

    public static void writeFile(String filename, byte[] data) throws Exception {
        BFileUtil.writeFile(new File(filename), data);
    }

    public static void writeFile(File file, byte[] data) throws Exception {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            outStream.write(data);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(outStream);
                throw throwable;
            }
        }
        BUtil.closeIgnoringExceptions(outStream);
    }

    public static int forceRead(InputStream is, byte[] bytes) throws IOException {
        int offset;
        int nRead = 0;
        for (offset = 0; offset < bytes.length && (nRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += nRead) {
        }
        return nRead == -1 ? -1 : offset;
    }

    public static void zipFiles(File zipFile, File[] filesToZip) throws IOException {
        BFileUtil.zipFiles(zipFile, filesToZip, new String[filesToZip.length]);
    }

    public static void zipFiles(File zipFile, File[] filesToZip, String[] names) throws IOException {
        BFileUtil.zipFiles(zipFile, filesToZip, names, null);
    }

    public static void zipFiles(File zipFile, File[] filesToZip, String[] names, ProgressListener zipProgressListener) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 65536));
        int i = -1;
        for (File file : filesToZip) {
            String filename = names == null || names[++i] == null ? file.getName() : names[i];
            ZipEntry entry = new ZipEntry(filename);
            zipOutputStream.putNextEntry(entry);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 65536);
            int len = 0;
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, len);
            }
            in.close();
            zipOutputStream.closeEntry();
            if (zipProgressListener == null) continue;
            zipProgressListener.progressChanged((int)(100.0 * (double)i / (double)filesToZip.length));
        }
        zipOutputStream.close();
    }

    public static List<File> unzipFiles(File zipFile, File destFolder) throws IOException {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        BufferedOutputStream dest = null;
        Vector<File> extractedFiles = new Vector<File>();
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File extractedFile = new File(destFolder, entry.getName());
                if (entry.isDirectory()) {
                    extractedFile.mkdirs();
                } else {
                    int count;
                    byte[] data = new byte[65536];
                    extractedFile.getParentFile().mkdirs();
                    dest = new BufferedOutputStream(new FileOutputStream(extractedFile), 65536);
                    while ((count = zis.read(data, 0, 65536)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                }
                extractedFiles.add(extractedFile);
            }
            zis.close();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            BUtil.closeIgnoringExceptions(zis);
            BUtil.closeIgnoringExceptions(dest);
        }
        return extractedFiles;
    }

    public static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        try {
            byte[] buf = new byte[65536];
            int i = 0;
            while ((i = fis.read(buf)) > 0) {
                fos.write(buf, 0, i);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            BUtil.closeIgnoringExceptions(fis);
            BUtil.closeIgnoringExceptions(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String fileName, int maxLength) {
        String string;
        RandomAccessFile raf = null;
        StringBuilder sb = new StringBuilder();
        try {
            raf = new RandomAccessFile(fileName, "r");
            long length = raf.length();
            if (maxLength != -1 && length > (long)maxLength) {
                raf.seek(length - (long)maxLength);
            }
            byte[] buffer = new byte[8192];
            int l = 0;
            while ((l = raf.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, l));
            }
            string = sb.toString();
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = "Cannot read " + fileName + ". err=" + e.getMessage();
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(raf);
                throw throwable;
            }
            BUtil.closeIgnoringExceptions(raf);
            return string2;
        }
        BUtil.closeIgnoringExceptions(raf);
        return string;
    }

    public static class FileEndingFilter
    implements FilenameFilter {
        public final String fileEnding;

        public FileEndingFilter(String fileEnding) {
            this.fileEnding = fileEnding.toLowerCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(this.fileEnding);
        }
    }

    public static interface ProgressListener {
        public void progressChanged(int var1);
    }
}

