/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.mon.xml;

import ch.bruker.mon.xml.Address;
import ch.bruker.mon.xml.Contact;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="MonitoringCIXml")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MonitoringCIXml {
    @XmlElement
    private int xmlVersion;
    @XmlElementWrapper(name="addresses")
    @XmlElement(name="address")
    private List<Address> addresses;
    @XmlElementWrapper(name="contacts")
    @XmlElement(name="contact")
    private List<Contact> contacts;

    private MonitoringCIXml() {
        this(1, new ArrayList<Address>(), new ArrayList<Contact>());
    }

    public MonitoringCIXml(int xmlVersion, List<Address> addresses, List<Contact> contacts) {
        this.xmlVersion = xmlVersion;
        this.addresses = addresses;
        this.contacts = contacts;
    }

    public int getXmlVersion() {
        return this.xmlVersion;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public Address getAddress(int addressNumber) {
        for (Address a2 : this.getAddresses()) {
            if (a2.address_number != addressNumber) continue;
            return a2;
        }
        return null;
    }

    public Contact getContact(int contactNumber) {
        for (Contact c2 : this.getContacts()) {
            if (c2.contact_number != contactNumber) continue;
            return c2;
        }
        return null;
    }

    public boolean equals(MonitoringCIXml other) {
        if (other == null) {
            return false;
        }
        if (this.xmlVersion != other.xmlVersion) {
            return false;
        }
        if (this.addresses != null && other.addresses == null || this.addresses == null && other.addresses != null) {
            return false;
        }
        if (this.addresses != null && other.addresses != null) {
            if (this.addresses.size() != other.addresses.size()) {
                return false;
            }
            for (Address a2 : this.addresses) {
                if (a2.equals(other.getAddress(a2.address_number))) continue;
                return false;
            }
        }
        if (this.contacts != null && other.contacts == null || this.contacts == null && other.contacts != null) {
            return false;
        }
        if (this.contacts != null && other.contacts != null) {
            if (this.contacts.size() != other.contacts.size()) {
                return false;
            }
            for (Contact c2 : this.contacts) {
                if (c2.equals(other.getContact(c2.contact_number))) continue;
                return false;
            }
        }
        return true;
    }
}

