/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.timer;

import ch.bruker.jac.servicegui.AbstractState;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.status.ui.LoadingCompleteCallback;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimerState
extends AbstractState {
    private static final String VALUE_NOT_AVAILABLE = "0;0;0;0";
    final AppState app;
    private final ApiTalker api;
    JacTimer[] timers;
    JacTimer currentTimer;
    Component parent;

    TimerState(AppState appState, ApiTalker api) {
        super("Timer");
        this.app = appState;
        this.api = api;
        this.timers = new JacTimer[]{new JacTimer("JAC_TIMER_1", 1), new JacTimer("JAC_TIMER_2", 2), new JacTimer("JAC_TIMER_3", 3), new JacTimer("JAC_TIMER_4", 4), new JacTimer("JAC_TIMER_5", 5)};
        this.currentTimer = this.timers[0];
    }

    void setCurrentTimer(int idx) {
        this.currentTimer = this.timers[idx];
        this.updates.post(this.currentTimer);
    }

    List<String> getCommands() {
        return ImmutableList.copyOf(((ImmutableMap)this.app.system.timerPars.row((Object)this.app.getUserLevel())).values());
    }

    String getIdFor(String label) {
        for (Map.Entry entry : ((ImmutableMap)this.app.system.timerPars.row((Object)this.app.getUserLevel())).entrySet()) {
            if (!((String)entry.getValue()).equals(label)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    String getLabelFor(String parId) {
        Map labels = this.app.system.timerPars.column((Object)parId);
        String label = (String)((ImmutableMap)labels).get((Object)this.app.getUserLevel());
        if (label == null) {
            label = ((ImmutableCollection)((ImmutableMap)labels).values()).iterator().hasNext() ? (String)((ImmutableCollection)((ImmutableMap)labels).values()).iterator().next() : parId;
        }
        return label;
    }

    public boolean anyTimerActive() {
        for (JacTimer timer : this.timers) {
            if (timer.isEmpty()) continue;
            return true;
        }
        return false;
    }

    BiMap<Integer, String> fetchOptions(String parId) {
        HashBiMap<Integer, String> options = HashBiMap.create();
        if (parId == null) {
            return options;
        }
        try {
            JacControl.JacPropertyExt p = this.api.getConnection().getParameter(parId);
            for (JacControl.JacPropertyEntryName option : p.allowedValues) {
                options.put(option.value.Int32Val(), option.name);
            }
        }
        catch (JacControl.JacParamNotAvailable ioe) {
            ioe.printStackTrace();
        }
        return options;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    class JacTimer {
        private final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern("yyyy/MM/dd HH:mm:ss.SSS").withZoneUTC();
        final String parId;
        final int nr;
        private String actionParId;
        String value;
        ReadableInstant due;
        private BiMap<Integer, String> options;

        JacTimer(String parId, int nr) {
            this.parId = parId;
            this.nr = nr;
            this.pull();
        }

        void pull() {
            TimerState.this.api.schedule(this.parId, new LoadingCompleteCallback(){

                @Override
                public void with(JacControl.JacPropertyExt prop) {
                    String value = prop.value.StringVal();
                    if (value.isEmpty() || value.equals(TimerState.VALUE_NOT_AVAILABLE)) {
                        if (!JacTimer.this.isEmpty()) {
                            JacTimer.this.clear();
                        }
                        return;
                    }
                    String[] vals = value.split(";", 4);
                    if (vals.length != 4) {
                        return;
                    }
                    try {
                        JacTimer.this.due = JacTimer.this.FORMATTER.parseDateTime(vals[0]);
                    }
                    catch (IllegalArgumentException iae) {
                        SGUtils.log("Illegal timer-parameter datetime. Clearing timer %s.", JacTimer.this.parId);
                        JacTimer.this.clear();
                        return;
                    }
                    JacTimer.this.actionParId = vals[1];
                    JacTimer.this.getOptions();
                    try {
                        int i = Integer.parseInt(vals[2]);
                        if (i >= 0 && i < JacTimer.this.options.size()) {
                            JacTimer.this.value = (String)JacTimer.this.options.get(i);
                        }
                    }
                    catch (NumberFormatException ignore) {
                        JacTimer.this.value = "{" + vals[2] + "}";
                    }
                }
            });
        }

        void push() {
            String vals;
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            if (this.isEmpty()) {
                vals = TimerState.VALUE_NOT_AVAILABLE;
            } else {
                if (TimerState.this.app.system.timerPars.get((Object)TimerState.this.app.getUserLevel(), this.actionParId) == null) {
                    return;
                }
                vals = this.FORMATTER.print(this.due) + ';' + this.actionParId + ';' + this.getOptions().inverse().get(this.value) + ";" + "0";
            }
            valueType.StringVal(vals);
            JacCommon.JacProperty jacProperty = new JacCommon.JacProperty(this.parId, valueType);
            try {
                TimerState.this.api.getConnection().pushParameters(TimerState.this.api.getKey(), new JacCommon.JacProperty[]{jacProperty});
            }
            catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
                JOptionPane.showMessageDialog(TimerState.this.parent, "Error: " + jacParamNotAvailable.statement, "Error", 0);
            }
        }

        String getLabel() {
            if (this.actionParId == null) {
                return "";
            }
            return TimerState.this.getLabelFor(this.actionParId);
        }

        BiMap<Integer, String> getOptions() {
            if (this.options == null) {
                this.options = TimerState.this.fetchOptions(this.actionParId);
            }
            return this.options;
        }

        void clear() {
            this.actionParId = null;
            this.value = null;
            this.due = null;
        }

        boolean isEmpty() {
            return this.actionParId == null;
        }

        public void setActionParId(String actionParId) {
            this.actionParId = actionParId;
            this.options = null;
        }
    }
}

