/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.timer;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.Tab;
import ch.bruker.jac.servicegui.img.Images;
import ch.bruker.jac.servicegui.timer.TimerState;
import ch.bruker.util.JDateTimeField;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Partial;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimerPanel
extends JPanel {
    private static final int NR = 0;
    private static final int UNIT = 1;
    private static final int COMMAND = 2;
    private static final int DATE = 3;
    private static final int TIME = 4;
    private static final int COUNTDOWN = 5;
    private static final String NDEF = "<html><font color=gray>(Please select\u2026)</font></html>";
    private static final ImageIcon CLOCK = new ImageIcon(Images.class.getResource("Timer10.png"));
    private final JComboBox commandBox;
    private final JComboBox valueBox;
    private final JDateChooser dateField;
    private final JDateTimeField timeField;
    private final JButton btnRight;
    private final JButton btnLeft;
    private final TimerState state;
    private JTable table;
    private final TableModel adaptor = new TableModel(){

        @Override
        public int getRowCount() {
            return 5;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int idx) {
            switch (idx) {
                case 0: {
                    return "Nr";
                }
                case 1: {
                    return "Target";
                }
                case 2: {
                    return "Command / Value";
                }
                case 3: {
                    return "Year/Month/Day";
                }
                case 4: {
                    return "Hour/Min";
                }
                case 5: {
                    return "Countdown";
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int idx) {
            switch (idx) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: 
                case 4: {
                    return DateTime.class;
                }
                case 5: {
                    return Duration.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int viewRow, int idx) {
            TimerState.JacTimer timer = ((TimerPanel)TimerPanel.this).state.timers[viewRow];
            switch (idx) {
                case 0: {
                    return "#" + timer.nr;
                }
                case 1: {
                    return timer.getLabel();
                }
                case 2: {
                    if (timer.isEmpty()) {
                        return "";
                    }
                    return timer.value;
                }
                case 3: 
                case 4: {
                    return timer.due;
                }
                case 5: {
                    return new Duration(DateTime.now(), timer.due);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    };

    public TimerPanel(final Tab parent, final TimerState state) {
        this.state = state;
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{10, 0, 80, 80, 10};
        layout.rowHeights = new int[]{40, 0, 40, 0, 0, 0};
        layout.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        layout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(layout);
        Font bold = this.getFont().deriveFont(1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 16;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 1;
        gbc.gridy = 0;
        JLabel label = new JLabel("Schedule Action:");
        label.setFont(bold);
        this.add((Component)label, gbc);
        ActionListener sanityCheck = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimerPanel.this.sanityCheck();
            }
        };
        JPanel flowing = new JPanel();
        gbc.gridy = 1;
        this.add((Component)flowing, gbc);
        flowing.setLayout(new FlowLayout(0, 10, 5));
        flowing.setBorder(new EmptyBorder(0, -5, 0, 0));
        JLabel lblSet = new JLabel("Tell");
        flowing.add(lblSet);
        this.commandBox = new JComboBox();
        this.commandBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected = TimerPanel.this.commandBox.getSelectedItem();
                if (selected == null) {
                    return;
                }
                TimerPanel.this.updateValueOptions();
            }
        });
        this.commandBox.addActionListener(sanityCheck);
        this.commandBox.setPreferredSize(new Dimension(160, this.commandBox.getPreferredSize().height));
        flowing.add(this.commandBox);
        JLabel lblTo = new JLabel("to");
        flowing.add(lblTo);
        this.valueBox = new JComboBox();
        this.valueBox.addActionListener(sanityCheck);
        this.valueBox.setPreferredSize(new Dimension(160, this.valueBox.getPreferredSize().height));
        flowing.add(this.valueBox);
        JLabel lblAt = new JLabel("at");
        flowing.add(lblAt);
        this.dateField = new JDateChooser();
        this.dateField.setMinSelectableDate(DateTime.now().toDate());
        this.dateField.setDateFormatString("yyyy/MM/dd");
        flowing.add(this.dateField);
        this.timeField = new JDateTimeField("HH:mm", DateTimeZone.getDefault());
        this.timeField.addActionListener(sanityCheck);
        flowing.add(this.timeField);
        this.btnLeft = new JButton("Remove");
        this.btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                state.currentTimer.clear();
                state.currentTimer.push();
                TimerPanel.this.handleCurrentTimerUpdate(state.currentTimer);
                TimerPanel.this.table.getRowSorter().allRowsChanged();
                TimerPanel.this.repaint();
            }
        });
        this.btnLeft.setEnabled(false);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.anchor = 10;
        this.add((Component)this.btnLeft, gbc);
        this.btnRight = new JButton("Add");
        this.btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimerState.JacTimer t = state.currentTimer;
                DateTime time = TimerPanel.this.timeField.getDateTime();
                DateTime day = new DateTime(TimerPanel.this.dateField.getDate());
                Partial partial = new Partial().with(DateTimeFieldType.year(), day.getYear()).with(DateTimeFieldType.dayOfYear(), day.getDayOfYear());
                DateTime dt = time.withFields(partial);
                if (!dt.isAfterNow()) {
                    JOptionPane.showMessageDialog(parent, "The selected instant lies in the past.", "Error", 0);
                    TimerPanel.this.timeField.grabFocus();
                    TimerPanel.this.timeField.selectAll();
                    return;
                }
                String actionParId = state.getIdFor(TimerPanel.this.commandBox.getSelectedItem().toString());
                if (actionParId == null) {
                    return;
                }
                t.setActionParId(actionParId);
                t.value = (String)TimerPanel.this.valueBox.getSelectedItem();
                t.due = dt;
                t.push();
                TimerPanel.this.table.getRowSorter().allRowsChanged();
                TimerPanel.this.handleCurrentTimerUpdate(t);
            }
        });
        gbc.gridx = 3;
        this.add((Component)this.btnRight, gbc);
        JLabel label2 = new JLabel("Currently Scheduled:");
        label2.setFont(bold);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add((Component)label2, gbc);
        this.table = new JTable(this.adaptor);
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        this.table.setDefaultRenderer(DateTime.class, new DateRenderer());
        this.table.getColumnModel().getColumn(4).setCellRenderer(new TimeRenderer());
        CountDownRenderer renderer = new CountDownRenderer();
        renderer.setHorizontalAlignment(4);
        this.table.setDefaultRenderer(Duration.class, renderer);
        this.table.setSelectionMode(0);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.adaptor);
        sorter.setSortKeys(ImmutableList.of(new RowSorter.SortKey(5, SortOrder.ASCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        sorter.setComparator(5, new Comparator<Duration>(){

            @Override
            public int compare(Duration left, Duration right) {
                if (left.getMillis() == 0L) {
                    return 1;
                }
                if (right.getMillis() == 0L) {
                    return -1;
                }
                return (int)(left.getMillis() - right.getMillis());
            }
        });
        sorter.setComparator(0, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                return left.compareTo(right);
            }
        });
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        sorter.setSortable(2, false);
        sorter.setSortable(3, false);
        sorter.setSortable(4, false);
        sorter.setSortable(5, false);
        this.table.setRowSorter(sorter);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(120);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                state.setCurrentTimer(TimerPanel.this.table.convertRowIndexToModel(TimerPanel.this.table.getSelectedRow()));
            }
        });
        this.table.getRowSorter().allRowsChanged();
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 2;
        gbc.gridy = 3;
        JScrollPane comp = new JScrollPane(this.table);
        comp.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)comp, gbc);
        this.updateCommandOptions();
        this.table.setRowSelectionInterval(0, 0);
        Timer repainter = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!parent.isActive()) {
                    return;
                }
                TimerPanel.this.repaint();
            }
        });
        repainter.start();
        repainter.setRepeats(true);
        ScheduledExecutorService reloader = Executors.newSingleThreadScheduledExecutor();
        reloader.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (!state.app.mode.isInteractive) {
                    return;
                }
                JTabbedPane tabbedPane = parent.getTabbedPane();
                for (TimerState.JacTimer timer : state.timers) {
                    timer.pull();
                }
                if (tabbedPane != null) {
                    tabbedPane.setIconAt(parent.getTabbedPaneIdx(), state.anyTimerActive() ? CLOCK : null);
                }
                TimerPanel.this.table.getRowSorter().allRowsChanged();
            }
        }, 5L, 3L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleCurrentTimerUpdate(TimerState.JacTimer current) {
        if (this.state.getCommands().contains(current.getLabel())) {
            this.commandBox.setSelectedItem(current.getLabel());
        } else {
            this.commandBox.setSelectedIndex(this.commandBox.getItemCount() - 1);
        }
        this.updateValueOptions();
        ReadableInstant due = null;
        if (current.isEmpty()) {
            this.btnRight.setText("Add");
            this.btnLeft.setEnabled(false);
        } else {
            due = current.due;
            this.btnRight.setText("Modify");
            this.btnLeft.setEnabled(true);
        }
        if (due == null) {
            due = DateTime.now().plusMinutes(5);
        }
        this.dateField.setDate(due.toInstant().toDate());
        this.timeField.setDateTime(due);
        this.sanityCheck();
    }

    @Subscribe
    public void handleModeUpdate(GuiMode mode) {
        for (Component c2 : this.getComponents()) {
            c2.setEnabled(mode.isInteractive);
        }
        this.repaint();
    }

    @Subscribe
    public void handleUserLevelUpdate(JacPublicDefinitions.UserLevel userLevel) {
        this.updateCommandOptions();
        this.sanityCheck();
    }

    private void updateCommandOptions() {
        List<String> commands = this.state.getCommands();
        String selected = (String)this.commandBox.getSelectedItem();
        this.setBoxOptions(this.commandBox, commands, selected);
        this.updateValueOptions();
    }

    private void updateValueOptions() {
        String actionParId = this.state.getIdFor(this.commandBox.getSelectedItem().toString());
        this.setBoxOptions(this.valueBox, this.state.fetchOptions(actionParId).values(), this.state.currentTimer.value);
        this.repaint();
    }

    private void sanityCheck() {
        boolean insane = this.commandBox.getSelectedItem() == null || this.commandBox.getSelectedItem().equals(NDEF) || this.valueBox.getSelectedItem() == null || this.valueBox.getSelectedItem().equals(NDEF) || this.dateField.getDate() == null || this.timeField.getDateTime() == null;
        this.btnRight.setEnabled(!insane);
    }

    private void setBoxOptions(JComboBox box, Collection<String> options, String selected) {
        box.removeAllItems();
        box.addItem(NDEF);
        for (String option : options) {
            box.addItem(option);
        }
        if (!options.contains(selected)) {
            selected = NDEF;
        }
        box.setSelectedItem(selected);
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return this;
        }
    }

    private class TimeRenderer
    extends CellRenderer {
        private DateTimeFormatter formatter = DateTimeFormat.forPattern("HH:mm").withZone(DateTimeZone.getDefault());

        private TimeRenderer() {
        }

        @Override
        public void setValue(Object value) {
            try {
                if (value != null) {
                    value = this.formatter.print((ReadableInstant)value);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            super.setValue(value);
        }
    }

    private class DateRenderer
    extends CellRenderer {
        private DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd").withZone(DateTimeZone.getDefault());

        private DateRenderer() {
        }

        @Override
        public void setValue(Object value) {
            try {
                if (value != null) {
                    value = this.formatter.print((ReadableInstant)value);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            super.setValue(value);
        }
    }

    private class CountDownRenderer
    extends CellRenderer {
        private CountDownRenderer() {
        }

        @Override
        public void setValue(Object value) {
            try {
                if (value == null || ((Duration)value).getMillis() == 0L) {
                    super.setValue("");
                    return;
                }
                Duration duration = (Duration)value;
                value = SGUtils.PERIOD_FORMATTER.print(duration.toPeriod());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            super.setValue(value);
        }
    }
}

