/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.text;

import ch.bruker.jac.servicegui.GlobalPanel;
import ch.bruker.jac.servicegui.Tab;
import ch.bruker.jac.servicegui.text.TextLogPanel;
import ch.bruker.jac.servicegui.text.TextLogState;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormatter;

public class TextLogTab
extends Tab {
    private final TextLogPanel textLogPanel;
    private final TextLogState state;
    private final JLabel rangeInfo;

    public TextLogTab(TextLogState state) {
        this.state = state;
        this.textLogPanel = new TextLogPanel(state);
        state.registerUpdates(this.textLogPanel);
        this.rangeInfo = new JLabel();
        GlobalPanel nav = new GlobalPanel(state.app, new JLabel("Displayed range:"), this.rangeInfo);
        state.updates.register(nav);
        state.app.updates.register(nav);
        this.setLayout(new GridBagLayout());
        this.add((Component)nav, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 10, 10));
        this.add((Component)this.textLogPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 10, 10));
        state.app.updates.register(this);
    }

    @Subscribe
    public void handleScopeUpdate(Interval interval) {
        int size = this.state.currentErrorList.size();
        Interval scope = this.state.app.getScope();
        DateTimeFormatter df = this.state.app.zonedDateTimeFormat();
        this.rangeInfo.setText(df.print(scope.getStart()) + " - " + df.print(scope.getEnd()) + " (" + size + ")");
    }
}

