/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.text;

import ch.bruker.jac.servicegui.AbstractState;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.data.CacheUpdate;
import ch.bruker.jac.servicegui.data.FileTimeTile;
import ch.bruker.jac.servicegui.data.HwClock;
import ch.bruker.jac.servicegui.data.Tag;
import ch.bruker.jac.servicegui.data.TimeMap;
import ch.bruker.jac.servicegui.text.TextLogPanel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Future;
import javax.swing.AbstractListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class TextLogState
extends AbstractState {
    final AppState app;
    List<Tag<String>> currentErrorList = ImmutableList.of();
    private Future busy = null;
    SelectionAdaptor selectionAdaptor = new SelectionAdaptor();
    private Interval currentScope;
    ListModel modelAdaptor = new ListModel();

    public TextLogState(AppState appState) {
        super("TextLog");
        this.app = appState;
        this.updates.register(this.modelAdaptor);
        this.app.updates.register(this.modelAdaptor);
        this.app.updates.register(this.selectionAdaptor);
    }

    public void registerUpdates(TextLogPanel textLogPanel) {
        this.updates.register(textLogPanel);
        this.app.updates.register(textLogPanel);
    }

    @Subscribe
    public void handleCacheUpdates(CacheUpdate update) {
        if (update.span.overlaps(this.app.getScope()) && update.timeTile instanceof FileTimeTile) {
            this.modelAdaptor.updateErrorList();
        }
    }

    private class ListModel
    extends AbstractListModel {
        static final int MAX_SIZE = 5000;
        static final int MODEL_UPDATE_RESERVE = 10;
        int offset = 0;
        int idx = 0;

        private ListModel() {
        }

        @Override
        public int getSize() {
            return Math.min(5000, TextLogState.this.currentErrorList.size());
        }

        @Override
        public Object getElementAt(int index) {
            try {
                return TextLogState.this.currentErrorList.get(index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return TextLogState.this.currentErrorList.get(this.offset);
            }
        }

        @Subscribe
        public void handleModelUpdate(ErrorListUpdate errorListUpdate) {
            TextLogState.this.selectionAdaptor.selectionUpdate(false);
            this.fireContentsChanged(this, 0, this.getSize());
            TextLogState.this.selectionAdaptor.fireSelectionIndexChanged();
        }

        @Subscribe
        public void handleScopeUpdates(Interval scope) {
            if (TextLogState.this.currentScope == null) {
                TextLogState.this.currentScope = scope;
            }
            Interval below = this.between(TextLogState.this.currentScope.getStart(), scope.getStart());
            Interval above = this.between(TextLogState.this.currentScope.getEnd(), scope.getEnd());
            if (!TextLogState.this.app.getErrors().get(below).isEmpty() || !TextLogState.this.app.getErrors().get(above).isEmpty()) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            TextLogState.this.currentScope = scope;
        }

        private Interval between(DateTime foo, DateTime bar) {
            return foo.isBefore(bar) ? new Interval((ReadableInstant)foo, (ReadableInstant)bar) : new Interval((ReadableInstant)bar, (ReadableInstant)foo);
        }

        private void updateErrorList() {
            if (TextLogState.this.busy != null && !TextLogState.this.busy.isDone()) {
                return;
            }
            TextLogState.this.busy = TextLogState.this.app.doAsync(new Runnable(){

                @Override
                public void run() {
                    boolean update = true;
                    List<Tag<String>> errors = ImmutableList.copyOf(TextLogState.this.app.getErrors().get(Range.<HwClock>all()));
                    ListIterator iterator = errors.listIterator(0);
                    while (iterator.hasNext()) {
                        Tag before = (Tag)iterator.next();
                        if (before.dateTime.isBefore(TextLogState.this.app.getCursor())) continue;
                    }
                    ListModel.this.idx = iterator.previousIndex();
                    int offsetShift = 0;
                    if (errors.size() > 5000) {
                        if (TextLogState.this.selectionAdaptor.getMinSelectionIndex() < 10 || TextLogState.this.selectionAdaptor.getMaxSelectionIndex() > TextLogState.this.currentErrorList.size() - 10 || TextLogState.this.app.isMode(GuiMode.TRACKING)) {
                            ListModel.this.offset = Math.max(0, ListModel.this.idx - 2500);
                            errors = errors.subList(Math.max(ListModel.this.offset, 0), Math.min(ListModel.this.offset + 5000, errors.size()));
                            offsetShift = errors.size() - 1 + ListModel.this.offset - ListModel.this.idx;
                        } else {
                            update = false;
                        }
                    } else if (ListModel.this.idx < 5000) {
                        ListModel.this.offset = 0;
                        offsetShift = errors.size() - 1 - ListModel.this.idx;
                    } else {
                        ListModel.this.idx = 0;
                        ListModel.this.offset = errors.size() - 1;
                    }
                    if (update && !((Object)(errors = Lists.reverse(errors))).equals(TextLogState.this.currentErrorList)) {
                        TextLogState.this.currentErrorList = errors;
                        TextLogState.this.app.updates.post(new ErrorListUpdate(offsetShift));
                    }
                }
            });
        }
    }

    class ErrorListUpdate {
        final int offsetShift;

        public ErrorListUpdate(int offsetShift) {
            this.offsetShift = offsetShift;
        }
    }

    private class SelectionAdaptor
    implements ListSelectionModel {
        private Collection<Tag<String>> selectedTags = ImmutableList.of();
        private Range<Integer> selectionIdx = null;
        private List<ListSelectionListener> listeners = new LinkedList<ListSelectionListener>();

        private SelectionAdaptor() {
        }

        @Override
        public int getMinSelectionIndex() {
            if (this.selectionIdx == null) {
                return 0;
            }
            return this.selectionIdx.lowerEndpoint();
        }

        @Override
        public int getMaxSelectionIndex() {
            if (this.selectionIdx == null) {
                return 0;
            }
            return this.selectionIdx.upperEndpoint();
        }

        void fireSelectionIndexChanged() {
            ListSelectionEvent event = new ListSelectionEvent(this, 0, TextLogState.this.currentErrorList.size(), false);
            for (ListSelectionListener listener : this.listeners) {
                listener.valueChanged(event);
            }
        }

        @Subscribe
        public void handleCursorUpdate(DateTime cursor) {
            TimeMap.MultiAxis<String> errors = TextLogState.this.app.getErrors();
            if (errors == null) {
                return;
            }
            this.selectedTags = errors.getLower(cursor);
            this.selectionUpdate(true);
            if (errors.size() > 5000) {
                TextLogState.this.modelAdaptor.updateErrorList();
            }
        }

        private void selectionUpdate(boolean fireSelectionIndexChanged) {
            Range<Integer> oldSecelctionIndex = this.selectionIdx;
            this.selectionIdx = null;
            if (this.selectedTags == null) {
                this.selectedTags = ImmutableList.of();
            }
            for (Tag<String> tag : this.selectedTags) {
                int idx = TextLogState.this.currentErrorList.indexOf(tag);
                if (this.selectionIdx == null) {
                    this.selectionIdx = Range.singleton(idx);
                    continue;
                }
                this.selectionIdx = this.selectionIdx.span(Range.singleton(idx));
            }
            if (fireSelectionIndexChanged && this.selectionIdx != null && !this.selectionIdx.equals(oldSecelctionIndex)) {
                this.fireSelectionIndexChanged();
            }
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            DateTime dateTime = TextLogState.this.currentErrorList.get((int)index0).dateTime;
            TextLogState.this.app.setTracking(false);
            TextLogState.this.app.setCursor(dateTime);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSelectedIndex(int index) {
            if (this.selectionIdx == null) {
                return false;
            }
            return this.selectionIdx.contains(index);
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.getMinSelectionIndex();
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.getMaxSelectionIndex();
        }

        @Override
        public void setLeadSelectionIndex(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearSelection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.selectedTags == null || this.selectedTags.isEmpty();
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void setSelectionMode(int selectionMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSelectionMode() {
            return 1;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener x) {
            this.listeners.add(x);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener x) {
            this.listeners.remove(x);
        }
    }
}

