/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.text;

import ch.bruker.jac.servicegui.data.Tag;
import ch.bruker.jac.servicegui.graphical.GraphTab;
import ch.bruker.jac.servicegui.text.TextLogState;
import ch.bruker.util.PopupListener;
import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextLogPanel
extends JPanel {
    private final TextLogState state;
    private JList list;

    public TextLogPanel(final TextLogState state) {
        this.state = state;
        this.list = new JList(state.modelAdaptor);
        this.list.setFixedCellHeight(20);
        this.list.setSelectionModel(state.selectionAdaptor);
        this.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.list, 20, 31);
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 5, 5));
        this.list.setCellRenderer(new ErrMsgCellRenderer());
        this.list.setTransferHandler(new ErrMsgTransferHandler());
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItemCopy = new JMenuItem("Copy");
        menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextLogPanel.this.list.getTransferHandler().exportToClipboard(TextLogPanel.this.list, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            }
        });
        menu.add(menuItemCopy);
        JMenuItem menuItemShowInGraph = new JMenuItem("Show in Graph Tab");
        menuItemShowInGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextLogPanel.this.jumpToErrorInGraphicalDataTab();
            }
        });
        menu.add(menuItemShowInGraph);
        this.list.add(menu);
        this.list.addMouseListener(new PopupListener(menu));
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    TextLogPanel.this.jumpToErrorInGraphicalDataTab();
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    TextLogPanel.this.jumpToErrorInGraphicalDataTab();
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TextLogPanel.this.list.ensureIndexIsVisible(TextLogPanel.this.list.getMaxSelectionIndex() + 1);
                TextLogPanel.this.list.ensureIndexIsVisible(TextLogPanel.this.list.getMinSelectionIndex() - 1);
                TextLogPanel.this.list.ensureIndexIsVisible(TextLogPanel.this.list.getMinSelectionIndex());
                if (state.app.getRootFrame().isActive()) {
                    TextLogPanel.this.list.grabFocus();
                }
            }
        });
        this.list.getActionMap().put("selectPreviousRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JList list = (JList)e.getSource();
                int idx = Math.max(list.getMinSelectionIndex() - 1, 0);
                list.setSelectedIndex(idx);
            }
        });
    }

    @Subscribe
    public void handleModelUpdate(TextLogState.ErrorListUpdate errorListUpdate) {
        final int shift = errorListUpdate.offsetShift + (this.list.getLastVisibleIndex() - this.list.getFirstVisibleIndex()) / 2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextLogPanel.this.list.ensureIndexIsVisible(shift);
            }
        });
    }

    private void jumpToErrorInGraphicalDataTab() {
        Tag error = (Tag)this.list.getSelectedValue();
        if (error == null) {
            return;
        }
        this.state.app.setCursor(error.dateTime);
        this.state.app.setScopeOnCursor(0.5);
        this.state.app.setActivePanel(GraphTab.class);
    }

    private class ErrMsgTransferHandler
    extends TransferHandler {
        private ErrMsgTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent comp) {
            JList list = (JList)comp;
            Tag tag = (Tag)list.getSelectedValue();
            if (tag == null) {
                return null;
            }
            return new StringSelection(tag.printAs(((TextLogPanel)TextLogPanel.this).state.app));
        }

        @Override
        public int getSourceActions(JComponent c2) {
            return 1;
        }
    }

    private class ErrMsgCellRenderer
    extends DefaultListCellRenderer {
        private ErrMsgCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean isFirstRow;
            cellHasFocus = false;
            Component cmp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DefaultListCellRenderer cell = (DefaultListCellRenderer)cmp;
            Tag tag = (Tag)value;
            boolean visible = ((TextLogPanel)TextLogPanel.this).state.app.getScope().contains(tag.dateTime);
            boolean onEvent = ((TextLogPanel)TextLogPanel.this).state.app.getCursor().equals(tag.dateTime);
            boolean bl = isFirstRow = list.getMinSelectionIndex() == index;
            if (isSelected && !onEvent && isFirstRow) {
                Color blue = cell.getBackground();
                Border spacer = BorderFactory.createEmptyBorder(0, 1, 2, 1);
                MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 0, 0, 0, blue);
                cell.setBorder(BorderFactory.createCompoundBorder(matteBorder, spacer));
            }
            if (!isSelected || !onEvent) {
                cell.setBackground(visible ? Color.white : new Color(230, 230, 230));
                cell.setForeground(visible ? Color.black : Color.darkGray);
            }
            cell.setText(tag.printAs(((TextLogPanel)TextLogPanel.this).state.app));
            return cell;
        }
    }
}

