/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.systems;

import ch.bruker.jac.servicegui.JacServiceGui;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.systems.JacType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.Preferences;

public class Settings {
    public final SpecificEnumField<ScalingModes> scaling = new SpecificEnumField<ScalingModes>("scaling", ScalingModes.class);
    public final SpecificEnumField<Timezones> timeZoneSource = new SpecificEnumField<Timezones>("timezone", Timezones.class);
    public final Field showAxes = new SpecificField("show_axes");
    public final Field showGrid = new SpecificField("show_grid");
    public final Field shadeOutliers = new SpecificField("shade_outliers");
    public final Field roundAxisRange = new SpecificField("round_axis_range");
    public static final OverrideableField openDialogPath = new OverrideableField("open_dialog_path", System.getProperty("user.home"));
    public static final Field workingPath = new GlobalField("working_path", System.getProperty("user.home") + "/jac_servicegui");
    public final Field colors = new SpecificField("colors");
    public static final Field textLogInTimeLine = new GlobalField("textlog_in_timeline", true);
    private final Preferences client;
    private JacType system = null;
    static Preferences global = Preferences.userNodeForPackage(JacServiceGui.class);

    public Settings(JacType system) {
        this.system = system;
        this.client = Preferences.userNodeForPackage(JacServiceGui.class).node(system.getFsName());
    }

    public class SpecificEnumField<E extends Enum<E>>
    extends Field {
        public final Class<E> clazz;

        SpecificEnumField(String id, Class<E> clazz) {
            super(id);
            this.clazz = clazz;
        }

        public void set(E choice) {
            this.getStore().putInt(this.id, ((Enum)choice).ordinal());
        }

        public E get() {
            int ordinal = this.getStore().getInt(this.id, (Integer)this.getDefault());
            return (E)((Enum[])this.clazz.getEnumConstants())[ordinal];
        }

        @Override
        Preferences getStore() {
            return Settings.this.client;
        }

        @Override
        Object getDefault() {
            return Settings.this.system.getDefault(this.id);
        }
    }

    public static abstract class Field {
        final String id;

        Field(String id) {
            this.id = id;
        }

        abstract Preferences getStore();

        abstract Object getDefault();

        public String getString() {
            return this.getStore().get(this.id, (String)this.getDefault());
        }

        public int getInt() {
            return this.getStore().getInt(this.id, (Integer)this.getDefault());
        }

        public boolean getBoolean() {
            return this.getStore().getBoolean(this.id, (Boolean)this.getDefault());
        }

        public Object getObject() {
            byte[] bytes = this.getStore().getByteArray(this.id, null);
            if (bytes != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                try {
                    return new ObjectInputStream(bais).readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.getDefault();
        }

        public void set(String str) {
            this.getStore().put(this.id, str);
        }

        public void set(int n) {
            this.getStore().putInt(this.id, n);
        }

        public void set(boolean b2) {
            this.getStore().putBoolean(this.id, b2);
        }

        public void set(Object o) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
                this.getStore().putByteArray(this.id, baos.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class OverrideableField
    extends GlobalField {
        private Object overrideValue = null;

        OverrideableField(String id, Object defObj) {
            super(id, defObj);
        }

        @Override
        public int getInt() {
            return this.overrideValue == null ? super.getInt() : ((Integer)this.overrideValue).intValue();
        }

        @Override
        public boolean getBoolean() {
            return this.overrideValue == null ? super.getBoolean() : ((Boolean)this.overrideValue).booleanValue();
        }

        @Override
        public Object getObject() {
            return this.overrideValue == null ? super.getObject() : this.overrideValue;
        }

        @Override
        public String getString() {
            return this.overrideValue == null ? super.getString() : (String)this.overrideValue;
        }

        public void setOverride(Object o) {
            this.overrideValue = o;
            SGUtils.log("'%s' overridden with '%s'", this.id, o);
        }
    }

    private static class GlobalField
    extends Field {
        private final Object defObj;

        GlobalField(String id, Object defObj) {
            super(id);
            this.defObj = defObj;
        }

        @Override
        Preferences getStore() {
            return global;
        }

        @Override
        Object getDefault() {
            return this.defObj;
        }
    }

    private class SpecificField
    extends Field {
        SpecificField(String id) {
            super(id);
        }

        @Override
        Preferences getStore() {
            return Settings.this.client;
        }

        @Override
        Object getDefault() {
            return Settings.this.system.getDefault(this.id);
        }
    }

    public static enum ScalingModes {
        BASE_DIV("Baseline & Division"),
        MIN_MAX("Minimum & Maximum");

        private final String label;

        private ScalingModes(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum Timezones {
        FROM_JAC("From logfile"),
        LOCAL("From this computer"),
        UTC("UTC");

        public final String label;

        private Timezones(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

