/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.systems;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.JacServiceGui;
import ch.bruker.jac.servicegui.status.AlphaStatusPanel;
import ch.bruker.jac.servicegui.status.CfpuStatusPanel;
import ch.bruker.jac.servicegui.status.CmuBnlStatusPanel;
import ch.bruker.jac.servicegui.status.CmuCfStatusPanel;
import ch.bruker.jac.servicegui.status.CmuRsStatusPanel;
import ch.bruker.jac.servicegui.status.CmuRzStatusPanel;
import ch.bruker.jac.servicegui.status.Cu5MriStatusPanel;
import ch.bruker.jac.servicegui.status.Cu5StatusPanel;
import ch.bruker.jac.servicegui.status.DdnpStatusPanel;
import ch.bruker.jac.servicegui.status.LevelsensorStatusPanel;
import ch.bruker.jac.servicegui.status.MasCrpLiftStatusPanel;
import ch.bruker.jac.servicegui.status.MasCrpPumpStationStatusPanel;
import ch.bruker.jac.servicegui.status.MmsBmpc3StatusPanel;
import ch.bruker.jac.servicegui.status.MmsBmu50UsrStatusPanel;
import ch.bruker.jac.servicegui.status.MmsBmu51UsRStatusPanel;
import ch.bruker.jac.servicegui.status.MmsBmu52UsStatusPanel;
import ch.bruker.jac.servicegui.status.MmsBmu53CfStatusPanel;
import ch.bruker.jac.servicegui.status.PcuStatusPanel;
import ch.bruker.jac.servicegui.status.RetrofitBmpcStatusPanel;
import ch.bruker.jac.servicegui.status.RetrofitCuStatusPanel;
import ch.bruker.jac.servicegui.status.StatusPanel;
import ch.bruker.jac.servicegui.status.StatusTab;
import ch.bruker.jac.servicegui.systems.Groups;
import ch.bruker.jac.servicegui.systems.Settings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.HashMap;

public enum JacType {
    NONE(new Builder("JAC", Groups.NONE, JacPublicDefinitions.SystemType.JAC)),
    PCU(new Builder("Prodigy", Groups.CRYO_COOLING_DEVICE, JacPublicDefinitions.SystemType.PCU).statusTab(PcuStatusPanel.class).addTimer("PCU_PRODIGY_TIMER_COMMAND", "Prodigy FSM", JacPublicDefinitions.UserLevel.USER, JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).changeDefault("show_axes", (Object)false)),
    CMU_RS(new Builder("CMU-RS", Groups.CRYOSTAT_MONITORING_UNIT, JacPublicDefinitions.SystemType.CMURS).statusTab(CmuRsStatusPanel.class).noTempLogin().changeDefault("show_axes", (Object)true).restrictUserPlots("CMU_PT100_TEMPERATURE0", "CMU_COMPRESSOR_FLOW", "CMU_COMPRESSOR_TEMP", "CMU_COMPRESSOR_ROOM_TEMP", "CMU_COMPRESSOR_STATE", "CMU_RS_TEMPERATURE2", "CMU_RS_PTC_TEMPERATURE", "CMU_HE_LEVEL_STATE")),
    CMU_BNL(new Builder("CMU-BNL", Groups.CRYOSTAT_MONITORING_UNIT, JacPublicDefinitions.SystemType.CMUBNL).statusTab(CmuBnlStatusPanel.class).noTempLogin().changeDefault("show_axes", (Object)true).restrictUserPlots("CMU_PT100_TEMPERATURE0", "CMU_N2PRESSURE", "CMU_COMPRESSOR_FLOW", "CMU_COMPRESSOR_TEMP", "CMU_COMPRESSOR_ROOM_TEMP", "CMU_HE_LEVEL_STATE", "CMU_COMPRESSOR_STATE", "CMU_CONTROLLER0_HEATER_TOTAL_W", "CMU_N2_LEVEL")),
    CMU_BHNL(new Builder("CMU-BHNL", Groups.CRYOSTAT_MONITORING_UNIT, JacPublicDefinitions.SystemType.CMUBHNL).noTempLogin().changeDefault("show_axes", (Object)true).statusTab(CmuBnlStatusPanel.class)),
    CMU_RZ(new Builder("CMU-RZ", Groups.CRYOSTAT_MONITORING_UNIT, JacPublicDefinitions.SystemType.CMURZ).statusTab(CmuRzStatusPanel.class).noTempLogin().changeDefault("show_axes", (Object)true).restrictUserPlots("CMU_PT100_TEMPERATURE0", "CMU_HE_PRESSURE", "CMU_COMPRESSOR_FLOW", "CMU_COMPRESSOR_TEMP", "CMU_COMPRESSOR_ROOM_TEMP", "CMU_COMPRESSOR_STATE", "CMU_RZ_BSMS_SHIELD_TEMPERATURE", "CMU_HE_LEVEL", "CMU_CONTROLLER1_HEATER_TOTAL_MW")),
    CMU_CF(new Builder("CMU-CF", Groups.CRYOSTAT_MONITORING_UNIT, JacPublicDefinitions.SystemType.CMUCF).statusTab(CmuCfStatusPanel.class).noTempLogin().changeDefault("show_axes", (Object)true).restrictUserPlots("CMU_COMPRESSOR_FLOW", "CMU_COMPRESSOR_TEMP", "CMU_COMPRESSOR_ROOM_TEMP", "CMU_COMPRESSOR_STATE", "CMU_VACUUM", "CMU_VACUUM_RAW", "CMU_COMPRESSOR_STATE", "CMU_COMPRESSOR_TEMP_DISCHARGE", "CMU_COMPRESSOR_TEMP_WATER_OUT", "CMU_COMPRESSOR_TEMP_WATER_IN", "CMU_COMPRESSOR_TEMP_OIL", "CMU_COMPRESSOR_PRES_RETURN", "CMU_COMPRESSOR_PRES_SUPPLY", "CMU_COMPRESSOR_OP_HRS")),
    LEVELSENSOR(new Builder("Level Sensor", Groups.LEVELSENSOR, JacPublicDefinitions.SystemType.LEVELSENSOR).statusTab(LevelsensorStatusPanel.class)),
    ALPHA(new Builder("Alpha Polarizer", Groups.ALPHA_POLARIZER, JacPublicDefinitions.SystemType.ALPHA_POLARIZER).statusTab(AlphaStatusPanel.class)),
    CU5(new Builder("CU/5", Groups.CRYO_COOLING_DEVICE, JacPublicDefinitions.SystemType.CU5).statusTab(Cu5StatusPanel.class).addTimer("CU5_FSM_COMMAND", "CU/5 FSM", JacPublicDefinitions.UserLevel.USER, JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).addTimer("CU5_SERVICE_FSM_COMMAND", "CU/5 FSM (Service)", JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).addTimer("CU5_VACUUM_COMMAND", "Vacuum FSM", JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).changeDefault("show_axes", (Object)false)),
    CU5_MRI(new Builder("CU/5 MRI", Groups.CRYO_COOLING_DEVICE, JacPublicDefinitions.SystemType.CU5_MRI).statusTab(Cu5MriStatusPanel.class).addTimer("CU5_FSM_COMMAND", "CU/5 FSM", JacPublicDefinitions.UserLevel.USER, JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).addTimer("CU5_SERVICE_FSM_COMMAND", "CU/5 FSM (Service)", JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).addTimer("CU5_VACUUM_COMMAND", "Vacuum FSM", JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).changeDefault("show_axes", (Object)false)),
    RETROFIT_CU(new Builder("Retrofit CU", Groups.CRYO_COOLING_DEVICE, JacPublicDefinitions.SystemType.RETROFIT_CU).statusTab(RetrofitCuStatusPanel.class).addTimer("CUX_COMMAND", "Cooling Unit", JacPublicDefinitions.UserLevel.USER, JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).addTimer("CUX_SERVICE_COMMAND", "Cooling Unit (Service)", JacPublicDefinitions.UserLevel.SERVICE, JacPublicDefinitions.UserLevel.DEVELOPER).changeDefault("show_axes", (Object)false)),
    RETROFIT_BMPC(new Builder("Retrofit BMPC", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.RETROFIT_BMPC).statusTab(RetrofitBmpcStatusPanel.class).changeDefault("show_axes", (Object)true)),
    MMS_BMU_50_USR(new Builder("BMU-5.0 USR", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.MMS_BMU_50_USR).statusTab(MmsBmu50UsrStatusPanel.class).changeDefault("show_axes", (Object)true).restrictUserPlots("MMS_L1_HE_LEVEL", "MMS_P1_HEPRESS_FILT", "MMS_T1", "MMS_T2", "MMS_BAT_CHARGE", "MMS_COMPRESSOR_FLOW_1", "MMS_COMPRESSOR_TEMP_1", "MMS_COMPRESSOR_ROOM_TEMP_1", "MMS_S5_BURST_DISK_BROKEN", "MMS_S6_FIELD_DET", "MMS_MAGNET_CN", "MMS_WARNING_LAMP_CN", "MMS_COMPRESSOR_STATE_1", "COMPRESSOR_TEMP_DISCHARGE_1", "COMPRESSOR_TEMP_WATER_OUT_1", "COMPRESSOR_TEMP_WATER_IN_1", "COMPRESSOR_TEMP_OIL_1", "COMPRESSOR_PRES_RETURN_1", "COMPRESSOR_PRES_SUPPLY_1", "COMPRESSOR_OP_HRS_1", "MMS_CONTROLLER1_HEATER_MW")),
    MMS_BMU_51_US_R(new Builder("BMU-5.1 US/R", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.MMS_BMU_51_US_R).statusTab(MmsBmu51UsRStatusPanel.class).changeDefault("show_axes", (Object)true).restrictUserPlots("MMS_L1_HE_LEVEL", "MMS_P1_HEPRESS_FILT", "MMS_T1", "MMS_T2", "MMS_BAT_CHARGE", "MMS_COMPRESSOR_FLOW_1", "MMS_COMPRESSOR_TEMP_1", "MMS_COMPRESSOR_ROOM_TEMP_1", "MMS_S5_BURST_DISK_BROKEN", "MMS_S6_FIELD_DET", "MMS_MAGNET_CN", "MMS_WARNING_LAMP_CN", "MMS_COMPRESSOR_STATE_1", "COMPRESSOR_TEMP_DISCHARGE_1", "COMPRESSOR_TEMP_WATER_OUT_1", "COMPRESSOR_TEMP_WATER_IN_1", "COMPRESSOR_TEMP_OIL_1", "COMPRESSOR_PRES_RETURN_1", "COMPRESSOR_PRES_SUPPLY_1", "COMPRESSOR_OP_HRS_1")),
    MMS_BMU_52_US(new Builder("BMU-5.2 US", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.MMS_BMU_52_US).statusTab(MmsBmu52UsStatusPanel.class).changeDefault("show_axes", (Object)true).restrictUserPlots("MMS_L1_HE_LEVEL", "MMS_L2_N2_LEVEL", "MMS_BAT_CHARGE", "MMS_S5_BURST_DISK_BROKEN", "MMS_S6_FIELD_DET", "MMS_MAGNET_CN")),
    MMS_BMU_53_CF(new Builder("BMU-5.3 CF", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.MMS_BMU_53_CF).changeDefault("show_axes", (Object)true).statusTab(MmsBmu53CfStatusPanel.class).restrictUserPlots("MMS_P1_HEPRESS_FILT", "MMS_BAT_CHARGE", "MMS_T1", "MMS_T2", "MMS_COMPRESSOR_FLOW_1", "MMS_COMPRESSOR_TEMP_1", "MMS_COMPRESSOR_ROOM_TEMP_1", "MMS_S5_BURST_DISK_BROKEN", "MMS_S6_FIELD_DET", "MMS_MAGNET_CN", "MMS_WARNING_LAMP_CN", "MMS_COMPRESSOR_STATE_1", "COMPRESSOR_TEMP_DISCHARGE_1", "COMPRESSOR_TEMP_WATER_OUT_1", "COMPRESSOR_TEMP_WATER_IN_1", "COMPRESSOR_TEMP_OIL_1", "COMPRESSOR_PRES_RETURN_1", "COMPRESSOR_PRES_SUPPLY_1", "COMPRESSOR_OP_HRS_1", "MMS_AC_FSM_STATE", "MMS_ACA_FSM_STATE")),
    MMS_BMPC_3_21T_FTMS(new Builder("BMPC III 21T FTMS", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.MMS_BMPC_3_21T_FTMS).statusTab(MmsBmpc3StatusPanel.class).changeDefault("show_axes", (Object)true)),
    MMS_BMPC_3(new Builder("BMPC III", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.MMS_BMPC_3).statusTab(MmsBmpc3StatusPanel.class).changeDefault("show_axes", (Object)true)),
    MMS_BMPC_3_AEON(new Builder("BMPC III Aeon", Groups.MAGNET_MONITORING_UNIT, JacPublicDefinitions.SystemType.MMS_BMPC_3_AEON).changeDefault("show_axes", (Object)true)),
    MAS_CRP_LIFT(new Builder("MAS CRP Lift", Groups.MASCRP_LIFT, JacPublicDefinitions.SystemType.MASCRP_LIFT).statusTab(MasCrpLiftStatusPanel.class).changeDefault("show_axes", (Object)true).restrictUserPlots("LMCB_MAGIC_ANGLE_HOME", "LMCB_MAGIC_ANGLE_END_POSITION", "LMCB_MAGIC_ANGLE_LIMITER_UP", "LMCB_MAGIC_ANGLE_LIMITER_DOWN", "LMCB_ROCKER_FULL_PRESSED", "LMCB_ROCKER_UP", "LMCB_ROCKER_DOWN", "LMCB_LIFT_UP", "LMCB_Z_ROTATION_UNLOCKED", "LMCB_Z_ROTATION_LOCKED", "LMCB_LIFT_DOWN", "MEASURED_B_FIELD_VALUE", "CML_MA_TARGET", "CML_MA_MOTOR_POSITION", "CML_LIFT_MOTOR_POSITION", "CML_MANUAL_MA_SEARCH_TARGET", "CML_LIFT_CURRENT_VALUE", "CML_MA_CURRENT_VALUE", "CML_FSM_STATE", "CML_DETAILED_STATE", "LMCB_PRESSURE", "CML_PROBE_TEMP_EJ_THR", "CML_PROBE_TEMPERATURE", "SENIS_PROBE_TEMPERATURE", "SENIS_BOX_TEMPERATURE")),
    MMS_CFPU(new Builder("Pump Unit", Groups.CF_PUMP_UNIT, JacPublicDefinitions.SystemType.MMS_CFPU).statusTab(CfpuStatusPanel.class).changeDefault("show_axes", (Object)true)),
    DDNP(new Builder("D-DNP", Groups.DDNP, JacPublicDefinitions.SystemType.DDNP).statusTab(DdnpStatusPanel.class).changeDefault("show_axes", (Object)true)),
    MASCRP_PUMPSTATION(new Builder("MAS CRP Pump Station", Groups.MASCRP_PUMPSTATION, JacPublicDefinitions.SystemType.MASCRP_PUMPSTATION).statusTab(MasCrpPumpStationStatusPanel.class).changeDefault("show_axes", (Object)false)),
    AV4I_BSMS(new Builder("AV4i/BSMS", Groups.AV4I_BSMS, JacPublicDefinitions.SystemType.AV4I_BSMS).changeDefault("show_axes", (Object)true));

    public final String name;
    public final Groups group;
    public final JacPublicDefinitions.SystemType type;
    public final ImmutableSet<String> visiblePars;
    public final ImmutableTable<JacPublicDefinitions.UserLevel, String, String> timerPars;
    public final boolean allowTempLogin;
    private final HashMap<String, Object> defaultPrefs;
    private final Class<? extends StatusPanel> statusPanelClass;

    public Object getDefault(String id) {
        return this.defaultPrefs.get(id);
    }

    public StatusPanel createStatusPanel(StatusTab parent) {
        try {
            StatusPanel panel = this.statusPanelClass.getConstructor(StatusTab.class).newInstance(parent);
            panel.reload();
            return panel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getFsName() {
        return this.name.replaceAll("[^A-Za-z0-9_\\-.]", "");
    }

    public String toString() {
        return this.name;
    }

    public static JacType getByFsName(String fileSystemCompatibleName) {
        for (JacType system : JacType.values()) {
            if (!fileSystemCompatibleName.equals(system.getFsName())) continue;
            return system;
        }
        return null;
    }

    public static JacType getByTypeName(String systemType) {
        for (JacType system : JacType.values()) {
            if (!systemType.equals(system.type.toString())) continue;
            return system;
        }
        return null;
    }

    public static JacType getByID(int typeCode) {
        for (JacType system : JacType.values()) {
            if (typeCode != system.type.value) continue;
            return system;
        }
        return null;
    }

    private JacType(Builder builder) {
        this.name = builder.name;
        this.group = builder.group;
        this.type = builder.corbaEnum;
        this.statusPanelClass = builder.statusPanelClass;
        this.visiblePars = builder.visiblePars != null ? ImmutableSet.copyOf(builder.visiblePars) : null;
        this.defaultPrefs = builder.defaultPrefs;
        this.timerPars = ImmutableTable.copyOf(builder.timerPars);
        this.allowTempLogin = builder.allowTempLogin;
    }

    private static class Builder {
        private String name;
        private Groups group;
        private JacPublicDefinitions.SystemType corbaEnum;
        private Class<? extends StatusPanel> statusPanelClass = StatusPanel.class;
        private String[] visiblePars;
        private HashMap<String, Object> defaultPrefs = new HashMap();
        private Table<JacPublicDefinitions.UserLevel, String, String> timerPars = HashBasedTable.create();
        private boolean allowTempLogin = true;

        Builder(String name, Groups group, JacPublicDefinitions.SystemType corbaEnum) {
            this.name = name;
            this.group = group;
            this.corbaEnum = corbaEnum;
            this.defaultPrefs.put("scaling", Settings.ScalingModes.BASE_DIV.ordinal());
            this.defaultPrefs.put("timezone", Settings.Timezones.FROM_JAC.ordinal());
            this.defaultPrefs.put("textlog_in_timeline", true);
            this.defaultPrefs.put("show_axes", false);
            this.defaultPrefs.put("round_axis_range", true);
            this.defaultPrefs.put("show_grid", true);
            this.defaultPrefs.put("shade_outliers", true);
            this.defaultPrefs.put("colors", new HashMap());
            this.defaultPrefs.put("working_path", JacServiceGui.USER_HOME + "/jac_servicegui");
            this.defaultPrefs.put("open_dialog_path", JacServiceGui.USER_HOME);
        }

        <T extends StatusPanel> Builder statusTab(Class<T> statusPanelClass) {
            this.statusPanelClass = statusPanelClass;
            return this;
        }

        Builder restrictUserPlots(String ... pars) {
            this.visiblePars = pars;
            return this;
        }

        Builder changeDefault(String id, Object val) {
            this.defaultPrefs.put(id, val);
            return this;
        }

        <E extends Enum<E>> Builder changeDefault(String id, E val) {
            this.defaultPrefs.put(id, val);
            return this;
        }

        Builder addTimer(String parId, String label, JacPublicDefinitions.UserLevel ... users) {
            for (JacPublicDefinitions.UserLevel user : users) {
                this.timerPars.put(user, parId, label);
            }
            return this;
        }

        Builder noTempLogin() {
            this.allowTempLogin = false;
            return this;
        }
    }
}

