/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIParamGroup;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class UIView
extends JPanel {
    private static final long serialVersionUID = -1742285909759149970L;
    private UIParamGroup[] paramGroups;
    private boolean isPopulated = false;

    public UIView(UIParamGroup ... paramGroups) {
        this.paramGroups = paramGroups;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
    }

    public void bind(Source source, AppState appState) {
        for (UIParamGroup group : this.paramGroups) {
            group.bind(source, appState);
        }
    }

    public void populate() {
        for (UIParamGroup group : this.paramGroups) {
            group.populate();
            this.add((Component)group, group.getConstraints());
        }
        this.isPopulated = true;
    }

    public boolean isUnPopulated() {
        return !this.isPopulated;
    }

    public void updateValues() {
        if (this.isUnPopulated()) {
            return;
        }
        for (UIParamGroup group : this.paramGroups) {
            group.updateValues();
        }
    }

    public void updateLabels() {
        if (this.isUnPopulated()) {
            return;
        }
        for (UIParamGroup group : this.paramGroups) {
            group.updateLabels();
        }
    }

    public void updateActive() {
        if (this.isUnPopulated()) {
            return;
        }
        for (UIParamGroup group : this.paramGroups) {
            group.updateActive();
        }
    }
}

