/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UINumericParam;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class UISafetyCalibParam
extends UINumericParam {
    private static final JLabel EMPTY_LABEL = new JLabel();
    private final JButton calibrateButton = new UIField.BoundedButton("Calibrate");

    public UISafetyCalibParam(String paramId) {
        super(paramId);
        this.calibrateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UISafetyCalibParam.this.calibrateButton.setEnabled(false);
                UISafetyCalibParam.this.calibrate();
                UISafetyCalibParam.this.calibrateButton.setEnabled(true);
            }
        });
    }

    private synchronized void calibrate() {
        try {
            this.par.setValueUnchecked(Float.valueOf(0.0f));
        }
        catch (JacControl.JacParamNotAvailable jpne) {
            String message = "Safety temperature could not be calibrated:\n" + jpne.statement + "\n" + "Make sure the probehead is connected.";
            JOptionPane.showMessageDialog(this.getOwningWindow(), message, "Error", 0);
            return;
        }
        catch (Exception ex) {
            String message = "Safety temperature could not be calibrated:\n" + ex.getMessage();
            JOptionPane.showMessageDialog(this.getOwningWindow(), message, "Error", 0);
            return;
        }
        String message = "Calibration successful!";
        JOptionPane.showMessageDialog(this.getOwningWindow(), message, "Calibration successful", 1);
    }

    @Override
    Component[] getControlComponents() {
        return new JButton[]{this.calibrateButton};
    }

    @Override
    public Component[] getValueComponents() {
        return new JLabel[]{EMPTY_LABEL};
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        return "";
    }

    @Override
    protected int getLongestTextWidth() {
        return 0;
    }
}

