/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.data.cache.BooleanDescriptor;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class UIRadioBooleanParam
extends UIParam {
    private final ButtonGroup buttonGroup;
    protected JLabel labelComponent = new JLabel();
    protected JRadioButton labelFalse = new UIField.BoundedRadioButton("Foo");
    protected JRadioButton labelTrue = new UIField.BoundedRadioButton("Bar");

    public UIRadioBooleanParam(String paramId, UIParam.Controls controls) {
        super(paramId, controls);
        this.labelFalse.setHorizontalTextPosition(2);
        this.labelFalse.setHorizontalAlignment(4);
        this.labelFalse.setEnabled(false);
        this.labelTrue.setEnabled(false);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.labelFalse);
        this.buttonGroup.add(this.labelTrue);
    }

    public UIRadioBooleanParam(String paramId) {
        this(paramId, UIParam.Controls.DETECT);
    }

    @Override
    void bind(Source source, AppState appState) {
        super.bind(source, appState);
    }

    @Override
    protected void populateComponents(boolean hasControls) {
        this.hasControls = hasControls;
        if (hasControls) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIRadioBooleanParam.this.sendValue(UIRadioBooleanParam.this.labelTrue.isSelected());
                }
            };
            this.labelFalse.addActionListener(actionListener);
            this.labelTrue.addActionListener(actionListener);
        }
    }

    protected void sendValue(boolean value) {
        this.par.setValue(value);
    }

    @Override
    Component[] getLabelComponents() {
        return new Component[]{this.labelComponent};
    }

    @Override
    Component[] getValueComponents() {
        return new Component[]{this.labelFalse, this.labelTrue};
    }

    @Override
    Component[] getControlComponents() {
        return new Component[]{this.labelFalse, this.labelTrue};
    }

    @Override
    void updateLabel() {
        this.labelComponent.setText(this.par.getName());
        String[] entries = this.getEntryText("", "");
        this.labelFalse.setText(entries[0]);
        this.labelTrue.setText(entries[1]);
    }

    @Override
    public GridBagConstraints[] getComponentGBCs(int gridy) {
        return new GridBagConstraints[]{new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 25), 0, 0), new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 5, 3, 3), 0, 0), new GridBagConstraints(2, gridy, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 3, 3, 5), 0, 0)};
    }

    @Override
    void updateValue() {
        if (!this.isActive()) {
            this.buttonGroup.clearSelection();
            return;
        }
        this.par.getValue(new UIParam.ValueUpdate(){

            @Override
            public void update(String value) {
                UIRadioBooleanParam.this.buttonGroup.clearSelection();
                if (UIRadioBooleanParam.this.par.descriptor != null && value.equals(((BooleanDescriptor)UIRadioBooleanParam.this.par.descriptor).labelTrue) || !UIRadioBooleanParam.this.par.prop.equals(UIParam.NOT_AVAILABLE) && value.equals(UIRadioBooleanParam.this.par.prop.allowedValues[0].name)) {
                    UIRadioBooleanParam.this.labelTrue.setSelected(true);
                }
                if (UIRadioBooleanParam.this.par.descriptor != null && value.equals(((BooleanDescriptor)UIRadioBooleanParam.this.par.descriptor).labelFalse) || !UIRadioBooleanParam.this.par.prop.equals(UIParam.NOT_AVAILABLE) && value.equals(UIRadioBooleanParam.this.par.prop.allowedValues[1].name)) {
                    UIRadioBooleanParam.this.labelFalse.setSelected(true);
                }
            }
        });
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        this.formattedValue = prop.value.BooleanVal() ? prop.allowedValues[0].name : prop.allowedValues[1].name;
        return this.formattedValue;
    }

    @Override
    public String formatDefaultValue(JacControl.JacPropertyExt prop) {
        if (prop.defaultValue.discriminator() == JacCommon.JacValueTypes.ValueBoolean) {
            return prop.defaultValue.BooleanVal() ? prop.allowedValues[0].name : prop.allowedValues[1].name;
        }
        return null;
    }

    @Override
    protected int getLongestTextWidth() {
        FontMetrics fm = this.labelFalse.getFontMetrics(this.labelFalse.getFont());
        String[] entryText = this.getEntryText("dummywidth", "");
        return fm.stringWidth(entryText[0]) + fm.stringWidth(entryText[1]);
    }

    private String[] getEntryText(String defaultEntry0Text, String defaultEntry1Text) {
        String[] entryText = new String[]{defaultEntry0Text, defaultEntry1Text};
        BooleanDescriptor d = (BooleanDescriptor)this.par.descriptor;
        if (d != null && !d.eventLogged) {
            entryText[0] = d.labelFalse;
            entryText[1] = d.labelTrue;
        } else if (this.par.prop != null && !this.par.prop.equals(NOT_AVAILABLE)) {
            entryText[0] = this.par.prop.allowedValues[1].name;
            entryText[1] = this.par.prop.allowedValues[0].name;
        }
        return entryText;
    }
}

