/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class UIParamGroup
extends JPanel {
    private static final long serialVersionUID = -1105194290568763849L;
    private UIField[] uiFields;
    private GridBagConstraints constraints;

    public UIParamGroup(String groupTitle, int x, int y, int w, int h, UIField ... uiFields) {
        this(groupTitle, x, y, w, h, 1.0, uiFields);
    }

    public UIParamGroup(String groupTitle, int x, int y, int w, int h, double weighty, UIField ... uiFields) {
        this.uiFields = uiFields;
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints(x, y, w, h, 1.0, weighty, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        TitledBorder border = new TitledBorder(groupTitle);
        Font font = border.getTitleFont();
        if (font == null) {
            font = this.getFont();
        }
        border.setTitleFont(font.deriveFont(1));
        this.setBorder(border);
    }

    public void bind(Source source, AppState appState) {
        for (UIField uiField : this.uiFields) {
            if (!(uiField instanceof UIParam)) continue;
            UIParam uiParam = (UIParam)uiField;
            uiParam.bind(source, appState);
            appState.updates.register(uiParam);
        }
    }

    public void populate() {
        int index = 0;
        for (UIField uiField : this.uiFields) {
            if (uiField instanceof UIParam) {
                UIParam uiParam = (UIParam)uiField;
                uiParam.populateComponents();
                uiParam.updateLabel();
                uiParam.updateValue();
                uiParam.updateActive();
            }
            Component[] components = uiField.getComponents();
            GridBagConstraints[] constraints = uiField.getComponentGBCs(index);
            for (int i = 0; i < components.length; ++i) {
                if (components[i] == null) continue;
                this.add(components[i], constraints[i]);
            }
            ++index;
        }
        this.add(Box.createGlue(), new GridBagConstraints(0, index, 3, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public UIParamGroup hideBorder() {
        this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
        return this;
    }

    public GridBagConstraints getConstraints() {
        return this.constraints;
    }

    void updateValues() {
        for (UIField uiField : this.uiFields) {
            UIParam par;
            if (!(uiField instanceof UIParam) || !(par = (UIParam)uiField).isActive()) continue;
            par.updateValue();
        }
    }

    void updateLabels() {
        for (UIField uiField : this.uiFields) {
            if (!(uiField instanceof UIParam)) continue;
            UIParam par = (UIParam)uiField;
            if (par.appState == null || !par.isActive()) continue;
            par.updateLabel();
        }
    }

    void updateActive() {
        for (UIField uiField : this.uiFields) {
            if (!(uiField instanceof UIParam)) continue;
            UIParam par = (UIParam)uiField;
            par.updateActive();
        }
    }
}

