/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.config.ParameterAccessLevel;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.Trigger;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.LoadingCompleteCallback;
import ch.bruker.jac.servicegui.status.ui.UIField;
import com.google.common.collect.HashBiMap;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.joda.time.DateTime;

public abstract class UIParam
extends UIField {
    static final JacControl.JacPropertyExt NOT_AVAILABLE = new JacControl.JacPropertyExt();
    static final String VALUE_NOT_AVAILABLE = "-";
    private final String parId;
    String formattedValue;
    protected Par par;
    private Controls controls;
    protected boolean hasControls;
    protected Source source;
    protected AppState appState;
    private String fallbackLabel;
    private boolean isBound = false;

    UIParam(String parId, boolean shouldBeControllable) {
        this(parId, shouldBeControllable ? Controls.PRESENT : Controls.NONE);
    }

    UIParam(String parId, Controls controls) {
        this.parId = parId;
        this.fallbackLabel = parId;
        this.controls = controls;
    }

    UIParam(String parId) {
        this(parId, Controls.DETECT);
    }

    public UIParam fallbackLabel(String label) {
        this.fallbackLabel = label;
        return this;
    }

    void bind(Source source, AppState appState) {
        if (this.isBound) {
            return;
        }
        this.isBound = true;
        this.appState = appState;
        this.source = source;
        this.par = new Par(this.parId);
    }

    final void populateComponents() {
        if (this.par.prop == null) {
            SGUtils.log("Fetching parameters", new Object[0]);
        }
        while (this.par.prop == null) {
            System.err.print('\u2026');
            try {
                this.source.api.awaitNextFetch();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
        switch (this.controls) {
            case NONE: {
                this.populateComponents(false);
                break;
            }
            case PRESENT: {
                this.populateComponents(true);
                break;
            }
            case DETECT: {
                this.populateComponents(this.par.checkAccess());
            }
        }
    }

    boolean isControllable() {
        return this.hasControls && this.par.checkAccess() && this.appState.isMode(GuiMode.TRACKING);
    }

    final boolean isActive() {
        return this.par != null && this.par.hasData();
    }

    final void updateActive() {
        boolean active = this.isActive();
        for (Component c2 : this.getLabelComponents()) {
            c2.setEnabled(active);
        }
        for (Component c2 : this.getValueComponents()) {
            c2.setEnabled(active);
        }
        for (Component c2 : this.getControlComponents()) {
            if (c2 == null) continue;
            c2.setEnabled(active);
        }
        this.updateValue();
        this.updateControllable();
    }

    void updateControllable() {
        boolean controllable = this.isControllable();
        for (Component c2 : this.getControlComponents()) {
            if (c2 == null) continue;
            if (c2 instanceof JPanel) {
                for (Component cc : ((JPanel)c2).getComponents()) {
                    cc.setEnabled(controllable);
                }
                continue;
            }
            if (c2 instanceof JTextField) {
                ((JTextField)c2).setEditable(controllable);
            }
            c2.setEnabled(controllable);
        }
        for (Component c2 : this.getValueComponents()) {
            if (!(c2 instanceof JTextField)) continue;
            JTextField textField = (JTextField)c2;
            textField.setEnabled(controllable);
            textField.setDisabledTextColor(Color.BLACK);
        }
    }

    protected abstract void populateComponents(boolean var1);

    abstract Component[] getLabelComponents();

    abstract Component[] getValueComponents();

    abstract Component[] getControlComponents();

    @Override
    public final Component[] getComponents() {
        LinkedHashSet components = new LinkedHashSet();
        Collections.addAll(components, this.getLabelComponents());
        Collections.addAll(components, this.getValueComponents());
        Collections.addAll(components, this.getControlComponents());
        return components.toArray(new Component[0]);
    }

    abstract void updateValue();

    abstract void updateLabel();

    public abstract String format(JacControl.JacPropertyExt var1);

    public abstract String formatDefaultValue(JacControl.JacPropertyExt var1);

    public String format(Sample sample) {
        if (sample.isUncached()) {
            return "\u2026";
        }
        if (sample.isValid()) {
            if (this.par.descriptor == null) {
                return "[d?]";
            }
            this.formattedValue = this.par.descriptor.getRepr(sample).trim();
        } else {
            this.formattedValue = VALUE_NOT_AVAILABLE;
        }
        return this.formattedValue;
    }

    protected abstract int getLongestTextWidth();

    public static Number jacNumericValueToNumber(JacCommon.JacValueType value) {
        if (value.discriminator() == JacCommon.JacValueTypes.ValueInt32) {
            return value.Int32Val();
        }
        if (value.discriminator() == JacCommon.JacValueTypes.ValueDouble) {
            return value.DoubleVal();
        }
        if (value.discriminator() == JacCommon.JacValueTypes.ValueFloat) {
            return Float.valueOf(value.FloatVal());
        }
        throw new RuntimeException("Only numeric parameters can be converted into a value in a generic manner");
    }

    final void showGenericErrorMessage() {
        String message = "Action could not be executed";
        JOptionPane.showMessageDialog(this.getOwningWindow(), message, "Error", 0);
    }

    final class Par {
        public final String parId;
        public final Descriptor descriptor;
        volatile JacControl.JacPropertyExt prop;

        Par(final String parId) {
            this.parId = parId;
            if (UIParam.this.appState.isMode(GuiMode.STANDALONE)) {
                this.prop = NOT_AVAILABLE;
            } else {
                UIParam.this.source.api.schedule(parId, new LoadingCompleteCallback(){

                    @Override
                    public void with(JacControl.JacPropertyExt p) {
                        Par.this.prop = p;
                        if (p == null) {
                            SGUtils.err("Could not load parameter '%s'", parId);
                            Par.this.prop = NOT_AVAILABLE;
                        }
                    }
                });
            }
            this.descriptor = UIParam.this.appState.getDescriptor(parId);
        }

        final void getValue(final ValueUpdate callback) {
            if (UIParam.this.appState.isMode(GuiMode.TRACKING)) {
                if (this.prop.equals(NOT_AVAILABLE)) {
                    return;
                }
                UIParam.this.source.api.schedule(this.parId, new LoadingCompleteCallback(){

                    @Override
                    public void with(JacControl.JacPropertyExt prop) {
                        if (prop == null) {
                            return;
                        }
                        Par.this.prop = prop;
                        callback.update(UIParam.this.format(prop));
                    }
                });
                return;
            }
            DateTime cursor = UIParam.this.appState.getCursor();
            Sample s = UIParam.this.appState.cachedSample(this.parId, cursor.getMillis());
            if (s.isUncached()) {
                UIParam.this.appState.prepareData(cursor.getMillis(), Collections.singleton(this.parId));
            }
            callback.update(UIParam.this.format(s));
        }

        boolean checkAccess() {
            if (this.prop == null) {
                SGUtils.err("checkAccess not yet ready: %s", this.parId);
                return false;
            }
            if (this.prop.equals(NOT_AVAILABLE)) {
                return false;
            }
            switch (ParameterAccessLevel.getLevel(this.prop.accessLevel)) {
                case PAR_PUBLIC: {
                    return true;
                }
                case PAR_PROTECTED: {
                    return UIParam.this.appState.getUserLevel().compareTo(JacPublicDefinitions.UserLevel.SERVICE) >= 0;
                }
                case PAR_PRIVATE: {
                    return UIParam.this.appState.getUserLevel().compareTo(JacPublicDefinitions.UserLevel.DEVELOPER) >= 0;
                }
            }
            return false;
        }

        String getName() {
            if (this.descriptor != null) {
                return this.descriptor.name;
            }
            if (!this.prop.equals(NOT_AVAILABLE)) {
                return this.prop.parName;
            }
            return UIParam.this.fallbackLabel;
        }

        String getUnit() {
            if (this.descriptor != null) {
                return this.descriptor.unit;
            }
            if (!this.prop.equals(NOT_AVAILABLE)) {
                return this.prop.unit;
            }
            return "";
        }

        String getDefaultValue() {
            if (!this.prop.equals(NOT_AVAILABLE)) {
                return UIParam.this.formatDefaultValue(this.prop);
            }
            return null;
        }

        final boolean hasData() {
            if (UIParam.this.appState.isMode(GuiMode.TRACKING)) {
                return !this.prop.equals(NOT_AVAILABLE);
            }
            return this.descriptor != null;
        }

        public void setValue(String value) {
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            valueType.StringVal(value);
            this.push(new JacCommon.JacProperty(this.parId, valueType));
        }

        public void setValue(boolean value) {
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            valueType.BooleanVal(value);
            this.push(new JacCommon.JacProperty(this.parId, valueType));
        }

        public void setValue(Integer value) {
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            valueType.Int32Val(value);
            this.push(new JacCommon.JacProperty(this.parId, valueType));
        }

        public void setValue(Float value) {
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            valueType.FloatVal(value.floatValue());
            this.push(new JacCommon.JacProperty(this.parId, valueType));
        }

        public void setValueUnchecked(Float value) throws Exception {
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            valueType.FloatVal(value.floatValue());
            this.pushUnchecked(new JacCommon.JacProperty(this.parId, valueType));
        }

        public void setValue(Number number) {
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            JacCommon.JacValueTypes discriminator = UIParam.this.par.prop.value.discriminator();
            switch (discriminator) {
                case ValueDouble: {
                    valueType.DoubleVal(number.doubleValue());
                    break;
                }
                case ValueFloat: {
                    valueType.FloatVal(number.floatValue());
                    break;
                }
                case ValueInt32: {
                    valueType.Int32Val(number.intValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.push(new JacCommon.JacProperty(this.parId, valueType));
        }

        public void setValue(byte[] value) {
            JacCommon.JacValueType valueType = new JacCommon.JacValueType();
            valueType.ByteArrayVal(value);
            this.push(new JacCommon.JacProperty(this.parId, valueType));
        }

        protected JacControl.JacPropertyExt pull() {
            if (this.parId == null) {
                return null;
            }
            JacControl jacControl = UIParam.this.source.api.getConnection();
            if (jacControl == null) {
                return null;
            }
            try {
                return jacControl.getParameter(this.parId);
            }
            catch (JacControl.JacParamNotAvailable x) {
                SGUtils.log("Connection error", new Object[0]);
                return null;
            }
        }

        public HashBiMap<Integer, String> getAllowedValues() {
            if (this.prop == null) {
                throw new IllegalStateException();
            }
            HashBiMap<Integer, String> ret = HashBiMap.create();
            for (JacControl.JacPropertyEntryName entry : this.prop.allowedValues) {
                ret.put(entry.value.Int32Val(), entry.name);
            }
            return ret;
        }

        private void pushUnchecked(JacCommon.JacProperty jacProperty) throws Exception {
            JacControl jacControl = UIParam.this.source.api.getConnection();
            if (jacControl == null) {
                throw new Exception("No connection to JAC");
            }
            jacControl.pushParameters(UIParam.this.source.api.getKey(), new JacCommon.JacProperty[]{jacProperty});
        }

        private void push(JacCommon.JacProperty jacProperty) {
            try {
                this.pushUnchecked(jacProperty);
            }
            catch (JacControl.JacParamNotAvailable jpna) {
                String message = jpna.statement;
                if (message.equals("Parameter is out of static range")) {
                    try {
                        JacControl.JacPropertyExt param = UIParam.this.source.api.getConnection().getParameter(jacProperty.parId);
                        Number min = UIParam.jacNumericValueToNumber(param.min);
                        Number max = UIParam.jacNumericValueToNumber(param.max);
                        message = message + " [" + min + ", " + max + "]";
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if (message.contains("Parameter is protected") || message.contains("Parameter is private")) {
                    UIParam.this.appState.setLastUserLevel();
                    UIParam.this.appState.setUserLevel(JacPublicDefinitions.UserLevel.USER);
                    UIParam.this.appState.updates.post(new Trigger("loginDialog"));
                } else {
                    String title = "Parameter could not be pushed";
                    JOptionPane.showMessageDialog(UIParam.this.getOwningWindow(), "Error:  " + message, title, 0);
                }
            }
            catch (Exception x) {
                UIParam.this.showGenericErrorMessage();
            }
        }
    }

    public static interface ValueUpdate {
        public void update(String var1);
    }

    public static enum Controls {
        NONE,
        PRESENT,
        DETECT;

    }
}

