/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.status.ui.UIClassicParam;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class UINumericParam
extends UIClassicParam {
    public UINumericParam(String paramId, boolean shouldBeControllable) {
        super(paramId, shouldBeControllable);
    }

    public UINumericParam(String paramId, UIParam.Controls controls) {
        super(paramId, controls);
    }

    public UINumericParam(String paramId) {
        this(paramId, UIParam.Controls.DETECT);
    }

    public static boolean isSpecialFloatFormat(String format) {
        if (format != null && !format.isEmpty()) {
            char c2 = format.charAt(format.length() - 1);
            return c2 < '0' || c2 > '9';
        }
        return false;
    }

    @Override
    protected void populateComponents(boolean hasControls) {
        this.hasControls = hasControls;
        if (hasControls) {
            final UIField.BoundedButton button = new UIField.BoundedButton("Set");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    button.setCursor(Cursor.getPredefinedCursor(3));
                    String numericValue = UINumericParam.this.valueComponent.getText();
                    try {
                        double value = Double.parseDouble(numericValue);
                        UINumericParam.this.par.setValue(value);
                    }
                    catch (NumberFormatException nfe) {
                        String msg = "Error: The entered value cannot be pushed, because it is not numeric: " + numericValue;
                        JOptionPane.showMessageDialog(UINumericParam.this.getOwningWindow(), msg, "Not numeric", 0);
                    }
                    UINumericParam.this.valueComponent.getParent().requestFocus();
                    button.setCursor(Cursor.getDefaultCursor());
                }
            };
            button.addActionListener(actionListener);
            this.valueComponent.addActionListener(actionListener);
            this.setControlComponent(button);
        }
    }

    @Override
    void updateLabel() {
        String label = this.par.getName();
        String unit = this.par.getUnit();
        if (!unit.isEmpty()) {
            label = label + " [" + unit + "]";
        }
        this.labelComponent.setText(label);
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        String DEFAULT_FLOATING_POINT_FORMAT = ".3";
        String DEFAULT_INTEGER_FORMAT = "";
        String format = prop.format != null && !prop.format.isEmpty() ? prop.format : (prop.value.discriminator() == JacCommon.JacValueTypes.ValueInt32 ? "" : ".3");
        String conversionSuffix = UINumericParam.isSpecialFloatFormat(format) ? "" : (prop.value.discriminator() == JacCommon.JacValueTypes.ValueInt32 ? "d" : "f");
        this.formattedValue = String.format("%" + format + conversionSuffix, UINumericParam.jacNumericValueToNumber(prop.value));
        if (this.formattedValue.contains("NaN")) {
            return "-";
        }
        return this.formattedValue;
    }

    @Override
    public String formatDefaultValue(JacControl.JacPropertyExt prop) {
        String DEFAULT_FLOATING_POINT_FORMAT = ".3";
        String DEFAULT_INTEGER_FORMAT = "";
        if (prop.defaultValue.discriminator() == JacCommon.JacValueTypes.ValueEmpty) {
            return null;
        }
        String format = prop.format != null && !prop.format.isEmpty() ? prop.format : (prop.defaultValue.discriminator() == JacCommon.JacValueTypes.ValueInt32 ? "" : ".3");
        String conversionSuffix = UINumericParam.isSpecialFloatFormat(format) ? "" : (prop.defaultValue.discriminator() == JacCommon.JacValueTypes.ValueInt32 ? "d" : "f");
        this.formattedValue = String.format("%" + format + conversionSuffix, UINumericParam.jacNumericValueToNumber(prop.defaultValue));
        if (this.formattedValue.contains("NaN")) {
            return null;
        }
        return this.formattedValue;
    }

    @Override
    protected int getLongestTextWidth() {
        if (this.par.prop.equals(NOT_AVAILABLE)) {
            return 100;
        }
        Pattern p = Pattern.compile("^%?(\\d+)(?:\\..+)?$");
        Matcher m = p.matcher(this.par.prop.format);
        int len = 5;
        if (m.matches() && m.groupCount() == 1) {
            len = Integer.parseInt(m.group(1));
        }
        ++len;
        FontMetrics fm = this.valueComponent.getFontMetrics(this.valueComponent.getFont());
        return fm.charWidth('0') * (len += 10);
    }
}

