/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import ch.bruker.util.BFileUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UILoadMagnetChargingScriptParam
extends UIParam {
    private final JLabel labelComponent;
    private final JButton showButton;
    private final JButton loadButton;
    private ChargingScriptFrame chargingScriptFrame = new ChargingScriptFrame();

    public UILoadMagnetChargingScriptParam(String parId) {
        this(parId, true);
    }

    public UILoadMagnetChargingScriptParam(String parId, boolean showLoadButton) {
        super(parId, UIParam.Controls.PRESENT);
        this.chargingScriptFrame.setLocationRelativeTo(this.getOwningWindow());
        this.showButton = new UIField.BoundedButton("Show script");
        this.loadButton = showLoadButton ? new UIField.BoundedButton("Load new script") : null;
        this.labelComponent = new JLabel();
    }

    @Override
    protected void populateComponents(boolean hasControls) {
        this.hasControls = hasControls;
    }

    @Override
    public void bind(Source source, AppState appState) {
        super.bind(source, appState);
        if (this.loadButton != null) {
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    UILoadMagnetChargingScriptParam.this.loadButton.setEnabled(false);
                    UILoadMagnetChargingScriptParam.this.showButton.setEnabled(false);
                    UILoadMagnetChargingScriptParam.this.uploadFile();
                    UILoadMagnetChargingScriptParam.this.loadButton.setEnabled(true);
                    UILoadMagnetChargingScriptParam.this.showButton.setEnabled(true);
                }
            });
        }
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UILoadMagnetChargingScriptParam.this.showScript();
            }
        });
    }

    @Override
    Component[] getLabelComponents() {
        return new Component[]{this.labelComponent};
    }

    @Override
    Component[] getValueComponents() {
        return new Component[]{this.showButton};
    }

    @Override
    Component[] getControlComponents() {
        return new Component[]{this.showButton, this.loadButton};
    }

    @Override
    void updateValue() {
    }

    @Override
    void updateLabel() {
        this.labelComponent.setText(this.par.getName());
    }

    private synchronized void showScript() {
        JacControl.JacPropertyExt xmlParam = this.par.pull();
        if (xmlParam != null) {
            byte[] arr = xmlParam.value.ByteArrayVal();
            try {
                if ((double)arr.length > 1000000.0) {
                    JOptionPane.showMessageDialog(this.getOwningWindow(), "Xml lenght above 1e6!", "Error", 0);
                } else {
                    String xmlString = new String(arr, "UTF-8");
                    if (xmlString.isEmpty()) {
                        xmlString = "[no script loaded]";
                    }
                    this.chargingScriptFrame.setLocationRelativeTo(this.getOwningWindow());
                    this.chargingScriptFrame.setText(xmlString);
                    this.chargingScriptFrame.setVisible(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.getOwningWindow(), "Xml error!", "Error", 0);
            }
        }
    }

    private synchronized void uploadFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        FileNameExtensionFilter xmlfilter = new FileNameExtensionFilter("xml files (*.xml)", "xml");
        fileChooser.addChoosableFileFilter(xmlfilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle("Please chose the charging script to load");
        int returnVal = fileChooser.showOpenDialog(this.loadButton);
        if (returnVal == 0) {
            File f = fileChooser.getSelectedFile();
            byte[] bytes = null;
            try {
                bytes = BFileUtil.readFile(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.par.setValue(bytes);
        }
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        return "";
    }

    @Override
    public String formatDefaultValue(JacControl.JacPropertyExt prop) {
        return null;
    }

    @Override
    protected int getLongestTextWidth() {
        return 0;
    }

    @Override
    public GridBagConstraints[] getComponentGBCs(int gridy) {
        return new GridBagConstraints[]{new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0), new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0), new GridBagConstraints(2, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0)};
    }

    public class ChargingScriptFrame
    extends JDialog {
        private static final long serialVersionUID = 45946416173L;
        private ChargingScriptPanel chargingScriptPanel;

        public ChargingScriptFrame() {
            super(UILoadMagnetChargingScriptParam.this.getOwningWindow(), "Magnet Charging Script");
            this.chargingScriptPanel = new ChargingScriptPanel();
            this.setLayout(new GridLayout(1, 1));
            JScrollPane p = new JScrollPane(this.chargingScriptPanel);
            p.setHorizontalScrollBarPolicy(30);
            p.setVerticalScrollBarPolicy(20);
            this.add(p);
            this.pack();
        }

        public void setText(String text) {
            this.chargingScriptPanel.setText(text);
        }

        private class ChargingScriptPanel
        extends JPanel {
            private static final long serialVersionUID = -1822063031539449895L;
            JTextArea textArea;

            public ChargingScriptPanel() {
                Insets defaultInsets;
                this.setLayout(new GridBagLayout());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 2;
                constraints.anchor = 17;
                constraints.insets = defaultInsets = new Insets(0, 0, 0, 0);
                this.setLayout(new GridBagLayout());
                constraints.gridx = 0;
                constraints.gridy = 0;
                this.textArea = new JTextArea(40, 100);
                this.textArea.setEditable(false);
                this.add((Component)this.textArea, constraints);
            }

            public void setText(String text) {
                this.textArea.setText(text);
                if (text.length() > 0) {
                    this.textArea.setCaretPosition(0);
                }
            }
        }
    }
}

