/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.compr.xml.CompressorLimits;
import ch.bruker.compr.xml.CompressorLimitsXml;
import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import ch.bruker.util.BFileUtil;
import ch.bruker.util.BUtil;
import ch.bruker.util.PlotFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class UILoadCompressorLimitsParam
extends UIParam {
    private float[] flows;
    private float[] temps;
    private PlotFrame plot = null;
    private final JLabel labelComponent;
    private final JButton showButton;
    private final JButton loadButton;
    private String[] ids;
    private boolean showShiftedCurve;

    public UILoadCompressorLimitsParam(String parId, String modelParamId, String flowParamId, String tempParamId) {
        this(parId, modelParamId, flowParamId, tempParamId, null, null, null, null, false, true);
    }

    public UILoadCompressorLimitsParam(String parId, String modelParamId, String flowParamId, String tempParamId, boolean showLoadButton) {
        this(parId, modelParamId, flowParamId, tempParamId, null, null, null, null, false, showLoadButton);
    }

    public UILoadCompressorLimitsParam(String parId, String modelParamId, String flowParamId, String tempParamId, String flowLowShiftId, String flowHighShiftId, String tmepLowShiftId, String tmepHighShiftId, boolean showShiftedCurve, boolean showLoadButton) {
        super(parId, UIParam.Controls.PRESENT);
        this.ids = new String[]{modelParamId, flowParamId, tempParamId, flowLowShiftId, flowHighShiftId, tmepLowShiftId, tmepHighShiftId};
        this.showShiftedCurve = showShiftedCurve;
        this.showButton = new UIField.BoundedButton("Show limit");
        this.loadButton = showLoadButton ? new UIField.BoundedButton("Load new limits") : null;
        this.labelComponent = new JLabel();
    }

    @Override
    protected void populateComponents(boolean hasControls) {
        this.hasControls = hasControls;
    }

    @Override
    public void bind(Source source, AppState appState) {
        super.bind(source, appState);
        if (this.loadButton != null) {
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    UILoadCompressorLimitsParam.this.loadButton.setEnabled(false);
                    UILoadCompressorLimitsParam.this.showButton.setEnabled(false);
                    UILoadCompressorLimitsParam.this.uploadFile();
                    UILoadCompressorLimitsParam.this.loadButton.setEnabled(true);
                    UILoadCompressorLimitsParam.this.showButton.setEnabled(true);
                }
            });
        }
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UILoadCompressorLimitsParam.this.showLimits();
            }
        });
    }

    @Override
    Component[] getLabelComponents() {
        return new Component[]{this.labelComponent};
    }

    @Override
    Component[] getValueComponents() {
        return new Component[]{this.showButton};
    }

    @Override
    Component[] getControlComponents() {
        return new Component[]{this.showButton, this.loadButton};
    }

    @Override
    void updateValue() {
    }

    @Override
    void updateLabel() {
        this.labelComponent.setText(this.par.getName());
    }

    private synchronized void showLimits() {
        block27: {
            HashMap<ID, JacCommon.JacValueType> pars = new HashMap<ID, JacCommon.JacValueType>();
            try {
                int i = 0;
                for (JacControl.JacPropertyExt prop : this.source.api.getConnection().getParameters(this.ids)) {
                    if (prop == null) continue;
                    pars.put(ID.values()[i++], prop.value);
                }
            }
            catch (JacControl.JacParamNotAvailable e) {
                e.printStackTrace();
                return;
            }
            JacControl.JacPropertyExt xmlParam = this.par.pull();
            if (xmlParam != null) {
                byte[] arr = xmlParam.value.ByteArrayVal();
                try {
                    int model;
                    if ((double)arr.length > 1000000.0) {
                        JOptionPane.showMessageDialog(this.getOwningWindow(), "Xml lenght above 1e6!", "Error", 0);
                        break block27;
                    }
                    String xmlString = new String(arr, "UTF-8");
                    if (!this.checkChecksum(xmlString)) {
                        JOptionPane.showMessageDialog(this.getOwningWindow(), "Xml checksum error!", "Error", 0);
                        break block27;
                    }
                    StringReader reader = new StringReader(xmlString);
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CompressorLimitsXml.class});
                    Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                    CompressorLimitsXml compressorLimits = (CompressorLimitsXml)unmarshaller.unmarshal((Reader)reader);
                    if (!this.generateArrays(compressorLimits, model = ((JacCommon.JacValueType)pars.get((Object)ID.MODEL)).Int32Val())) {
                        JOptionPane.showMessageDialog(this.getOwningWindow(), "Compressor type not found in xml!", "Error", 0);
                        break block27;
                    }
                    float actFlow = ((JacCommon.JacValueType)pars.get((Object)ID.FLOW)).FloatVal();
                    float actTemp = ((JacCommon.JacValueType)pars.get((Object)ID.TEMP)).FloatVal();
                    String date = Integer.toString(compressorLimits.getDate());
                    try {
                        String title = "Approved range, xml date: " + date;
                        if (this.showShiftedCurve) {
                            title = "Approved (inner) and operative (outer) range, xml date: " + date;
                        }
                        if (this.plot == null) {
                            this.plot = new PlotFrame((Frame)this.getOwningWindow(), title, "Flow [lpm]", "Temp [K]");
                        } else {
                            this.plot.setTitle(title);
                            this.plot.clear();
                        }
                        this.plot.setParent(this.getOwningWindow());
                        this.plot.strokeWidth = 2;
                        this.plot.strokeColor = Color.BLACK;
                        this.plot.markerSize = 5;
                        this.plot.markerColor = Color.BLACK;
                        for (int i = 0; i < this.flows.length; ++i) {
                            this.plot.add(this.flows[i], this.temps[i]);
                        }
                        this.plot.add(this.flows[0], this.temps[0]);
                        this.plot.fill = true;
                        this.plot.fillColor = new Color(255, 255, 153);
                        this.plot.draw();
                        if (this.showShiftedCurve) {
                            float[] flowsShifted = new float[this.flows.length];
                            float[] tempsShifted = new float[this.flows.length];
                            try {
                                int i;
                                float flowLow = ((JacCommon.JacValueType)pars.get((Object)ID.FLOW_LOW)).FloatVal();
                                float flowHigh = ((JacCommon.JacValueType)pars.get((Object)ID.FLOW_HIGH)).FloatVal();
                                float tempLow = ((JacCommon.JacValueType)pars.get((Object)ID.TEMP_LOW)).FloatVal();
                                float tempHigh = ((JacCommon.JacValueType)pars.get((Object)ID.TEMP_HIGH)).FloatVal();
                                Point2D.Float[] newPoints = new Point2D.Float[this.flows.length];
                                Point2D.Float[] newDirs = new Point2D.Float[this.flows.length];
                                for (i = 0; i < this.flows.length; ++i) {
                                    int ip = (i + 1) % this.flows.length;
                                    float dx = this.flows[ip] - this.flows[i];
                                    float dy = this.temps[ip] - this.temps[i];
                                    float sigX = Math.signum(-dy);
                                    float sigY = Math.signum(dx);
                                    float sigHx = sigX * (sigX > 0.0f ? flowHigh : flowLow);
                                    float sigHy = sigY * (sigY > 0.0f ? tempHigh : tempLow);
                                    boolean useHx = Math.abs(-dy * sigHx) > Math.abs(dx * sigHy);
                                    newPoints[i] = new Point2D.Float();
                                    if (useHx) {
                                        newPoints[i].setLocation(this.flows[i] + sigHx, this.temps[i]);
                                    } else {
                                        newPoints[i].setLocation(this.flows[i], this.temps[i] + sigHy);
                                    }
                                    newDirs[i] = new Point2D.Float();
                                    newDirs[i].setLocation(dx, dy);
                                }
                                for (i = 0; i < newPoints.length; ++i) {
                                    int im = (i + newPoints.length - 1) % newPoints.length;
                                    double a1 = newDirs[i].getY();
                                    double b1 = -newDirs[i].getX();
                                    double c1 = newPoints[i].getY() * newDirs[i].getX() - newPoints[i].getX() * newDirs[i].getY();
                                    double a2 = newDirs[im].getY();
                                    double b2 = -newDirs[im].getX();
                                    double c2 = newPoints[im].getY() * newDirs[im].getX() - newPoints[im].getX() * newDirs[im].getY();
                                    double det = a1 * b2 - a2 * b1;
                                    flowsShifted[i] = (float)(1.0 / det * (b1 * c2 - b2 * c1));
                                    tempsShifted[i] = (float)(1.0 / det * (a2 * c1 - a1 * c2));
                                }
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(this.getOwningWindow(), "Operative range could not be calculated!", "Error", 0);
                                flowsShifted = this.flows;
                                tempsShifted = this.temps;
                            }
                            this.plot.strokeWidth = 2;
                            this.plot.strokeColor = Color.BLACK;
                            this.plot.markerSize = 4;
                            this.plot.markerColor = Color.RED;
                            this.plot.fill = false;
                            for (int i = 0; i < flowsShifted.length; ++i) {
                                this.plot.add(flowsShifted[i], tempsShifted[i]);
                            }
                            this.plot.add(flowsShifted[0], tempsShifted[0]);
                            this.plot.draw();
                        }
                        this.plot.markerSize = 8;
                        this.plot.markerColor = Color.BLUE;
                        if (BUtil.isUnReal(actFlow)) {
                            JOptionPane.showMessageDialog(this.getOwningWindow(), "Current flow is missing!", "Error", 0);
                        } else if (BUtil.isUnReal(actTemp)) {
                            JOptionPane.showMessageDialog(this.getOwningWindow(), "Current temp is missing!", "Error", 0);
                        } else {
                            this.plot.add(actFlow, actTemp);
                        }
                        this.plot.draw();
                        this.plot.finish(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this.getOwningWindow(), "Plot exception!", "Error", 0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.getOwningWindow(), "Xml parse error!", "Error", 0);
                }
            }
        }
    }

    private boolean generateArrays(CompressorLimitsXml compressorLimits, int compressorId) {
        boolean found = false;
        for (CompressorLimits limit : compressorLimits.getLimits()) {
            Map<Integer, String> compressorIdMap = limit.getCompressorsAsMap();
            if (!compressorIdMap.containsKey(compressorId)) continue;
            found = true;
            this.flows = limit.getLimit1().getLimitFlowArray();
            this.temps = limit.getLimit1().getLimitTempArray();
            break;
        }
        return found;
    }

    private boolean checkChecksum(String xml) throws NoSuchAlgorithmException {
        String calculatedChecksum = this.getXmlChecksum(xml);
        int indexOfChecksum = xml.indexOf("<Checksum>") + 10;
        int indexOfChecksumEnd = xml.indexOf("</Checksum>", 0);
        String xmlChecksum = xml.substring(indexOfChecksum, indexOfChecksumEnd);
        return calculatedChecksum.equals(xmlChecksum);
    }

    private String getXmlChecksum(String xml) throws NoSuchAlgorithmException {
        boolean ignore = true;
        boolean endtag = false;
        String xmlNoChecksum = xml.replaceAll("<Checksum>.*<.Checksum>", "");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < xmlNoChecksum.length(); ++i) {
            char c2 = xmlNoChecksum.charAt(i);
            if (c2 == '>') {
                buf.append(c2);
                int nextStart = xmlNoChecksum.indexOf(60, i);
                if (nextStart >= 0 && xmlNoChecksum.charAt(nextStart + 1) == '/' && !endtag) continue;
                ignore = true;
                continue;
            }
            if (!ignore) {
                buf.append(c2);
                if (c2 != '/' || xmlNoChecksum.charAt(i - 1) != '<') continue;
                endtag = true;
                continue;
            }
            if (!ignore || c2 != '<') continue;
            buf.append(c2);
            ignore = false;
            endtag = false;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(buf.toString().getBytes());
        byte[] hash = messageDigest.digest();
        return DatatypeConverter.printHexBinary((byte[])hash).toUpperCase();
    }

    private synchronized void uploadFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        FileNameExtensionFilter xmlfilter = new FileNameExtensionFilter("xml files (*.xml)", "xml");
        fileChooser.addChoosableFileFilter(xmlfilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle("Please chose the limits file to load");
        int returnVal = fileChooser.showOpenDialog(this.loadButton);
        if (returnVal == 0) {
            File f = fileChooser.getSelectedFile();
            byte[] bytes = null;
            try {
                bytes = BFileUtil.readFile(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.par.setValue(bytes);
        }
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        return "";
    }

    @Override
    public String formatDefaultValue(JacControl.JacPropertyExt prop) {
        return null;
    }

    @Override
    protected int getLongestTextWidth() {
        return 0;
    }

    @Override
    public GridBagConstraints[] getComponentGBCs(int gridy) {
        return new GridBagConstraints[]{new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0), new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0), new GridBagConstraints(2, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0)};
    }

    static enum ID {
        MODEL,
        FLOW,
        TEMP,
        FLOW_LOW,
        FLOW_HIGH,
        TEMP_LOW,
        TEMP_HIGH;

    }
}

