/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class UIField {
    static int MAX_COMP_HEIGHT = 20;

    public abstract Component[] getComponents();

    public abstract GridBagConstraints[] getComponentGBCs(int var1);

    public Window getOwningWindow() {
        Component component = this.getComponents()[0];
        return component == null ? null : SwingUtilities.windowForComponent(component);
    }

    public void setInactivityMode(DisplayMode displayMode) {
        Component[] components;
        block5: for (Component component : components = this.getComponents()) {
            if (component == null) continue;
            switch (displayMode) {
                case ACTIVE: {
                    component.setVisible(true);
                    component.setEnabled(true);
                    continue block5;
                }
                case DISABLED: {
                    component.setVisible(true);
                    component.setEnabled(false);
                    continue block5;
                }
                case HIDDEN: {
                    component.setVisible(false);
                }
            }
        }
    }

    public String getDefaultValueString() {
        return null;
    }

    protected class ToolTippedTextField
    extends JTextField
    implements WidthConfigurable {
        private int preferredWidth = 100;

        public ToolTippedTextField() {
            this.setToolTipText("");
        }

        @Override
        public void setPreferredWidth(int maxWidth) {
            this.preferredWidth = maxWidth;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            String defaultValue = UIField.this.getDefaultValueString();
            if (this.isEnabled() && defaultValue != null && !defaultValue.isEmpty()) {
                return "<html>" + this.getText() + "<br>" + "Default value: " + defaultValue + "</html>";
            }
            return this.getText();
        }

        @Override
        public Dimension getPreferredSize() {
            int maxedHeight = Math.min(MAX_COMP_HEIGHT, super.getPreferredSize().height);
            return new Dimension(this.preferredWidth, maxedHeight);
        }
    }

    protected static class BoundedButton
    extends JButton {
        private static final int PADDING = 2;

        public BoundedButton(String text) {
            super(text);
            this.setMargin(new Insets(2, 2, 2, 2));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, MAX_COMP_HEIGHT);
        }
    }

    protected static class BoundedRadioButton
    extends JRadioButton {
        public BoundedRadioButton(String text) {
            super(text);
        }

        @Override
        public Dimension getPreferredSize() {
            int maxedHeight = Math.min(MAX_COMP_HEIGHT, super.getPreferredSize().height);
            return new Dimension(super.getPreferredSize().width, maxedHeight);
        }
    }

    protected static class BoundedCombo
    extends JComboBox {
        protected BoundedCombo() {
        }

        @Override
        public Dimension getPreferredSize() {
            int maxedHeight = Math.min(MAX_COMP_HEIGHT, super.getPreferredSize().height);
            return new Dimension(super.getPreferredSize().width, maxedHeight);
        }
    }

    protected static interface WidthConfigurable {
        public void setPreferredWidth(int var1);
    }

    public static enum DisplayMode {
        HIDDEN,
        DISABLED,
        ACTIVE;

    }
}

