/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.data.cache.EnumDescriptor;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIClassicParam;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import com.google.common.collect.HashBiMap;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UIEnumParam
extends UIClassicParam {
    private static final int MAX_NR_OF_BUTTONS = 2;
    private static final int READ_ONLY_OPTION = Integer.MAX_VALUE;
    private DisplayType displayType;
    private JPanel controlPanel = new JPanel();
    private HashBiMap<Integer, String> allowedActions = HashBiMap.create();
    private int currentAction = -1;
    private final String actionParId;
    protected UIParam.Par actionPar;

    public UIEnumParam(String paramId, String actionParId, DisplayType displayType) {
        super(paramId, UIParam.Controls.DETECT);
        this.actionParId = actionParId;
        this.displayType = displayType;
    }

    public UIEnumParam(String paramId, String actionParId, boolean forceDropdown) {
        this(paramId, actionParId, forceDropdown ? DisplayType.DROPDOWN : DisplayType.AUTO);
    }

    public UIEnumParam(String paramId, String actionParId) {
        this(paramId, actionParId, DisplayType.AUTO);
    }

    @Override
    void bind(Source source, AppState appState) {
        super.bind(source, appState);
        this.actionPar = this.actionParId != null ? new UIParam.Par(this, this.actionParId) : null;
    }

    @Override
    protected void populateComponents(boolean hasControls) {
        this.hasControls = this.actionPar != null && this.actionPar.checkAccess();
        this.valueComponent.setEditable(false);
        if (this.hasControls) {
            this.setControlComponent(this.controlPanel);
        }
    }

    @Override
    boolean isControllable() {
        return this.hasControls && this.actionPar.checkAccess() && this.appState.isMode(GuiMode.TRACKING);
    }

    @Override
    Component[] getControlComponents() {
        return new Component[]{this.controlComponent};
    }

    @Override
    void updateValue() {
        super.updateValue();
        if (this.actionPar == null) {
            return;
        }
        this.actionPar.getValue(new UIParam.ValueUpdate(){

            @Override
            public void update(String actionParValue) {
                UIEnumParam.this.updateAllowedActions(actionParValue);
                UIEnumParam.this.updateControllable();
            }
        });
    }

    private void updateAllowedActions(String actionValue) {
        if (!this.hasControls) {
            return;
        }
        HashBiMap<Integer, String> allowedActions_ = this.actionPar.getAllowedValues();
        this.currentAction = allowedActions_.containsValue(actionValue) ? (Integer)allowedActions_.inverse().get(actionValue) : Integer.MAX_VALUE;
        this.allowedActions = allowedActions_;
        try {
            if (this.controlPanel.getComponents().length > 0 && ((JComboBox)this.controlPanel.getComponents()[0]).isPopupVisible()) {
                return;
            }
        }
        catch (ClassCastException ignore) {
            // empty catch block
        }
        this.controlPanel.removeAll();
        this.controlPanel.setLayout(new GridBagLayout());
        DisplayType currentType = this.displayType;
        if (currentType == DisplayType.AUTO) {
            DisplayType displayType = currentType = this.allowedActions.size() > 2 ? DisplayType.DROPDOWN : DisplayType.BUTTONS;
        }
        if (currentType == DisplayType.BUTTONS) {
            int index = 0;
            for (final Map.Entry allowedValue : this.allowedActions.entrySet()) {
                UIField.BoundedButton button = new UIField.BoundedButton((String)allowedValue.getValue());
                Dimension d = ((JComponent)button).getPreferredSize();
                d.height = new JLabel((String)"[dummy]").getPreferredSize().height;
                button.setPreferredSize(d);
                this.controlPanel.add((Component)button, new GridBagConstraints(index++, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 2, 0, 2), 0, 0));
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UIEnumParam.this.deferUpdate((Integer)allowedValue.getKey());
                        UIEnumParam.this.valueComponent.getParent().requestFocus();
                    }
                });
            }
        } else {
            String SELECT_STRING = "[Please Choose]";
            final UIField.BoundedCombo combo = new UIField.BoundedCombo();
            boolean found = false;
            for (Map.Entry allowedAction : this.allowedActions.entrySet()) {
                combo.addItem(allowedAction.getValue());
                if (this.currentAction != (Integer)allowedAction.getKey()) continue;
                combo.setSelectedItem(allowedAction.getValue());
                found = true;
            }
            if (!found) {
                combo.insertItemAt("[Please Choose]", 0);
                combo.setSelectedItem("[Please Choose]");
            }
            combo.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.controlPanel.add((Component)combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 2, 0, 2), 0, 0));
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("[Please Choose]".equals(combo.getSelectedItem())) {
                        return;
                    }
                    int val = (Integer)UIEnumParam.this.allowedActions.inverse().get(combo.getSelectedItem());
                    UIEnumParam.this.deferUpdate(val);
                    UIEnumParam.this.valueComponent.getParent().requestFocus();
                }
            });
        }
        this.controlPanel.revalidate();
    }

    public void deferUpdate(int val) {
        this.controlPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.actionPar.setValue(val);
        this.controlPanel.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        this.formattedValue = "-";
        for (JacControl.JacPropertyEntryName allowedValue : prop.allowedValues) {
            if (allowedValue.value.Int32Val() != prop.value.Int32Val()) continue;
            this.formattedValue = allowedValue.name;
        }
        return this.formattedValue;
    }

    @Override
    public String formatDefaultValue(JacControl.JacPropertyExt prop) {
        if (prop.defaultValue.discriminator() == JacCommon.JacValueTypes.ValueInt32) {
            this.formattedValue = "-";
            for (JacControl.JacPropertyEntryName allowedValue : prop.allowedValues) {
                if (allowedValue.value.Int32Val() != prop.defaultValue.Int32Val()) continue;
                this.formattedValue = allowedValue.name;
            }
            return this.formattedValue;
        }
        return null;
    }

    @Override
    protected int getLongestTextWidth() {
        int width;
        block3: {
            FontMetrics fm;
            block2: {
                fm = this.valueComponent.getFontMetrics(this.valueComponent.getFont());
                width = 100;
                if (this.actionPar.prop.equals(NOT_AVAILABLE)) break block2;
                for (String allowedValue : this.allowedActions.values()) {
                    width = Math.max(width, fm.stringWidth(allowedValue));
                }
                break block3;
            }
            if (this.par.descriptor == null || !(this.par.descriptor instanceof EnumDescriptor)) break block3;
            EnumDescriptor d = (EnumDescriptor)this.par.descriptor;
            for (String val : d.getLabels().values()) {
                width = Math.max(width, fm.stringWidth(val));
            }
        }
        return width;
    }

    public static enum DisplayType {
        DROPDOWN,
        BUTTONS,
        AUTO;

    }
}

