/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UINumericParam;
import ch.bruker.util.BFileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class UICrcoSbsbFirmwareDownloadParam
extends UINumericParam {
    private static final JLabel EMPTY_LABEL = new JLabel();
    private final JButton downloadButton = new UIField.BoundedButton("Download Firmware\u2026");

    public UICrcoSbsbFirmwareDownloadParam(String paramId) {
        super(paramId);
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UICrcoSbsbFirmwareDownloadParam.this.downloadButton.setEnabled(false);
                UICrcoSbsbFirmwareDownloadParam.this.firmwareDownload();
                UICrcoSbsbFirmwareDownloadParam.this.downloadButton.setEnabled(true);
            }
        });
    }

    private synchronized void firmwareDownload() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new CrcoFirmwareFilenameFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle("Please chose the firmware file to download to the CRCO");
        int returnVal = fileChooser.showOpenDialog(this.downloadButton);
        if (returnVal == 0) {
            File f = fileChooser.getSelectedFile();
            String nameStr = "crco\\" + f.getName();
            byte[] name = nameStr.getBytes();
            byte[] fw = null;
            try {
                fw = BFileUtil.readFile(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] completeArr = new byte[name.length + 1 + fw.length];
            System.arraycopy(name, 0, completeArr, 0, name.length);
            completeArr[name.length] = 0;
            System.arraycopy(fw, 0, completeArr, name.length + 1, fw.length);
            this.par.setValue(completeArr);
        }
    }

    @Override
    Component[] getControlComponents() {
        return new JButton[]{this.downloadButton};
    }

    @Override
    public Component[] getValueComponents() {
        return new JLabel[]{EMPTY_LABEL};
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        this.formattedValue = "";
        return this.formattedValue;
    }

    @Override
    protected int getLongestTextWidth() {
        return 0;
    }

    private class CrcoFirmwareFilenameFilter
    extends FileFilter {
        private CrcoFirmwareFilenameFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.toLowerCase().startsWith("crco") && name.toLowerCase().endsWith(".abs");
        }

        @Override
        public String getDescription() {
            return "crco*.abs";
        }
    }
}

