/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.mon.RemoteMonitoringCustomerPanel;
import ch.bruker.jac.servicegui.status.ui.UIBooleanParam;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class UIConfigureMonitoringParam
extends UIBooleanParam {
    private final JLabel labelComponent;
    private final JButton configureButton = new UIField.BoundedButton("Configure");

    public UIConfigureMonitoringParam(String parId) {
        super(parId, UIParam.Controls.PRESENT, null);
        this.labelComponent = new JLabel("Remote monitoring");
    }

    @Override
    public void bind(Source source, AppState appState) {
        super.bind(source, appState);
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UIConfigureMonitoringParam.this.showConfigureFrame();
            }
        });
    }

    @Override
    Component[] getLabelComponents() {
        return new Component[]{this.labelComponent};
    }

    @Override
    Component[] getControlComponents() {
        return new Component[]{this.configureButton};
    }

    @Override
    void updateLabel() {
    }

    private synchronized void showConfigureFrame() {
        try {
            final RemoteMonitoringCustomerPanel remMonPanel = new RemoteMonitoringCustomerPanel(this.source.api, this.appState.getUserLevel());
            final JDialog f = new JDialog(this.getOwningWindow(), "BRUKER Remote Monitoring", Dialog.ModalityType.DOCUMENT_MODAL);
            f.setDefaultCloseOperation(0);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    if (remMonPanel.isEditing() && JOptionPane.showConfirmDialog(f, "Do you want to save your changes?", "Save Settings", 0, 3, null) == 0) {
                        remMonPanel.callSaveAction();
                        if (remMonPanel.isEditing()) {
                            return;
                        }
                    }
                    f.setVisible(false);
                    f.dispose();
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    super.windowOpened(e);
                    remMonPanel.checkIdComplete();
                }
            });
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)remMonPanel, "Center");
            f.setSize(800, 600);
            f.setLocationRelativeTo(this.getOwningWindow());
            f.setVisible(true);
        }
        catch (RuntimeException e) {
            JOptionPane.showConfirmDialog(this.getOwningWindow(), e.getMessage(), "BRUKER Remote Monitoring", -1, 2, null);
        }
    }

    @Override
    public GridBagConstraints[] getComponentGBCs(int gridy) {
        return new GridBagConstraints[]{new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0), new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0), new GridBagConstraints(2, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0)};
    }
}

