/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class UIClassicParam
extends UIParam {
    private static Color DEFAULT_TEXT_FIELD_FOREGROUND = UIManager.getColor("TextField.foreground");
    private final int widthInZeros;
    protected JLabel labelComponent;
    protected JTextField valueComponent;
    protected Component controlComponent;
    protected String labelToolTip;
    protected String defaultValue;

    public UIClassicParam(String paramId, UIParam.Controls controls, int widthInZeros) {
        super(paramId, controls);
        this.widthInZeros = widthInZeros;
        this.labelComponent = new JLabel();
        this.valueComponent = new UIField.ToolTippedTextField(this);
        this.valueComponent.setHorizontalAlignment(4);
        this.valueComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray, 1), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.valueComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                boolean textEquality = UIClassicParam.this.valueComponent.getText().equals(UIClassicParam.this.formattedValue);
                if (textEquality) {
                    UIClassicParam.this.valueComponent.setForeground(DEFAULT_TEXT_FIELD_FOREGROUND);
                } else {
                    UIClassicParam.this.valueComponent.setForeground(Color.red);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        });
        this.valueComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                if (e.getKeyChar() == '\u001b') {
                    UIClassicParam.this.valueComponent.setText(UIClassicParam.this.formattedValue);
                    UIClassicParam.this.valueComponent.setForeground(DEFAULT_TEXT_FIELD_FOREGROUND);
                }
            }
        });
    }

    public UIClassicParam(String paramId, boolean shouldBeControllable) {
        this(paramId, shouldBeControllable ? UIParam.Controls.PRESENT : UIParam.Controls.NONE, 0);
    }

    public UIClassicParam(String paramId, UIParam.Controls controls) {
        this(paramId, controls, 0);
    }

    @Override
    void bind(Source source, AppState appState) {
        super.bind(source, appState);
        if (this.widthInZeros > 0) {
            int width = this.labelComponent.getFontMetrics(this.labelComponent.getFont()).charWidth('0') * this.widthInZeros;
            if (this.valueComponent instanceof UIField.WidthConfigurable) {
                ((UIField.WidthConfigurable)((Object)this.valueComponent)).setPreferredWidth(width);
            } else {
                this.valueComponent.setPreferredSize(new Dimension(width, (int)this.valueComponent.getPreferredSize().getHeight()));
            }
        }
        if (this.labelToolTip != null) {
            this.labelComponent.setToolTipText(this.labelToolTip);
        }
    }

    @Override
    void updateLabel() {
        this.labelComponent.setText(this.par.getName());
    }

    @Override
    void updateValue() {
        if (!this.isActive()) {
            this.valueComponent.setText("");
            return;
        }
        this.par.getValue(new UIParam.ValueUpdate(){

            @Override
            public void update(String value) {
                if (UIClassicParam.this.isControllable() && UIClassicParam.this.valueComponent.hasFocus()) {
                    return;
                }
                UIClassicParam.this.valueComponent.setText(value);
                UIClassicParam.this.valueComponent.setCaretPosition(0);
            }
        });
    }

    @Override
    public GridBagConstraints[] getComponentGBCs(int gridy) {
        return new GridBagConstraints[]{this.getLabelComponentGBC(gridy), this.getValueComponentGBC(gridy), this.getControlComponentGBC(gridy)};
    }

    @Override
    Component[] getValueComponents() {
        return new Component[]{this.valueComponent};
    }

    @Override
    Component[] getControlComponents() {
        return new Component[]{this.valueComponent, this.controlComponent};
    }

    @Override
    Component[] getLabelComponents() {
        return new Component[]{this.labelComponent};
    }

    @Override
    public String getDefaultValueString() {
        return this.par.getDefaultValue();
    }

    @Override
    protected abstract int getLongestTextWidth();

    void setControlComponent(JComponent component) {
        this.controlComponent = component;
    }

    private GridBagConstraints getLabelComponentGBC(int gridy) {
        return new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 3, 25), 0, 0);
    }

    private GridBagConstraints getValueComponentGBC(int gridy) {
        return new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 5, 3, 10), 0, 0);
    }

    private GridBagConstraints getControlComponentGBC(int gridy) {
        return new GridBagConstraints(2, gridy, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 10, 3, 5), 0, 0);
    }

    public UIClassicParam setToolTipText(String text) {
        this.labelToolTip = text;
        this.labelComponent.setToolTipText(this.labelToolTip);
        return this;
    }
}

