/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import ch.bruker.jac.servicegui.status.ui.UIStringParam;
import ch.bruker.util.BFileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class UICalibrationCurveLoadParam
extends UIStringParam {
    private final JButton downloadButton = new UIField.BoundedButton("Load calibration\u2026");
    private final String actionParId;
    private final String fileExtension;
    private UIParam.Par actionPar;

    public UICalibrationCurveLoadParam(String calParamId, String loadedCalStringParamId, String fileExtension) {
        super(loadedCalStringParamId);
        this.actionParId = calParamId;
        this.fileExtension = fileExtension;
        this.valueComponent.setEditable(false);
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UICalibrationCurveLoadParam.this.downloadButton.setEnabled(false);
                UICalibrationCurveLoadParam.this.loadCalibration();
                UICalibrationCurveLoadParam.this.downloadButton.setEnabled(true);
            }
        });
    }

    @Override
    boolean isControllable() {
        return this.hasControls && this.actionPar.checkAccess() && this.appState.isMode(GuiMode.TRACKING);
    }

    @Override
    protected void populateComponents(boolean hasControls) {
        super.populateComponents(this.actionPar.checkAccess());
        this.hasControls = this.actionPar.checkAccess();
    }

    @Override
    void bind(Source source, AppState appState) {
        super.bind(source, appState);
        this.actionPar = new UIParam.Par(this, this.actionParId);
    }

    private synchronized void loadCalibration() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new CalibrationCurveFilenameFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle("Please chose the calibration file to load");
        int returnVal = fileChooser.showOpenDialog(this.downloadButton);
        if (returnVal == 0) {
            File f = fileChooser.getSelectedFile();
            byte[] cal = null;
            byte[] ext = null;
            try {
                String extString = this.fileExtension + "\n";
                ext = extString.getBytes("UTF-8");
                cal = BFileUtil.readFile(f);
                byte[] completeArr = new byte[ext.length + cal.length];
                System.arraycopy(ext, 0, completeArr, 0, ext.length);
                System.arraycopy(cal, 0, completeArr, ext.length, cal.length);
                this.actionPar.setValue(completeArr);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showGenericErrorMessage();
            }
        }
    }

    @Override
    Component[] getControlComponents() {
        return new JButton[]{this.downloadButton};
    }

    private class CalibrationCurveFilenameFilter
    extends FileFilter {
        private CalibrationCurveFilenameFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.toLowerCase().endsWith(UICalibrationCurveLoadParam.this.fileExtension);
        }

        @Override
        public String getDescription() {
            return "*" + UICalibrationCurveLoadParam.this.fileExtension;
        }
    }
}

