/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.ui;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.data.cache.BooleanDescriptor;
import ch.bruker.jac.servicegui.status.ui.UIClassicParam;
import ch.bruker.jac.servicegui.status.ui.UIField;
import ch.bruker.jac.servicegui.status.ui.UIParam;
import com.google.common.collect.ImmutableMap;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class UIBooleanParam
extends UIClassicParam {
    private static final ImmutableMap<String, String> TOGGLE_VERBS = ImmutableMap.builder().put("enabled", "Disable").put("disabled", "Enable").put("open", "Close").put("closed", "Open").put("off", "Turn on").put("on", "Turn off").put("dhcp", "Set static").put("static", "Set DHCP").build();
    private final String inverseAction;
    protected JButton button;

    public UIBooleanParam(String paramId, UIParam.Controls controls, String inverseAction) {
        super(paramId, controls);
        this.inverseAction = inverseAction;
        this.valueComponent.setEditable(false);
    }

    public UIBooleanParam(String paramId, String inverseAction) {
        this(paramId, UIParam.Controls.DETECT, inverseAction);
    }

    public UIBooleanParam(String paramId, boolean shouldBeControllable) {
        this(paramId, shouldBeControllable ? UIParam.Controls.PRESENT : UIParam.Controls.NONE, null);
    }

    public UIBooleanParam(String paramId) {
        this(paramId, UIParam.Controls.DETECT, null);
    }

    public UIBooleanParam(String paramId, boolean shouldBeControllable, String inverseAction) {
        this(paramId, shouldBeControllable ? UIParam.Controls.PRESENT : UIParam.Controls.NONE, inverseAction);
    }

    @Override
    protected void populateComponents(boolean hasControls) {
        this.hasControls = hasControls;
        if (hasControls) {
            this.button = new UIField.BoundedButton("Action");
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIBooleanParam.this.button.setCursor(Cursor.getPredefinedCursor(3));
                    boolean current = UIBooleanParam.this.par.pull().value.BooleanVal();
                    UIBooleanParam.this.par.setValue(!current);
                    UIBooleanParam.this.button.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.setControlComponent(this.button);
        }
    }

    @Override
    void updateValue() {
        super.updateValue();
        this.par.getValue(new UIParam.ValueUpdate(){

            @Override
            public void update(String value) {
                if (UIBooleanParam.this.hasControls) {
                    UIBooleanParam.this.button.setText(UIBooleanParam.this.getToggleVerb(value));
                }
            }
        });
    }

    private String getToggleVerb(String stateLabel) {
        if (this.inverseAction == null) {
            String key = stateLabel.toLowerCase();
            return TOGGLE_VERBS.containsKey(key) ? TOGGLE_VERBS.get(key) : "Toggle";
        }
        return this.inverseAction;
    }

    @Override
    Component[] getControlComponents() {
        return new Component[]{this.controlComponent};
    }

    @Override
    public String format(JacControl.JacPropertyExt prop) {
        this.formattedValue = prop.value.BooleanVal() ? prop.allowedValues[0].name : prop.allowedValues[1].name;
        return this.formattedValue;
    }

    @Override
    public String formatDefaultValue(JacControl.JacPropertyExt prop) {
        if (prop.defaultValue.discriminator() == JacCommon.JacValueTypes.ValueBoolean) {
            return prop.defaultValue.BooleanVal() ? prop.allowedValues[0].name : prop.allowedValues[1].name;
        }
        return null;
    }

    @Override
    protected int getLongestTextWidth() {
        FontMetrics fm = this.valueComponent.getFontMetrics(this.valueComponent.getFont());
        String labelFalse = "dummywidth";
        String labelTrue = "";
        if (this.par.descriptor != null && this.par.descriptor.eventLogged) {
            if (this.par.descriptor instanceof BooleanDescriptor) {
                BooleanDescriptor d = (BooleanDescriptor)this.par.descriptor;
                labelFalse = d.labelFalse;
                labelTrue = d.labelTrue;
            } else {
                SGUtils.log("Error: Parameter is not a boolean: %s", this.par.parId);
            }
        } else if (!this.par.prop.equals(NOT_AVAILABLE)) {
            labelFalse = this.par.prop.allowedValues[0].name;
            labelTrue = this.par.prop.allowedValues[1].name;
        }
        return Math.max(fm.stringWidth(labelFalse), fm.stringWidth(labelTrue));
    }
}

