/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.mon;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.img.Images;
import ch.bruker.jac.servicegui.status.mon.DocumentSizeFilter;
import ch.bruker.jac.servicegui.status.mon.GUIUtils;
import ch.bruker.jac.servicegui.status.mon.GridLayout3;
import ch.bruker.jac.servicegui.status.mon.MriDesign;
import ch.bruker.jac.servicegui.status.mon.ProductType;
import ch.bruker.jac.servicegui.status.mon.RemoteMonitoringCustomerPanel;
import ch.bruker.mon.xml.MonitoringIDXml;
import ch.bruker.mon.xml.MonitoringIDXmlMri;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class RemoteMonitoringSystemIdPanel
extends JPanel {
    private static final long serialVersionUID = 479443414215644811L;
    private final JToggleButton changeButton;
    private final String idParam = "MMS_RM_ID_XML";
    private final String idTestXmlParam = "MMS_RM_ID_TEST_XML";
    private final String idTestCommandParam = "MMS_RM_TEST_ID";
    private MonitoringIDXml monitoringIDXml = null;
    private final JComboBox product_type;
    private static final String ID_PRODUCT_TYPE = "Product Type";
    final JPanel nmrIdPanel = new JPanel();
    final JPanel ftmsIdPanel = new JPanel();
    final MirIdPanel mriIdPanel = new MirIdPanel();
    private static final String ID_PART_NUMBER = "Part Number";
    private static final String ID_SERIAL_NUMBER = "Serial Number";
    private static final String ID_RT_BORE = "RT Bore [mm]";
    private static final String ID_PREFIX = "Prefix";
    private static final String ID_FIELD = "Field [T]";
    private static final String ID_DESIGN = "Design";
    private final ApiTalker api;
    private final JacPublicDefinitions.UserLevel userLevel;

    public RemoteMonitoringSystemIdPanel(ApiTalker api, JacPublicDefinitions.UserLevel userLevel) {
        super(new BorderLayout());
        this.api = api;
        this.userLevel = userLevel;
        this.changeButton = new JToggleButton("Edit", new ImageIcon(Images.class.getResource("change.gif")));
        this.product_type = new JComboBox<ProductType>(new ProductType[]{ProductType.MRI});
        this.add((Component)this.createMainPanel(), "Center");
    }

    private JPanel createMainPanel() {
        JPanel p = new JPanel(new BorderLayout());
        String info = "System Identification";
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(info), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        JTabbedPane contactPane = new JTabbedPane();
        JPanel sysIdArea = this.createSystemIdentificationArea();
        contactPane.add("System Identification", sysIdArea);
        contactPane.setIconAt(0, new ImageIcon(Images.class.getResource("key.png")));
        p.add((Component)sysIdArea, "Center");
        p.add((Component)this.createBottomPanel(), "South");
        return p;
    }

    private JPanel createBottomPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.changeButton.setToolTipText("modify system identification data for remote monitoring");
        this.changeButton.setMargin(new Insets(1, 1, 1, 1));
        GUIUtils.setButtonSizeFix(this.changeButton, this.changeButton.getPreferredSize().width + 65, this.changeButton.getPreferredSize().height);
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RemoteMonitoringSystemIdPanel.this.changeButton.isSelected()) {
                    RemoteMonitoringSystemIdPanel.this.product_type.setEnabled(true);
                    RemoteMonitoringSystemIdPanel.this.nmrIdPanel.setEnabled(true);
                    RemoteMonitoringSystemIdPanel.this.mriIdPanel.setEnabled(true);
                    RemoteMonitoringSystemIdPanel.this.ftmsIdPanel.setEnabled(true);
                    RemoteMonitoringSystemIdPanel.this.changeButton.setIcon(new ImageIcon(Images.class.getResource("save_small.gif")));
                    RemoteMonitoringSystemIdPanel.this.changeButton.setText("Check and Save");
                } else {
                    String checkMessage = RemoteMonitoringSystemIdPanel.this.checkMandatoryIdFields();
                    if (checkMessage != null) {
                        RemoteMonitoringSystemIdPanel.this.changeButton.setSelected(true);
                        JOptionPane.showMessageDialog(RemoteMonitoringSystemIdPanel.this, checkMessage, "Missing Data", 1);
                        return;
                    }
                    try {
                        boolean saved = RemoteMonitoringSystemIdPanel.this.testAndSaveId(false);
                        if (!saved) {
                            RemoteMonitoringSystemIdPanel.this.changeButton.setSelected(true);
                            return;
                        }
                    }
                    catch (IOException ioex) {
                        System.out.println(ioex.getMessage());
                        JOptionPane.showMessageDialog(RemoteMonitoringSystemIdPanel.this, "Error saving data:\n" + ioex.getMessage(), "Error", 0);
                        return;
                    }
                    RemoteMonitoringSystemIdPanel.this.product_type.setEnabled(false);
                    RemoteMonitoringSystemIdPanel.this.nmrIdPanel.setEnabled(false);
                    RemoteMonitoringSystemIdPanel.this.mriIdPanel.setEnabled(false);
                    RemoteMonitoringSystemIdPanel.this.ftmsIdPanel.setEnabled(false);
                    RemoteMonitoringSystemIdPanel.this.changeButton.setIcon(new ImageIcon(Images.class.getResource("change.gif")));
                    RemoteMonitoringSystemIdPanel.this.changeButton.setText("Edit");
                }
            }
        });
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.5;
        c2.anchor = 17;
        p.add((Component)this.changeButton, c2);
        c2.gridx = 1;
        c2.weightx = 1.0;
        p.add((Component)new JLabel(), c2);
        return p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean testAndSaveId(boolean forceSend) throws IOException {
        boolean sendID;
        boolean save = false;
        MonitoringIDXmlMri newIDXml = null;
        if (this.product_type.getSelectedItem() == ProductType.MRI) {
            newIDXml = new MonitoringIDXmlMri(ProductType.MRI.id, this.mriIdPanel.part_number.getText(), this.mriIdPanel.serial_number.getText(), this.mriIdPanel.mri_rt_bore.getText(), this.mriIdPanel.prefix.getText(), this.mriIdPanel.field.getText(), this.mriIdPanel.design.getSelectedItem() == null ? "" : Integer.toString(((MriDesign)((Object)((MirIdPanel)this.mriIdPanel).design.getSelectedItem())).id));
        } else {
            System.out.println("RemoteMonitoringSystemIdPanel.checkMandatoryIdFields(): unsupported type: " + this.product_type.getSelectedItem());
        }
        boolean bl = sendID = newIDXml != null && (this.monitoringIDXml == null || !this.monitoringIDXml.equals(newIDXml));
        if (forceSend || sendID) {
            System.out.println("RemoteMonitoringSystemIdPanel: Writing identifcation test data to JAC");
            IdTestResult result = this.writeIDTest(newIDXml);
            switch (result) {
                case ID_EXISTS: {
                    if (JOptionPane.showConfirmDialog(this, "This system is already registered with the remote monitoring server.\nA registration of two different systems with the same identification may lead to trouble on the server.\nDo you want to contiune anyway?", "Id already exists", 0, 2, null) != 0) break;
                    save = true;
                    break;
                }
                case JAC_COM_ERROR: {
                    JOptionPane.showMessageDialog(this, "The communication with the JAC failed", "Communication error", 0);
                    break;
                }
                case NEW_ID: {
                    if (JOptionPane.showConfirmDialog(this, "This system is registered with the remote monitoring server for the first time.\nDo you want to continue and save the identification data?", "Save Settings", 0, 3, null) != 0) break;
                    save = true;
                    break;
                }
                case SERVER_COM_ERROR: {
                    if (JOptionPane.showConfirmDialog(this, "The communication with the remote monitoring server failed.\nIt cannot be checked whether this system is alread registered or not.\nDo you want to save your changes anyway?", "Communication Error", 0, 0, null) != 0) break;
                    save = true;
                    break;
                }
                case XML_ERROR: {
                    JOptionPane.showMessageDialog(this, "Unknkown error. Please check the Servcie GUI log file and contact Bruker.", "Xml error", 0);
                    break;
                }
            }
            if (save) {
                System.out.println("RemoteMonitoringSystemIdPanel: Writing identifcation data to JAC");
                if (!this.writeID(newIDXml)) throw new IOException("Failed to send identifcation data to JAC.");
                this.readID(true);
                return save;
            } else {
                System.out.println("RemoteMonitoringSystemIdPanel: Identifcation data not written to JAC");
            }
            return save;
        } else {
            save = true;
            System.out.println("RemoteMonitoringSystemIdPanel: Save Identification Information: No changes");
        }
        return save;
    }

    public String checkMandatoryIdFields() {
        if (this.product_type.getSelectedItem() == ProductType.MRI) {
            String add;
            this.mriIdPanel.part_number.setText(RemoteMonitoringSystemIdPanel.filterInput(this.mriIdPanel.part_number.getText()));
            this.mriIdPanel.serial_number.setText(RemoteMonitoringSystemIdPanel.filterInput(this.mriIdPanel.serial_number.getText()));
            this.mriIdPanel.mri_rt_bore.setText(RemoteMonitoringSystemIdPanel.filterInput(this.mriIdPanel.mri_rt_bore.getText()));
            this.mriIdPanel.prefix.setText(RemoteMonitoringSystemIdPanel.filterInput(this.mriIdPanel.prefix.getText()));
            this.mriIdPanel.field.setText(RemoteMonitoringSystemIdPanel.filterInput(this.mriIdPanel.field.getText()));
            String string = add = this.userLevel == JacPublicDefinitions.UserLevel.USER ? " (service access required)" : "";
            if (this.mriIdPanel.part_number.getText().trim().length() == 0) {
                return "Identification: Please fill out 'Part Number'" + add;
            }
            if (this.mriIdPanel.serial_number.getText().trim().length() == 0) {
                return "Installation address: Please fill out 'Serial Number'" + add;
            }
            try {
                this.mriIdPanel.serial_number.setText(Integer.toString(Integer.parseInt(this.mriIdPanel.serial_number.getText())));
            }
            catch (Exception e) {
                return "Identification: Please enter a valid number for 'Serial Number'" + add;
            }
            if (this.mriIdPanel.mri_rt_bore.getText().trim().length() == 0) {
                return "Installation address: Please fill out 'RT Bore [mm]'" + add;
            }
            if (this.mriIdPanel.prefix.getText().trim().length() == 0) {
                return "Installation address: Please fill out 'Prefix'" + add;
            }
            if (this.mriIdPanel.field.getText().trim().length() == 0) {
                return "Installation address: Please fill out 'Field [T]'" + add;
            }
            if (this.mriIdPanel.design.getSelectedItem() == null) {
                return "Installation address: Please chose a 'Design'" + add;
            }
        } else {
            System.out.println("RemoteMonitoringSystemIdPanel.checkMandatoryIdFields(): unsupported type: " + this.product_type.getSelectedItem());
        }
        return null;
    }

    private JPanel createSystemIdentificationArea() {
        this.product_type.setEnabled(false);
        this.nmrIdPanel.setEnabled(false);
        this.mriIdPanel.setEnabled(false);
        this.ftmsIdPanel.setEnabled(false);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4));
        p.setLayout(new BoxLayout(p, 1));
        JPanel genericPanel = new JPanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.fill = 2;
        gc.weighty = 0.1;
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridx = 0;
        gc.gridy = 0;
        final JPanel specificPanel = new JPanel();
        final CardLayout specificLayout = new CardLayout();
        specificPanel.setLayout(specificLayout);
        p.add(genericPanel);
        gc.weighty = 1.0;
        gc.gridy = 1;
        gc.fill = 0;
        p.add(specificPanel);
        genericPanel.setBorder(BorderFactory.createTitledBorder("Generic"));
        GridLayout3 lgP = new GridLayout3(2, genericPanel);
        this.product_type.setSelectedItem((Object)ProductType.MRI);
        this.product_type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (RemoteMonitoringSystemIdPanel.this.product_type.getSelectedItem() == ProductType.NMR) {
                    specificLayout.show(specificPanel, ProductType.NMR.displayName);
                } else if (RemoteMonitoringSystemIdPanel.this.product_type.getSelectedItem() == ProductType.MRI) {
                    specificLayout.show(specificPanel, ProductType.MRI.displayName);
                } else {
                    specificLayout.show(specificPanel, ProductType.FTMS.displayName);
                }
            }
        });
        this.mriIdPanel.design.setSelectedItem(null);
        lgP.add(ID_PRODUCT_TYPE);
        lgP.add(this.product_type);
        lgP.fillSouth();
        specificPanel.add((Component)this.nmrIdPanel, ProductType.NMR.displayName);
        specificPanel.add((Component)this.mriIdPanel, ProductType.MRI.displayName);
        specificPanel.add((Component)this.ftmsIdPanel, ProductType.FTMS.displayName);
        specificLayout.show(specificPanel, ProductType.MRI.displayName);
        MonitoringIDXml xml = this.readID(false);
        if (xml != null) {
            MonitoringIDXmlMri mriIdXml = null;
            if (xml instanceof MonitoringIDXmlMri) {
                mriIdXml = (MonitoringIDXmlMri)xml;
            } else {
                System.out.println("Unsupported type in MonitoringIDXml: " + xml.product_type);
            }
            ProductType type = ProductType.getFromId(xml.product_type);
            this.product_type.setSelectedItem((Object)type);
            if (mriIdXml != null) {
                this.mriIdPanel.part_number.setText(mriIdXml.part_number);
                this.mriIdPanel.serial_number.setText(mriIdXml.serial_number);
                this.mriIdPanel.mri_rt_bore.setText(mriIdXml.rt_bore);
                this.mriIdPanel.prefix.setText(mriIdXml.prefix);
                this.mriIdPanel.field.setText(mriIdXml.field);
                MriDesign design = null;
                try {
                    design = MriDesign.getFromId(Integer.parseInt(mriIdXml.design));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                this.mriIdPanel.design.setSelectedItem((Object)design);
            }
        }
        return p;
    }

    private static void setTextLimitFilter(JComboBox combo, int charLimit) {
        Component editorComponent = combo.getEditor().getEditorComponent();
        Document document = ((JTextComponent)editorComponent).getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new DocumentSizeFilter(charLimit));
        }
    }

    private static String filterInput(String str) {
        return str.replace("\n", " ").replace("\r", "").replace("\t", " ").replace(";", " ").replace("  ", " ").trim();
    }

    private boolean writeID(MonitoringIDXml newIDXml) {
        boolean success = false;
        try {
            StringWriter writer = new StringWriter(200);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MonitoringIDXml.class, MonitoringIDXmlMri.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)newIDXml, (Writer)writer);
            JacCommon.JacValueType idXmlBytes = new JacCommon.JacValueType();
            idXmlBytes.ByteArrayVal(writer.toString().getBytes(RemoteMonitoringCustomerPanel.uft8));
            try {
                this.api.getConnection().pushParameters(this.api.getKey(), new JacCommon.JacProperty[]{new JacCommon.JacProperty("MMS_RM_ID_XML", idXmlBytes)});
                success = true;
            }
            catch (JacControl.JacParamNotAvailable jpna) {
                System.out.println("Parameter could not be pushed: MMS_RM_ID_XML; " + jpna.statement);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return success;
    }

    private MonitoringIDXml readID(boolean force) {
        if (this.monitoringIDXml == null || force) {
            try {
                JacControl.JacPropertyExt xmlParam = this.api.getConnection().getParameter("MMS_RM_ID_XML");
                if (xmlParam != null) {
                    byte[] arr = xmlParam.value.ByteArrayVal();
                    if (arr.length == 15 && new String(arr, RemoteMonitoringCustomerPanel.uft8).equals("not initialized")) {
                        this.monitoringIDXml = null;
                    } else {
                        try {
                            String xmlString = new String(arr, RemoteMonitoringCustomerPanel.uft8);
                            StringReader reader = new StringReader(xmlString);
                            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MonitoringIDXml.class, MonitoringIDXmlMri.class});
                            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                            this.monitoringIDXml = (MonitoringIDXml)unmarshaller.unmarshal((Reader)reader);
                        }
                        catch (JAXBException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
                jacParamNotAvailable.printStackTrace();
            }
        }
        return this.monitoringIDXml;
    }

    private IdTestResult writeIDTest(MonitoringIDXml newIDXml) {
        IdTestResult result;
        block9: {
            result = IdTestResult.NEW_ID;
            boolean success = false;
            try {
                StringWriter writer = new StringWriter(200);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MonitoringIDXml.class, MonitoringIDXmlMri.class});
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)newIDXml, (Writer)writer);
                JacCommon.JacValueType idXmlBytes = new JacCommon.JacValueType();
                idXmlBytes.ByteArrayVal(writer.toString().getBytes(RemoteMonitoringCustomerPanel.uft8));
                try {
                    this.api.getConnection().pushParameters(this.api.getKey(), new JacCommon.JacProperty[]{new JacCommon.JacProperty("MMS_RM_ID_TEST_XML", idXmlBytes)});
                    success = true;
                }
                catch (JacControl.JacParamNotAvailable jpna) {
                    result = IdTestResult.JAC_COM_ERROR;
                    System.out.println("Parameter could not be pushed: MMS_RM_ID_TEST_XML; " + jpna.statement);
                }
                if (!success) break block9;
                JacCommon.JacValueType idCmd = new JacCommon.JacValueType();
                idCmd.BooleanVal(true);
                try {
                    this.api.getConnection().pushParameters(this.api.getKey(), new JacCommon.JacProperty[]{new JacCommon.JacProperty("MMS_RM_TEST_ID", idCmd)});
                    result = IdTestResult.NEW_ID;
                }
                catch (JacControl.JacParamNotAvailable jpna) {
                    if (jpna.statement == null) {
                        result = IdTestResult.JAC_COM_ERROR;
                        break block9;
                    }
                    if (jpna.statement.startsWith(JacPublicDefinitions.ConfigurationError.JAC_DEF_PARAMETER_CURRENTLY_NOT_WRITEABLE.getMessage())) {
                        result = IdTestResult.ID_EXISTS;
                        break block9;
                    }
                    if (jpna.statement.startsWith(JacPublicDefinitions.ConfigurationError.JAC_DEF_PARAMETER_CMD_CURRENTLY_NOT_AVAILABLE.getMessage())) {
                        result = IdTestResult.SERVER_COM_ERROR;
                        break block9;
                    }
                    result = IdTestResult.JAC_COM_ERROR;
                }
            }
            catch (JAXBException e) {
                result = IdTestResult.XML_ERROR;
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isEditing() {
        return this.changeButton.isSelected();
    }

    public void callSaveAction() {
        this.changeButton.doClick();
    }

    class LimitedTextField
    extends JTextField {
        public LimitedTextField(int charLimit, int columns) {
            super(columns);
            if (this.getDocument() instanceof AbstractDocument) {
                ((AbstractDocument)this.getDocument()).setDocumentFilter(new DocumentSizeFilter(charLimit));
            }
        }
    }

    private class MirIdPanel
    extends JPanel {
        private final JTextField part_number;
        private final JTextField serial_number;
        private final JTextField mri_rt_bore;
        private final JTextField prefix;
        private final JTextField field;
        private final JComboBox design;

        public MirIdPanel() {
            this.part_number = new LimitedTextField(64, 15);
            this.serial_number = new LimitedTextField(64, 15);
            this.mri_rt_bore = new LimitedTextField(64, 15);
            this.prefix = new LimitedTextField(64, 15);
            this.field = new LimitedTextField(64, 15);
            this.design = GUIUtils.getTinyJComboBox((Object[])MriDesign.values());
            this.setBorder(BorderFactory.createTitledBorder("MRI"));
            GridLayout3 l1 = new GridLayout3(2, this);
            l1.add(GUIUtils.getTinyLabel("Part Number *"));
            l1.add(this.part_number);
            l1.add(GUIUtils.getTinyLabel("Serial Number *"));
            l1.add(this.serial_number);
            l1.add(GUIUtils.getTinyLabel("RT Bore [mm] *"));
            l1.add(this.mri_rt_bore);
            l1.add(GUIUtils.getTinyLabel("Prefix *"));
            l1.add(this.prefix);
            l1.add(GUIUtils.getTinyLabel("Field [T] *"));
            l1.add(this.field);
            l1.add(GUIUtils.getTinyLabel("Design *"));
            l1.add(this.design);
            l1.addSeparator();
            l1.insertLineBreakAfterNextComponent();
            l1.add(GUIUtils.getTinyLabel("* required fields"));
            l1.fillSouth();
        }

        @Override
        public void setEnabled(boolean enable) {
            this.part_number.setEnabled(enable);
            this.serial_number.setEnabled(enable);
            this.mri_rt_bore.setEnabled(enable);
            this.prefix.setEnabled(enable);
            this.field.setEnabled(enable);
            this.design.setEnabled(enable);
        }
    }

    private static enum IdTestResult {
        ID_EXISTS,
        NEW_ID,
        JAC_COM_ERROR,
        SERVER_COM_ERROR,
        XML_ERROR;

    }
}

