/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.mon;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.api.ApiTalker;
import ch.bruker.jac.servicegui.api.JacCommon;
import ch.bruker.jac.servicegui.api.JacControl;
import ch.bruker.jac.servicegui.img.Images;
import ch.bruker.jac.servicegui.status.mon.AddressType;
import ch.bruker.jac.servicegui.status.mon.CountryDef;
import ch.bruker.jac.servicegui.status.mon.DocumentSizeFilter;
import ch.bruker.jac.servicegui.status.mon.GUIUtils;
import ch.bruker.jac.servicegui.status.mon.GridLayout3;
import ch.bruker.jac.servicegui.status.mon.RemoteMonitoringSystemIdPanel;
import ch.bruker.mon.xml.Address;
import ch.bruker.mon.xml.Contact;
import ch.bruker.mon.xml.MonitoringCIXml;
import ch.bruker.util.BUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class RemoteMonitoringCustomerPanel
extends JPanel {
    private static final long serialVersionUID = -6948843710064055607L;
    public static final Charset uft8 = Charset.forName("UTF-8");
    private final String remoteMonitoringActiveParam = "MMS_REMOTE_MON_ENA";
    private final String ciParam = "MMS_RM_CI_XML";
    private MonitoringCIXml monitoringCIXml = null;
    private final JCheckBox enableRemoteMon;
    private final JToggleButton changeButton;
    private final JButton systemIdButton;
    private final JButton testButton;
    private final String testParam = "MMS_RM_TEST_CONN";
    private final JTextField address1_company_name = new LimitedTextField(64, 15);
    private final JTextField address1_room = new LimitedTextField(64, 15);
    private final JTextField address1_building = new LimitedTextField(64, 15);
    private final JTextField address1_street = new LimitedTextField(128, 15);
    private final JTextField address1_city = new LimitedTextField(64, 15);
    private final JTextField address1_state = new LimitedTextField(50, 6);
    private final JTextField address1_zip = new LimitedTextField(50, 6);
    private final JComboBox address1_country;
    private final JTextField address2_company_name = new LimitedTextField(64, 15);
    private final JTextField address2_room = new LimitedTextField(64, 15);
    private final JTextField address2_building = new LimitedTextField(64, 15);
    private final JTextField address2_street = new LimitedTextField(128, 15);
    private final JTextField address2_city = new LimitedTextField(64, 15);
    private final JTextField address2_state = new LimitedTextField(50, 6);
    private final JTextField address2_zip = new LimitedTextField(50, 6);
    private final JComboBox address2_country;
    private static final String ADDRESS_COMPANY_NAME = "Company name";
    private static final String ADDRESS_ROOM = "Room";
    private static final String ADDRESS_BUILDING = "Building";
    private static final String ADDRESS_STREET = "Street";
    private static final String ADDRESS_CITY = "City";
    private static final String ADDRESS_STATE = "State";
    private static final String ADDRESS_ZIP = "Zip";
    private static final String ADDRESS_COUNTRY = "Country";
    private static final String CONTACT_SALUTATION = "Salutation";
    private static final String CONTACT_OFFICE_PHONE = "Office phone";
    private static final String CONTACT_FIRSTNAME = "Firstname";
    private static final String CONTACT_MOBILE_PHONE = "Mobile phone";
    private static final String CONTACT_LASTNAME = "Lastname";
    private static final String CONTACT_HOME_PHONE = "Home phone";
    private static final String CONTACT_JOB_TITLE = "Job title";
    private static final String CONTACT_OTHER_PHONE = "Other phone";
    private static final String CONTACT_DEPARTMENT = "Department";
    private static final String CONTACT_EMAIL = "EMail";
    private static final String CONTACT_REPORTS_TO = "Reports to";
    private static final String CONTACT_EMAIL2 = "EMail2";
    private static final String CONTACT_DEPUTY = "Deputy";
    private static final String CONTACT_DESCRIPTION = "Description";
    private static final String CONTACT_EMAIL_OPT_OUT = "Email opt-out";
    private final JButton addContactBtn = GUIUtils.getTinyJButton("Add");
    private final List<ContactPanel> contacts = new ArrayList<ContactPanel>();
    private final JPanel contactListPanel = new JPanel();
    private final RemoteMonitoringSystemIdPanel remoteMonitoringSystemIdPanel;
    private final ApiTalker api;
    private final JacPublicDefinitions.UserLevel userLevel;
    private final Map<String, CountryDef> countryDefs;

    public RemoteMonitoringCustomerPanel(ApiTalker api, JacPublicDefinitions.UserLevel userLevel) {
        super(new BorderLayout());
        CountryDef[] countryList;
        this.api = api;
        this.userLevel = userLevel;
        this.countryDefs = RemoteMonitoringCustomerPanel.readCountryList();
        CountryDef[] countryDefArray = countryList = this.countryDefs != null ? this.countryDefs.values().toArray(new CountryDef[this.countryDefs.size()]) : null;
        if (countryList == null) {
            countryList = new CountryDef[]{};
            JOptionPane.showMessageDialog(this, "Error:\nCannot load country definitions", "Error", 0);
        }
        Arrays.sort(countryList);
        this.address1_country = new JComboBox<CountryDef>(countryList);
        this.address1_country.setEditable(true);
        RemoteMonitoringCustomerPanel.setTextLimitFilter(this.address1_country, 64);
        RemoteMonitoringCustomerPanel.addNearestCompletionForCombo(this.address1_country, countryList);
        this.address2_country = new JComboBox<CountryDef>(countryList);
        this.address2_country.setEditable(true);
        RemoteMonitoringCustomerPanel.setTextLimitFilter(this.address2_country, 64);
        RemoteMonitoringCustomerPanel.addNearestCompletionForCombo(this.address2_country, countryList);
        this.address1_country.setFont(this.address1_company_name.getFont());
        this.address2_country.setFont(this.address2_company_name.getFont());
        this.changeButton = new JToggleButton("Edit", new ImageIcon(Images.class.getResource("change.gif")));
        this.systemIdButton = new JButton("System Identification", new ImageIcon(Images.class.getResource("key.png")));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        boolean isRemoteMonActivated = this.getRemoteMonitoringActive();
        this.enableRemoteMon = new JCheckBox("Activate Remote Monitoring", isRemoteMonActivated);
        this.enableRemoteMon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RemoteMonitoringCustomerPanel.this.enableDisableWithConfirm(RemoteMonitoringCustomerPanel.this.enableRemoteMon.isSelected());
            }
        });
        this.testButton = new JButton("Test connection");
        this.remoteMonitoringSystemIdPanel = new RemoteMonitoringSystemIdPanel(api, userLevel);
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this.createMainPanel(), "Center");
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 400));
        String s = this.remoteMonitoringSystemIdPanel.checkMandatoryIdFields();
        if (s != null && this.userLevel == JacPublicDefinitions.UserLevel.USER) {
            throw new RuntimeException("Configuration of remote monitoring is not possible; Mandatory system information is missing.\n Please fill out the necessary fields in service mode.");
        }
    }

    public void checkIdComplete() {
        String s = this.remoteMonitoringSystemIdPanel.checkMandatoryIdFields();
        if (s != null && this.userLevel != JacPublicDefinitions.UserLevel.USER) {
            this.systemIdButton.doClick();
        }
    }

    public boolean isEditing() {
        return this.changeButton.isSelected();
    }

    public void callSaveAction() {
        this.changeButton.doClick();
    }

    private boolean checkForWarningsAndConfirm() {
        CountryDef country1 = this.getCountryDef(this.address1_country.getSelectedItem());
        return country1.un3Code.length() != 0 || JOptionPane.showConfirmDialog(this, "Please ensure that the English country name is entered\nand that it exists in the list.\n\nAre you sure you want to use this setting?", ADDRESS_COUNTRY, 2, -1) == 0;
    }

    private String checkMandatoryFields(boolean removeEmptyContacts) {
        if (removeEmptyContacts) {
            for (int i = this.contacts.size() - 1; i >= 0; --i) {
                ContactPanel cp = this.contacts.get(i);
                if (!cp.isEmpty()) continue;
                this.contacts.remove(i);
                this.contactListPanel.remove(cp);
                this.contactListPanel.updateUI();
            }
        }
        this.address1_company_name.setText(RemoteMonitoringCustomerPanel.filterInput(this.address1_company_name.getText()));
        this.address1_room.setText(RemoteMonitoringCustomerPanel.filterInput(this.address1_room.getText()));
        this.address1_building.setText(RemoteMonitoringCustomerPanel.filterInput(this.address1_building.getText()));
        this.address1_street.setText(RemoteMonitoringCustomerPanel.filterInput(this.address1_street.getText()));
        this.address1_city.setText(RemoteMonitoringCustomerPanel.filterInput(this.address1_city.getText()));
        this.address1_state.setText(RemoteMonitoringCustomerPanel.filterInput(this.address1_state.getText()));
        this.address1_zip.setText(RemoteMonitoringCustomerPanel.filterInput(this.address1_zip.getText()));
        this.address2_company_name.setText(RemoteMonitoringCustomerPanel.filterInput(this.address2_company_name.getText()));
        this.address2_room.setText(RemoteMonitoringCustomerPanel.filterInput(this.address2_room.getText()));
        this.address2_building.setText(RemoteMonitoringCustomerPanel.filterInput(this.address2_building.getText()));
        this.address2_street.setText(RemoteMonitoringCustomerPanel.filterInput(this.address2_street.getText()));
        this.address2_city.setText(RemoteMonitoringCustomerPanel.filterInput(this.address2_city.getText()));
        this.address2_state.setText(RemoteMonitoringCustomerPanel.filterInput(this.address2_state.getText()));
        this.address2_zip.setText(RemoteMonitoringCustomerPanel.filterInput(this.address2_zip.getText()));
        for (ContactPanel cp : this.contacts) {
            cp.contact_firstname.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_firstname.getText()));
            cp.contact_lastname.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_lastname.getText()));
            cp.contact_job_title.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_job_title.getText()));
            cp.contact_department.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_department.getText()));
            cp.contact_office_phone.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_office_phone.getText()));
            cp.contact_mobile_phone.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_mobile_phone.getText()));
            cp.contact_home_phone.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_home_phone.getText()));
            cp.contact_other_phone.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_other_phone.getText()));
            cp.contact_email.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_email.getText()));
            cp.contact_email2.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_email2.getText()));
            cp.contact_description.setText(RemoteMonitoringCustomerPanel.filterInput(cp.contact_description.getText()));
        }
        if (this.contacts.size() < 1) {
            return "Please define at least one contact";
        }
        if (this.address1_company_name.getText().trim().length() == 0) {
            return "Installation address: Please fill out 'Company name'";
        }
        if (this.address1_street.getText().trim().length() == 0) {
            return "Installation address: Please fill out 'Street'";
        }
        if (this.address1_city.getText().trim().length() == 0) {
            return "Installation address: Please fill out 'City'";
        }
        if (this.address1_zip.getText().trim().length() == 0) {
            return "Installation address: Please fill out 'Zip'";
        }
        if (("" + this.address1_country.getSelectedItem()).trim().length() == 0) {
            return "Installation address: Please fill out 'Country'";
        }
        boolean atLeastOneContactValid = false;
        for (ContactPanel cp : this.contacts) {
            if (!cp.mandatoryFieldsFilledOut()) continue;
            atLeastOneContactValid = true;
        }
        if (!atLeastOneContactValid) {
            return "At least one contact should provide the following fields:\n\nSalutation\nFirstname\nLastname\nJob title\none phone number\none email address\n";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enableDisableWithConfirm(boolean enable) {
        if (enable) {
            String checkMessage = this.checkMandatoryFields(false);
            if (checkMessage != null) {
                JOptionPane.showMessageDialog(this, checkMessage, "Missing Data", 1);
                this.enableRemoteMon.setSelected(false);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Bruker strongly recommends its activation. Active follow-up by Bruker\nmay require an agreement, please contact your local office for further\ninformation or visit www.bruker.com\n\nConfirm and activate this feature?", "BRUKER Remote Monitoring", 0, 3, null) == 0) {
                System.out.println("Remote-Monitoring switched on by user");
                this.sendRemoteMonitoringActive(true);
                return;
            }
            this.enableRemoteMon.setSelected(false);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Bruker strongly recommends you to keep this option activated. In case of\nquestions, please contact your local office for further information or visit\nwww.bruker.com\n\nDo you really want to disable the BRUKER Remote Monitoring feature?", "BRUKER Remote Monitoring", 0, 3, null) == 0) {
            System.out.println("Remote-Monitoring switched off by user");
            this.sendRemoteMonitoringActive(false);
            return;
        }
        this.enableRemoteMon.setSelected(true);
    }

    private JPanel createTopPanel() {
        JPanel topp = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)GUIUtils.createExplanationArea("It is highly recommended to activate remote monitoring.\nBruker shall receive only diagnostic data that are relevant for the system health and performance. Active follow-up by Bruker may require an agreement, please contact your local office for further information or visit www.bruker.com"), "Center");
        JPanel cbP = new JPanel();
        cbP.setLayout(new BoxLayout(cbP, 0));
        cbP.setBorder(BorderFactory.createEmptyBorder(6, 0, 12, 4));
        cbP.add(this.enableRemoteMon);
        cbP.add(Box.createHorizontalGlue());
        this.testButton.setMargin(new Insets(0, 0, 0, 0));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RemoteMonitoringCustomerPanel.this.testConnection(RemoteMonitoringCustomerPanel.this.testButton);
            }
        });
        cbP.add(Box.createHorizontalStrut(12));
        cbP.add(this.testButton);
        p.add((Component)cbP, "South");
        topp.add((Component)p, "Center");
        return topp;
    }

    private JPanel createMainPanel() {
        JPanel p = new JPanel(new BorderLayout());
        String info = this.userLevel == JacPublicDefinitions.UserLevel.USER ? "Customer Information" : "Customer Information/System Identification";
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(info), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        JTabbedPane contactPane = new JTabbedPane();
        contactPane.add("Address", this.createAddressArea());
        contactPane.add("Contacts", this.createContactsArea());
        contactPane.setIconAt(0, new ImageIcon(Images.class.getResource("letter.png")));
        contactPane.setIconAt(1, new ImageIcon(Images.class.getResource("contact.png")));
        p.add((Component)contactPane, "Center");
        p.add((Component)this.createBottomPanel(), "South");
        return p;
    }

    private JPanel createAddressArea() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 2));
        p.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4));
        this.address1_country.setSelectedItem("");
        this.address2_country.setSelectedItem("");
        this.address1_company_name.setMinimumSize(this.address1_company_name.getPreferredSize());
        this.address1_room.setMinimumSize(this.address1_room.getPreferredSize());
        this.address1_building.setMinimumSize(this.address1_building.getPreferredSize());
        this.address1_street.setMinimumSize(this.address1_street.getPreferredSize());
        this.address1_city.setMinimumSize(this.address1_city.getPreferredSize());
        this.address1_state.setMinimumSize(this.address1_state.getPreferredSize());
        this.address1_zip.setMinimumSize(this.address1_zip.getPreferredSize());
        this.address1_country.setMinimumSize(this.address1_country.getPreferredSize());
        this.address2_company_name.setMinimumSize(this.address2_company_name.getPreferredSize());
        this.address2_room.setMinimumSize(this.address2_room.getPreferredSize());
        this.address2_building.setMinimumSize(this.address2_building.getPreferredSize());
        this.address2_street.setMinimumSize(this.address2_street.getPreferredSize());
        this.address2_city.setMinimumSize(this.address2_city.getPreferredSize());
        this.address2_state.setMinimumSize(this.address2_state.getPreferredSize());
        this.address2_zip.setMinimumSize(this.address2_zip.getPreferredSize());
        this.address2_country.setMinimumSize(this.address2_country.getPreferredSize());
        this.address1_company_name.setEnabled(false);
        this.address1_room.setEnabled(false);
        this.address1_building.setEnabled(false);
        this.address1_street.setEnabled(false);
        this.address1_city.setEnabled(false);
        this.address1_state.setEnabled(false);
        this.address1_zip.setEnabled(false);
        this.address1_country.setEnabled(false);
        this.address2_company_name.setEnabled(false);
        this.address2_room.setEnabled(false);
        this.address2_building.setEnabled(false);
        this.address2_street.setEnabled(false);
        this.address2_city.setEnabled(false);
        this.address2_state.setEnabled(false);
        this.address2_zip.setEnabled(false);
        this.address2_country.setEnabled(false);
        JPanel a1 = new JPanel();
        a1.setBorder(BorderFactory.createTitledBorder(AddressType.INSTALLATION.displayName + " Address"));
        GridLayout3 l1 = new GridLayout3(2, a1);
        l1.add(GUIUtils.getTinyLabel("Company name *"));
        l1.add(this.address1_company_name);
        l1.add(GUIUtils.getTinyLabel(ADDRESS_ROOM));
        l1.add(this.address1_room);
        l1.add(GUIUtils.getTinyLabel(ADDRESS_BUILDING));
        l1.add(this.address1_building);
        l1.add(GUIUtils.getTinyLabel("Street *"));
        l1.add(this.address1_street);
        l1.add(GUIUtils.getTinyLabel("City *"));
        l1.add(this.address1_city);
        l1.add(GUIUtils.getTinyLabel(ADDRESS_STATE));
        l1.add(this.address1_state);
        l1.add(GUIUtils.getTinyLabel("Zip *"));
        l1.add(this.address1_zip);
        l1.add(GUIUtils.getTinyLabel("Country *"));
        l1.add(this.address1_country);
        l1.addSeparator();
        l1.insertLineBreakAfterNextComponent();
        l1.add(GUIUtils.getTinyLabel("* required fields"));
        JPanel a2 = new JPanel();
        a2.setBorder(BorderFactory.createTitledBorder(AddressType.OTHER.displayName + " Address"));
        GridLayout3 l2 = new GridLayout3(2, a2);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_COMPANY_NAME));
        l2.add(this.address2_company_name);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_ROOM));
        l2.add(this.address2_room);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_BUILDING));
        l2.add(this.address2_building);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_STREET));
        l2.add(this.address2_street);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_CITY));
        l2.add(this.address2_city);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_STATE));
        l2.add(this.address2_state);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_ZIP));
        l2.add(this.address2_zip);
        l2.add(GUIUtils.getTinyLabel(ADDRESS_COUNTRY));
        l2.add(this.address2_country);
        p.add(a1);
        p.add(a2);
        l1.fillSouth();
        l2.fillSouth();
        MonitoringCIXml xml = this.readCI(false);
        if (xml != null) {
            List<Address> addresses = xml.getAddresses();
            for (Address a3 : addresses) {
                String countryNameInConf;
                String countryCodeInConf;
                AddressType aType = AddressType.getFromId(a3.type);
                if (aType == AddressType.INSTALLATION) {
                    this.address1_company_name.setText(a3.company_name);
                    this.address1_room.setText(a3.room);
                    this.address1_building.setText(a3.building);
                    this.address1_street.setText(a3.street);
                    this.address1_city.setText(a3.city);
                    this.address1_state.setText(a3.state);
                    this.address1_zip.setText(a3.zip);
                    countryCodeInConf = a3.country_code;
                    countryNameInConf = a3.country_name;
                    CountryDef country1 = this.getCountryDef(countryCodeInConf, countryNameInConf);
                    this.address1_country.setSelectedItem(country1);
                    continue;
                }
                if (aType == AddressType.OTHER) {
                    this.address2_company_name.setText(a3.company_name);
                    this.address2_room.setText(a3.room);
                    this.address2_building.setText(a3.building);
                    this.address2_street.setText(a3.street);
                    this.address2_city.setText(a3.city);
                    this.address2_state.setText(a3.state);
                    this.address2_zip.setText(a3.zip);
                    countryCodeInConf = a3.country_code;
                    countryNameInConf = a3.country_name;
                    CountryDef country2 = this.getCountryDef(countryCodeInConf, countryNameInConf);
                    this.address2_country.setSelectedItem(country2);
                    continue;
                }
                System.out.println("unsupported address type in MonitoringCIXml: " + (Object)((Object)aType));
            }
        }
        return p;
    }

    private JPanel createContactsArea() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel addP = new JPanel();
        addP.setLayout(new BoxLayout(addP, 1));
        this.addContactBtn.setEnabled(false);
        this.addContactBtn.setToolTipText("add a new contact");
        this.addContactBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (ContactPanel contactPanel : RemoteMonitoringCustomerPanel.this.contacts) {
                }
                ContactPanel contactEntry = new ContactPanel(RemoteMonitoringCustomerPanel.this.contacts.size() + 1);
                contactEntry.setEnabled(true);
                RemoteMonitoringCustomerPanel.this.contacts.add(contactEntry);
                RemoteMonitoringCustomerPanel.this.contactListPanel.add(contactEntry);
                RemoteMonitoringCustomerPanel.this.contactListPanel.updateUI();
            }
        });
        addP.add(this.addContactBtn);
        p.add((Component)addP, "East");
        this.contactListPanel.setLayout(new BoxLayout(this.contactListPanel, 1));
        p.add((Component)new JScrollPane(this.contactListPanel, 22, 31), "Center");
        MonitoringCIXml xml = this.readCI(false);
        if (xml != null) {
            List<Contact> contacts = xml.getContacts();
            for (Contact c2 : contacts) {
                ContactPanel contactEntry = new ContactPanel(c2.contact_number);
                this.contacts.add(contactEntry);
                this.contactListPanel.add(contactEntry);
                contactEntry.contact_salutation.setSelectedItem(c2.salutation);
                contactEntry.contact_firstname.setText(c2.firstname);
                contactEntry.contact_lastname.setText(c2.lastname);
                contactEntry.contact_job_title.setText(c2.job_title);
                contactEntry.contact_department.setText(c2.department);
                contactEntry.contact_reports_to.setSelectedItem(c2.reports_to);
                contactEntry.contact_opt_out_marketing_emails.setSelected(c2.opt_out_marketing_emails);
                contactEntry.contact_office_phone.setText(c2.office_phone);
                contactEntry.contact_mobile_phone.setText(c2.mobile_phone);
                contactEntry.contact_home_phone.setText(c2.home_phone);
                contactEntry.contact_other_phone.setText(c2.other_phone);
                contactEntry.contact_email.setText(c2.email);
                contactEntry.contact_email2.setText(c2.email2);
                contactEntry.contact_deputy.setSelectedItem(c2.deputy);
                contactEntry.contact_description.setText(c2.description);
            }
        }
        this.contactListPanel.updateUI();
        return p;
    }

    private void showSystemIdFrame(Component parentComponent) {
        try {
            final JDialog f = new JDialog(SwingUtilities.windowForComponent(parentComponent), "BRUKER Remote Monitoring System Identification", Dialog.ModalityType.DOCUMENT_MODAL);
            f.setDefaultCloseOperation(0);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    if (RemoteMonitoringCustomerPanel.this.remoteMonitoringSystemIdPanel.isEditing() && JOptionPane.showConfirmDialog(f, "Do you want to save your changes?", "Save Settings", 0, 3, null) == 0) {
                        RemoteMonitoringCustomerPanel.this.remoteMonitoringSystemIdPanel.callSaveAction();
                        if (RemoteMonitoringCustomerPanel.this.remoteMonitoringSystemIdPanel.isEditing()) {
                            return;
                        }
                    }
                    f.setVisible(false);
                    f.dispose();
                }
            });
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)this.remoteMonitoringSystemIdPanel, "Center");
            f.setSize(800, 600);
            f.setLocationRelativeTo(SwingUtilities.windowForComponent(parentComponent));
            f.setVisible(true);
        }
        catch (RuntimeException e) {
            JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(parentComponent), e.getMessage(), "BRUKER Remote Monitoring System Identification", -1, 2, null);
        }
    }

    private JPanel createBottomPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.changeButton.setToolTipText("modify customer data for remote monitoring");
        this.changeButton.setMargin(new Insets(1, 1, 1, 1));
        GUIUtils.setButtonSizeFix(this.changeButton, this.changeButton.getPreferredSize().width + 20, this.changeButton.getPreferredSize().height);
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RemoteMonitoringCustomerPanel.this.changeButton.isSelected()) {
                    String s = null;
                    if (RemoteMonitoringCustomerPanel.this.userLevel != JacPublicDefinitions.UserLevel.USER) {
                        s = RemoteMonitoringCustomerPanel.this.remoteMonitoringSystemIdPanel.checkMandatoryIdFields();
                    }
                    if (s != null) {
                        RemoteMonitoringCustomerPanel.this.changeButton.setIcon(new ImageIcon(Images.class.getResource("change.gif")));
                        RemoteMonitoringCustomerPanel.this.changeButton.setText("Edit");
                        RemoteMonitoringCustomerPanel.this.changeButton.setSelected(false);
                        RemoteMonitoringCustomerPanel.this.showSystemIdFrame(RemoteMonitoringCustomerPanel.this);
                    } else {
                        RemoteMonitoringCustomerPanel.this.enableRemoteMon.setEnabled(false);
                        RemoteMonitoringCustomerPanel.this.testButton.setEnabled(false);
                        RemoteMonitoringCustomerPanel.this.address1_company_name.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address1_room.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address1_building.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address1_street.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address1_city.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address1_state.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address1_zip.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address1_country.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_company_name.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_room.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_building.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_street.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_city.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_state.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_zip.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.address2_country.setEnabled(true);
                        RemoteMonitoringCustomerPanel.this.addContactBtn.setEnabled(true);
                        for (ContactPanel cp : RemoteMonitoringCustomerPanel.this.contacts) {
                            cp.updateContactComboList(RemoteMonitoringCustomerPanel.this.contacts);
                            cp.setEnabled(true);
                        }
                        RemoteMonitoringCustomerPanel.this.changeButton.setIcon(new ImageIcon(Images.class.getResource("save_small.gif")));
                        RemoteMonitoringCustomerPanel.this.changeButton.setText("Save");
                    }
                } else {
                    String checkMessage = RemoteMonitoringCustomerPanel.this.checkMandatoryFields(true);
                    if (checkMessage != null) {
                        RemoteMonitoringCustomerPanel.this.changeButton.setSelected(true);
                        JOptionPane.showMessageDialog(RemoteMonitoringCustomerPanel.this, checkMessage, "Missing Data", 1);
                        return;
                    }
                    if (!RemoteMonitoringCustomerPanel.this.checkForWarningsAndConfirm()) {
                        RemoteMonitoringCustomerPanel.this.changeButton.setSelected(true);
                        return;
                    }
                    try {
                        RemoteMonitoringCustomerPanel.this.saveBack(false);
                    }
                    catch (IOException ioex) {
                        System.out.println(ioex.getMessage());
                        RemoteMonitoringCustomerPanel.this.changeButton.setSelected(true);
                        JOptionPane.showMessageDialog(RemoteMonitoringCustomerPanel.this, "Error saving data:\n" + ioex.getMessage(), "Error", 0);
                        return;
                    }
                    RemoteMonitoringCustomerPanel.this.enableRemoteMon.setEnabled(true);
                    RemoteMonitoringCustomerPanel.this.testButton.setEnabled(true);
                    RemoteMonitoringCustomerPanel.this.address1_company_name.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address1_room.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address1_building.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address1_street.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address1_city.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address1_state.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address1_zip.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address1_country.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_company_name.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_room.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_building.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_street.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_city.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_state.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_zip.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.address2_country.setEnabled(false);
                    RemoteMonitoringCustomerPanel.this.addContactBtn.setEnabled(false);
                    for (ContactPanel cp : RemoteMonitoringCustomerPanel.this.contacts) {
                        cp.setEnabled(false);
                    }
                    RemoteMonitoringCustomerPanel.this.changeButton.setIcon(new ImageIcon(Images.class.getResource("change.gif")));
                    RemoteMonitoringCustomerPanel.this.changeButton.setText("Edit");
                }
            }
        });
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.5;
        c2.anchor = 17;
        p.add((Component)this.changeButton, c2);
        c2.gridx = 1;
        c2.weightx = 1.0;
        p.add((Component)new JLabel(), c2);
        if (this.userLevel != JacPublicDefinitions.UserLevel.USER) {
            this.systemIdButton.setToolTipText("modify system identification data for remote monitoring");
            this.systemIdButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoteMonitoringCustomerPanel.this.showSystemIdFrame(RemoteMonitoringCustomerPanel.this);
                }
            });
            c2.weightx = 0.0;
            c2.gridx = 2;
            c2.anchor = 13;
            p.add((Component)this.systemIdButton, c2);
        }
        return p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveBack(boolean forceSend) throws IOException {
        boolean sendCI;
        ArrayList<Address> newAddresses = new ArrayList<Address>(2);
        CountryDef country1 = this.getCountryDef(this.address1_country.getSelectedItem());
        Address address1 = new Address(1, Address.CIType.INSTALLATION, this.address1_company_name.getText(), this.address1_room.getText(), this.address1_building.getText(), this.address1_street.getText(), this.address1_city.getText(), this.address1_state.getText(), this.address1_zip.getText(), country1.enShortName, country1.un3Code);
        this.address1_country.setSelectedItem(country1);
        newAddresses.add(address1);
        if (this.hasOptionalAddress2Defined()) {
            CountryDef country2 = this.getCountryDef(this.address2_country.getSelectedItem());
            Address address2 = new Address(2, Address.CIType.OTHER, this.address2_company_name.getText(), this.address2_room.getText(), this.address2_building.getText(), this.address2_street.getText(), this.address2_city.getText(), this.address2_state.getText(), this.address2_zip.getText(), country2.enShortName, country2.un3Code);
            this.address2_country.setSelectedItem(country2);
            newAddresses.add(address2);
        }
        ArrayList<Contact> newContacts = new ArrayList<Contact>(1);
        for (int i = 1; i <= this.contacts.size(); ++i) {
            Contact contact = new Contact(i, (String)this.contacts.get(i - 1).contact_salutation.getSelectedItem(), this.contacts.get(i - 1).contact_firstname.getText(), this.contacts.get(i - 1).contact_lastname.getText(), this.contacts.get(i - 1).contact_job_title.getText(), this.contacts.get(i - 1).contact_department.getText(), (String)this.contacts.get(i - 1).contact_reports_to.getSelectedItem(), (String)this.contacts.get(i - 1).contact_deputy.getSelectedItem(), this.contacts.get(i - 1).contact_opt_out_marketing_emails.isSelected(), this.contacts.get(i - 1).contact_office_phone.getText(), this.contacts.get(i - 1).contact_mobile_phone.getText(), this.contacts.get(i - 1).contact_home_phone.getText(), this.contacts.get(i - 1).contact_other_phone.getText(), this.contacts.get(i - 1).contact_email.getText(), this.contacts.get(i - 1).contact_email2.getText(), this.contacts.get(i - 1).contact_description.getText());
            newContacts.add(contact);
        }
        MonitoringCIXml newCIXml = new MonitoringCIXml(1, newAddresses, newContacts);
        boolean bl = sendCI = newCIXml != null && (this.monitoringCIXml == null || !this.monitoringCIXml.equals(newCIXml));
        if (forceSend || sendCI) {
            System.out.println("RemoteMonitoringCustomerPanel: Writing customer info to JAC");
            if (!this.writeCI(newCIXml)) throw new IOException("Failed to send customer information to JAC.");
            this.readCI(true);
            return;
        } else {
            System.out.println("RemoteMonitoringCustomerPanel, Save Customer Information: No changes");
        }
    }

    void testConnection(Component parentComponent) {
        System.out.println("Testing remote monitoring conncetion");
        this.writeTest(parentComponent);
    }

    private boolean hasOptionalAddress2Defined() {
        if (this.address2_company_name.getText().trim().length() > 0) {
            return true;
        }
        if (this.address2_room.getText().trim().length() > 0) {
            return true;
        }
        if (this.address2_building.getText().trim().length() > 0) {
            return true;
        }
        if (this.address2_street.getText().trim().length() > 0) {
            return true;
        }
        if (this.address2_city.getText().trim().length() > 0) {
            return true;
        }
        if (this.address2_state.getText().trim().length() > 0) {
            return true;
        }
        if (this.address2_zip.getText().trim().length() > 0) {
            return true;
        }
        return ("" + this.address2_country.getSelectedItem()).trim().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, CountryDef> readCountryList() {
        TreeMap<String, CountryDef> treeMap;
        TreeMap<String, CountryDef> result = new TreeMap<String, CountryDef>();
        InputStream inputStream = null;
        InputStreamReader streamReader = null;
        try {
            inputStream = RemoteMonitoringCustomerPanel.class.getResourceAsStream("countries.dat");
            streamReader = new InputStreamReader(inputStream, uft8);
            List<String> lines = RemoteMonitoringCustomerPanel.getTextFileContentLines(streamReader);
            for (String l : lines) {
                String un3Code;
                String[] parts;
                if ((l = l.trim()).length() == 0 || l.startsWith("#") || (parts = l.split("\\t")).length != 2 || (un3Code = parts[0].trim()).length() != 3) continue;
                String enShortName = parts[1].trim();
                result.put(un3Code, new CountryDef(un3Code, enShortName));
            }
            if (result.size() == 0) {
                throw new IOException("no entries found");
            }
            treeMap = result;
        }
        catch (Exception e) {
            Map<String, CountryDef> map;
            try {
                System.out.println("Cannot read country file ch/bruker/jac/servicegui/status/mon/coutries.dat: " + e.getMessage());
                e.printStackTrace();
                map = null;
            }
            catch (Throwable throwable) {
                BUtil.closeIgnoringExceptions(streamReader);
                BUtil.closeIgnoringExceptions(inputStream);
                throw throwable;
            }
            BUtil.closeIgnoringExceptions(streamReader);
            BUtil.closeIgnoringExceptions(inputStream);
            return map;
        }
        BUtil.closeIgnoringExceptions(streamReader);
        BUtil.closeIgnoringExceptions(inputStream);
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTextFileContentLines(InputStreamReader in) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(in);
            String line = null;
            while ((line = lnr.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Throwable throwable) {
            BUtil.closeIgnoringExceptions(lnr);
            throw throwable;
        }
        BUtil.closeIgnoringExceptions(lnr);
        return result;
    }

    public CountryDef getCountryDef(String countryCode, String countryName) {
        if (countryCode.trim().length() > 0) {
            CountryDef cInList = this.countryDefs.get(countryCode.toUpperCase().trim());
            if (cInList != null) {
                return cInList;
            }
        } else if (countryName.trim().length() > 0) {
            for (CountryDef cd : this.countryDefs.values()) {
                if (!cd.enShortName.equalsIgnoreCase(countryName.trim())) continue;
                return cd;
            }
        }
        return new CountryDef("", countryName.trim());
    }

    public CountryDef getCountryDef(Object entryFromComboBox) {
        if (entryFromComboBox instanceof CountryDef) {
            return (CountryDef)entryFromComboBox;
        }
        String countryCode = "";
        String countryName = ("" + entryFromComboBox).trim();
        return this.getCountryDef("", countryName);
    }

    private static void setTextLimitFilter(JComboBox combo, int charLimit) {
        Component editorComponent = combo.getEditor().getEditorComponent();
        Document document = ((JTextComponent)editorComponent).getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new DocumentSizeFilter(charLimit));
        }
    }

    private static String filterInput(String str) {
        return str.replace("\n", " ").replace("\r", "").replace("\t", " ").replace(";", " ").replace("  ", " ").trim();
    }

    private static void addNearestCompletionForCombo(final JComboBox combo, final CountryDef[] countryList) {
        if (combo.isEditable()) {
            final JTextComponent ed = (JTextComponent)combo.getEditor().getEditorComponent();
            ed.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 8 || e.getKeyCode() == 32 || e.getKeyCode() == 27 || e.getKeyCode() == 127) {
                        ed.setEditable(true);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    super.keyTyped(e);
                    if (Character.isLetter(e.getKeyChar())) {
                        String typed = (ed.getText().trim() + e.getKeyChar()).toLowerCase();
                        CountryDef match = null;
                        int matchCnt = 0;
                        for (CountryDef cd : countryList) {
                            if (!cd.enShortName.toLowerCase().startsWith(typed)) continue;
                            match = cd;
                            ++matchCnt;
                        }
                        if (matchCnt == 1) {
                            final CountryDef match2 = match;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ed.setEditable(false);
                                    ed.setText(match2.enShortName);
                                    combo.setSelectedItem(match2);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private boolean getRemoteMonitoringActive() {
        boolean active = false;
        try {
            JacControl.JacPropertyExt param = this.api.getConnection().getParameter(this.remoteMonitoringActiveParam);
            if (param != null) {
                active = param.value.BooleanVal();
            }
        }
        catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
            jacParamNotAvailable.printStackTrace();
        }
        return active;
    }

    private void sendRemoteMonitoringActive(boolean active) {
        JacCommon.JacValueType activeType = new JacCommon.JacValueType();
        activeType.BooleanVal(active);
        try {
            this.api.getConnection().pushParameters(this.api.getKey(), new JacCommon.JacProperty[]{new JacCommon.JacProperty("MMS_REMOTE_MON_ENA", activeType)});
        }
        catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
            JOptionPane.showMessageDialog(this, "Error:\nCannot send remote monitoring activation to JAC", "Error", 0);
        }
    }

    private boolean writeCI(MonitoringCIXml newCIXml) {
        boolean success = false;
        try {
            StringWriter writer = new StringWriter(200);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MonitoringCIXml.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)newCIXml, (Writer)writer);
            JacCommon.JacValueType ciXmlBytes = new JacCommon.JacValueType();
            ciXmlBytes.ByteArrayVal(writer.toString().getBytes(uft8));
            try {
                this.api.getConnection().pushParameters(this.api.getKey(), new JacCommon.JacProperty[]{new JacCommon.JacProperty("MMS_RM_CI_XML", ciXmlBytes)});
                success = true;
            }
            catch (JacControl.JacParamNotAvailable jpna) {
                System.out.println("Parameter could not be pushed: MMS_RM_CI_XML; " + jpna.statement);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return success;
    }

    private MonitoringCIXml readCI(boolean force) {
        if (this.monitoringCIXml == null || force) {
            try {
                JacControl.JacPropertyExt xmlParam = this.api.getConnection().getParameter("MMS_RM_CI_XML");
                if (xmlParam != null) {
                    byte[] arr = xmlParam.value.ByteArrayVal();
                    if (arr.length == 15 && new String(arr, uft8).equals("not initialized")) {
                        this.monitoringCIXml = null;
                    } else {
                        try {
                            String xmlString = new String(arr, uft8);
                            StringReader reader = new StringReader(xmlString);
                            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MonitoringCIXml.class});
                            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                            this.monitoringCIXml = (MonitoringCIXml)unmarshaller.unmarshal((Reader)reader);
                        }
                        catch (JAXBException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
                jacParamNotAvailable.printStackTrace();
            }
        }
        return this.monitoringCIXml;
    }

    private boolean writeTest(Component parentComponent) {
        boolean success = false;
        JacCommon.JacValueType jacValueType = new JacCommon.JacValueType();
        jacValueType.BooleanVal(true);
        JacCommon.JacProperty jacProperty = new JacCommon.JacProperty("MMS_RM_TEST_CONN", jacValueType);
        boolean testPossible = false;
        try {
            testPossible = this.testPossible();
            if (testPossible) {
                try {
                    this.api.getConnection().pushParameters(this.api.getKey(), new JacCommon.JacProperty[]{jacProperty});
                    success = true;
                }
                catch (JacControl.JacParamNotAvailable jpna) {
                    success = false;
                }
            }
            if (testPossible) {
                if (success) {
                    JOptionPane.showMessageDialog(parentComponent, "Transmission to the monitoring server completed.", "Transfer Succeeded", 1);
                } else {
                    JOptionPane.showMessageDialog(parentComponent, "Transmission to the monitoring server failed.", "Transfer Failed", 0);
                }
            } else {
                JOptionPane.showMessageDialog(parentComponent, "Transmission to the monitoring server not possible.\nNeither WAN remote monitoring nor modem option is enabled.", "Transfer not possible", 1);
            }
        }
        catch (JacControl.JacParamNotAvailable jacParamNotAvailable) {
            jacParamNotAvailable.printStackTrace();
            System.out.println("Parameter could not be pushed / test failed: MMS_RM_TEST_CONN; " + jacParamNotAvailable.statement);
        }
        return success;
    }

    private boolean testPossible() throws JacControl.JacParamNotAvailable {
        JacControl.JacPropertyExt[] xmlParam = this.api.getConnection().getParameters(new String[]{"MMS_REMOTE_MON_ENA_WAN", "MMS_MODEM_OPTION"});
        if (xmlParam != null && xmlParam.length == 2) {
            return xmlParam[0].value.BooleanVal() || xmlParam[1].value.BooleanVal();
        }
        return false;
    }

    class LimitedTextField
    extends JTextField {
        public LimitedTextField(int charLimit, int columns) {
            super(columns);
            if (this.getDocument() instanceof AbstractDocument) {
                ((AbstractDocument)this.getDocument()).setDocumentFilter(new DocumentSizeFilter(charLimit));
            }
        }
    }

    private class ContactPanel
    extends JPanel {
        private final JComboBox contact_salutation;
        private final JTextField contact_firstname;
        private final JTextField contact_lastname;
        private final JTextField contact_job_title;
        private final JTextField contact_department;
        private final JComboBox contact_reports_to;
        private final JComboBox contact_deputy;
        private final JCheckBox contact_opt_out_marketing_emails;
        private final JTextField contact_office_phone;
        private final JTextField contact_mobile_phone;
        private final JTextField contact_home_phone;
        private final JTextField contact_other_phone;
        private final JTextField contact_email;
        private final JTextField contact_email2;
        private final JTextField contact_description;
        private final JButton removeContactBtn;

        public ContactPanel(int n) {
            super(new BorderLayout());
            this.contact_salutation = GUIUtils.getTinyJComboBox(new String[]{"", "Mr", "Mrs", "Ms"});
            this.contact_firstname = new LimitedTextField(64, 15);
            this.contact_lastname = new LimitedTextField(64, 15);
            this.contact_job_title = new LimitedTextField(64, 15);
            this.contact_department = new LimitedTextField(64, 15);
            this.contact_reports_to = GUIUtils.getTinyJComboBox(new String[]{""});
            this.contact_deputy = GUIUtils.getTinyJComboBox(new String[]{""});
            this.contact_opt_out_marketing_emails = GUIUtils.getTinyJCheckBox("(Product Marketing)");
            this.contact_office_phone = new LimitedTextField(64, 12);
            this.contact_mobile_phone = new LimitedTextField(64, 12);
            this.contact_home_phone = new LimitedTextField(64, 12);
            this.contact_other_phone = new LimitedTextField(64, 12);
            this.contact_email = new LimitedTextField(128, 20);
            this.contact_email2 = new LimitedTextField(128, 20);
            this.contact_description = new LimitedTextField(256, 20);
            this.removeContactBtn = GUIUtils.createSquareButton("", new ImageIcon(Images.class.getResource("close.gif")));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder("#" + n)));
            JPanel addP = new JPanel();
            addP.setLayout(new BoxLayout(addP, 1));
            this.contact_salutation.setEditable(true);
            this.contact_reports_to.setEditable(true);
            this.contact_deputy.setEditable(true);
            RemoteMonitoringCustomerPanel.setTextLimitFilter(this.contact_salutation, 50);
            RemoteMonitoringCustomerPanel.setTextLimitFilter(this.contact_reports_to, 128);
            RemoteMonitoringCustomerPanel.setTextLimitFilter(this.contact_deputy, 128);
            this.contact_reports_to.setPreferredSize(this.contact_firstname.getPreferredSize());
            this.contact_deputy.setPreferredSize(this.contact_firstname.getPreferredSize());
            JPanel a1 = new JPanel();
            final List<JComponent> focusList = Arrays.asList((JComponent)this.contact_salutation.getEditor().getEditorComponent(), this.contact_firstname, this.contact_lastname, this.contact_job_title, this.contact_department, (JComponent)this.contact_reports_to.getEditor().getEditorComponent(), (JComponent)this.contact_deputy.getEditor().getEditorComponent(), this.contact_opt_out_marketing_emails, this.contact_office_phone, this.contact_mobile_phone, this.contact_home_phone, this.contact_other_phone, this.contact_email, this.contact_email2, this.contact_description);
            a1.setFocusCycleRoot(true);
            a1.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getLastComponent(Container aContainer) {
                    return (Component)focusList.get(focusList.size() - 1);
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return (Component)focusList.get(0);
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return (Component)focusList.get(0);
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    int p = focusList.indexOf(aComponent);
                    if (p < 0) {
                        return null;
                    }
                    if (p == 0) {
                        return this.getLastComponent(aContainer);
                    }
                    return (Component)focusList.get(p - 1);
                }

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    int p = focusList.indexOf(aComponent);
                    if (p < 0) {
                        return null;
                    }
                    if (p >= focusList.size() - 1) {
                        return this.getFirstComponent(aContainer);
                    }
                    return (Component)focusList.get(p + 1);
                }
            });
            GridLayout3 l1 = new GridLayout3(4, a1);
            l1.add(GUIUtils.getTinyLabel("Salutation *"));
            l1.add(this.contact_salutation);
            l1.add(GUIUtils.getTinyLabel("Office phone **"));
            l1.add(this.contact_office_phone);
            l1.add(GUIUtils.getTinyLabel("Firstname *"));
            l1.add(this.contact_firstname);
            l1.add(GUIUtils.getTinyLabel("Mobile phone **"));
            l1.add(this.contact_mobile_phone);
            l1.add(GUIUtils.getTinyLabel("Lastname *"));
            l1.add(this.contact_lastname);
            l1.add(GUIUtils.getTinyLabel("Home phone **"));
            l1.add(this.contact_home_phone);
            l1.add(GUIUtils.getTinyLabel("Job title *"));
            l1.add(this.contact_job_title);
            l1.add(GUIUtils.getTinyLabel("Other phone **"));
            l1.add(this.contact_other_phone);
            l1.add(GUIUtils.getTinyLabel(RemoteMonitoringCustomerPanel.CONTACT_DEPARTMENT));
            l1.add(this.contact_department);
            l1.add(GUIUtils.getTinyLabel("EMail *"));
            l1.add(this.contact_email);
            l1.add(GUIUtils.getTinyLabel(RemoteMonitoringCustomerPanel.CONTACT_REPORTS_TO));
            l1.add(this.contact_reports_to);
            l1.add(GUIUtils.getTinyLabel(RemoteMonitoringCustomerPanel.CONTACT_EMAIL2));
            l1.add(this.contact_email2);
            l1.add(GUIUtils.getTinyLabel(RemoteMonitoringCustomerPanel.CONTACT_DEPUTY));
            l1.add(this.contact_deputy);
            l1.add(GUIUtils.getTinyLabel(RemoteMonitoringCustomerPanel.CONTACT_DESCRIPTION));
            l1.add(this.contact_description);
            l1.add(GUIUtils.getTinyLabel(RemoteMonitoringCustomerPanel.CONTACT_EMAIL_OPT_OUT));
            l1.insertLineBreakAfterNextComponent();
            l1.add(this.contact_opt_out_marketing_emails);
            l1.addSeparator(5);
            l1.insertLineBreakAfterNextComponent();
            l1.add(GUIUtils.getTinyLabel("* required fields"));
            l1.insertLineBreakAfterNextComponent();
            l1.add(GUIUtils.getTinyLabel("** at least one phone number required"));
            l1.fillSouth();
            this.setEnabled(false);
            this.add((Component)a1, "Center");
            this.removeContactBtn.setToolTipText("remove this contact");
            this.removeContactBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (JOptionPane.showConfirmDialog(ContactPanel.this.removeContactBtn, "Do you want to remove this contact?", "Remove Contact", 0, 3, new ImageIcon(Images.class.getResource("close.gif"))) == 0) {
                        RemoteMonitoringCustomerPanel.this.contacts.remove(ContactPanel.this);
                        RemoteMonitoringCustomerPanel.this.contactListPanel.remove(ContactPanel.this);
                        RemoteMonitoringCustomerPanel.this.contactListPanel.updateUI();
                    }
                }
            });
            addP.add(this.removeContactBtn);
            this.add((Component)addP, "East");
        }

        void updateContactComboList(List<ContactPanel> allContacts) {
            ArrayList<String> fullPersonsName = new ArrayList<String>();
            fullPersonsName.add("");
            for (ContactPanel cp : allContacts) {
                if (cp == this) continue;
                fullPersonsName.add(cp.getFullPersonName());
            }
            this.contact_deputy.setModel(new DefaultComboBoxModel<String>(fullPersonsName.toArray(new String[fullPersonsName.size()])));
            this.contact_reports_to.setModel(new DefaultComboBoxModel<String>(fullPersonsName.toArray(new String[fullPersonsName.size()])));
        }

        private String getFullPersonName() {
            String saluation = (String)this.contact_salutation.getSelectedItem();
            String firstname = this.contact_firstname.getText();
            String lastname = this.contact_lastname.getText();
            return saluation + " " + firstname + " " + lastname;
        }

        @Override
        public void setEnabled(boolean enable) {
            this.removeContactBtn.setEnabled(enable);
            this.contact_salutation.setEnabled(enable);
            this.contact_firstname.setEnabled(enable);
            this.contact_lastname.setEnabled(enable);
            this.contact_job_title.setEnabled(enable);
            this.contact_department.setEnabled(enable);
            this.contact_reports_to.setEnabled(enable);
            this.contact_deputy.setEnabled(enable);
            this.contact_opt_out_marketing_emails.setEnabled(enable);
            this.contact_office_phone.setEnabled(enable);
            this.contact_mobile_phone.setEnabled(enable);
            this.contact_home_phone.setEnabled(enable);
            this.contact_other_phone.setEnabled(enable);
            this.contact_email.setEnabled(enable);
            this.contact_email2.setEnabled(enable);
            this.contact_description.setEnabled(enable);
        }

        private boolean isEmpty() {
            if (this.contact_firstname.getText().trim().length() > 0) {
                return false;
            }
            if (this.contact_lastname.getText().trim().length() > 0) {
                return false;
            }
            if (this.contact_office_phone.getText().trim().length() > 0) {
                return false;
            }
            if (this.contact_mobile_phone.getText().trim().length() > 0) {
                return false;
            }
            if (this.contact_home_phone.getText().trim().length() > 0) {
                return false;
            }
            if (this.contact_other_phone.getText().trim().length() > 0) {
                return false;
            }
            if (this.contact_email.getText().trim().length() > 0) {
                return false;
            }
            return this.contact_email2.getText().trim().length() <= 0;
        }

        private boolean mandatoryFieldsFilledOut() {
            if (this.contact_salutation.getSelectedItem().toString().trim().length() == 0) {
                return false;
            }
            if (this.contact_firstname.getText().trim().length() == 0) {
                return false;
            }
            if (this.contact_lastname.getText().trim().length() == 0) {
                return false;
            }
            if (this.contact_job_title.getText().trim().length() == 0) {
                return false;
            }
            boolean isOnePhoneDefined = false;
            if (this.contact_office_phone.getText().trim().length() > 0) {
                isOnePhoneDefined = true;
            }
            if (this.contact_mobile_phone.getText().trim().length() > 0) {
                isOnePhoneDefined = true;
            }
            if (this.contact_home_phone.getText().trim().length() > 0) {
                isOnePhoneDefined = true;
            }
            if (this.contact_other_phone.getText().trim().length() > 0) {
                isOnePhoneDefined = true;
            }
            if (!isOnePhoneDefined) {
                return false;
            }
            boolean isOneEMailDefined = false;
            if (this.contact_email.getText().trim().length() > 0) {
                isOneEMailDefined = true;
            }
            if (this.contact_email2.getText().trim().length() > 0) {
                isOneEMailDefined = true;
            }
            return isOneEMailDefined;
        }
    }
}

