/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.mon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class GridLayout3
extends GridBagLayout {
    int cols;
    JPanel target;
    public final GridBagConstraints constr = new GridBagConstraints();
    final Map<Integer, Integer> columnAligmnents = new Hashtable<Integer, Integer>();
    private int actualCol = 0;
    private double[] weights = null;
    boolean enforceLineBreakAfter = false;

    public GridLayout3(int cols, JPanel target) {
        this.cols = cols;
        this.target = target;
        this.constr.gridwidth = 1;
        this.constr.anchor = 17;
        this.constr.insets = new Insets(1, 5, 1, 1);
        target.setLayout(this);
    }

    public void setColumnAlignment(int col, int alignment) {
        this.columnAligmnents.put(new Integer(col), new Integer(alignment));
    }

    public JTextPane addExplanationArea(String expl) {
        JTextPane tp = new JTextPane();
        tp.setAlignmentX(0.0f);
        tp.setEditable(false);
        tp.setText(expl);
        tp.setBackground(this.target.getBackground());
        this.constr.gridwidth = 0;
        this.constr.fill = 2;
        this.setConstraints(tp, this.constr);
        this.target.add(tp);
        this.actualCol = 0;
        return tp;
    }

    public void setColumnWeights(double[] w) {
        this.weights = w;
    }

    public void add(String a2) {
        this.add(a2, null);
    }

    public void add(String a2, Font font) {
        JLabel l = new JLabel(a2);
        if (font != null) {
            l.setFont(font);
        }
        this.add(l, false);
    }

    public void add(Component comp) {
        this.add(comp, false);
    }

    public void addAsLastOfLine(Component comp) {
        this.insertLineBreakAfterNextComponent();
        this.add(comp, false);
    }

    public void addTitleSeparator(String title) {
        this.addTitleSeparator(title, 0);
    }

    public void addTitleSeparator(String title, int TitledBorderjustification) {
        this.addTitleSeparator(title, UIManager.getColor("TitledBorder.titleColor"), TitledBorderjustification, 0, UIManager.getFont("Label.font").getSize(), 0);
    }

    public void addTitleSeparator(String title, Color lineColor, int TitledBorderjustification, int TitledBorderposition, int spaceAbove, int spaceBelow) {
        this.constr.gridwidth = 0;
        this.constr.fill = 2;
        JPanel pan = new JPanel(new BorderLayout(0, 0));
        pan.setOpaque(false);
        pan.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(spaceAbove, 0, spaceBelow, 0), BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, lineColor), title, TitledBorderjustification, TitledBorderposition)));
        this.setConstraints(pan, this.constr);
        this.target.add(pan);
        this.actualCol = 0;
    }

    public void addSeparator() {
        this.addSeparator(6);
    }

    public void addSeparator(int h) {
        this.constr.gridwidth = 0;
        this.constr.fill = 2;
        JPanel pan = new JPanel(new BorderLayout(0, 0));
        pan.setOpaque(false);
        pan.setBorder(BorderFactory.createEmptyBorder(h, h, h, h));
        this.setConstraints(pan, this.constr);
        this.target.add(pan);
        this.actualCol = 0;
    }

    public void add(Component comp, boolean fillHorizontally) {
        int n = this.constr.fill = fillHorizontally ? 2 : 0;
        this.constr.gridwidth = this.actualCol % this.cols == this.cols - 1 ? 0 : (this.enforceLineBreakAfter ? 0 : 1);
        this.constr.anchor = this.columnAligmnents.containsKey(this.actualCol) ? this.columnAligmnents.get(this.actualCol) : 17;
        this.constr.weightx = this.weights != null && this.actualCol < this.weights.length ? this.weights[this.actualCol] : (this.actualCol == 0 ? 0.0 : 1000.0);
        this.setConstraints(comp, this.constr);
        this.target.add(comp);
        ++this.actualCol;
        if (this.actualCol == this.cols) {
            this.actualCol = 0;
        }
        if (this.enforceLineBreakAfter) {
            this.enforceLineBreakAfter = false;
            this.actualCol = 0;
        }
    }

    public void insertLineBreakAfterNextComponent() {
        this.enforceLineBreakAfter = true;
    }

    public static void usageDemoTest1() {
        JPanel panel = new JPanel();
        GridLayout3 gl = new GridLayout3(3, panel);
        gl.setColumnAlignment(0, 13);
        gl.setColumnWeights(new double[]{0.0, 1000.0, 0.0});
        JFrame jf = new JFrame("test");
        jf.setDefaultCloseOperation(3);
        jf.setContentPane(panel);
        gl.add("a");
        gl.add(new JTextField(8), false);
        gl.add(new JLabel("mm"), false);
        gl.add("b");
        gl.add(new JTextField(6), false);
        gl.add(new JLabel("cm"), false);
        gl.addTitleSeparator("Hello");
        gl.add("Hello");
        gl.add(new JTextField(), false);
        gl.add(new JLabel("km"), false);
        gl.addTitleSeparator("Hello", Color.yellow, 2, 1, 100, 50);
        jf.pack();
        jf.setLocationRelativeTo(null);
        jf.setVisible(true);
    }

    public static void test2() {
        JFrame frame = new JFrame("GridLayout3 line break test");
        frame.setDefaultCloseOperation(3);
        JPanel content = new JPanel();
        frame.getContentPane().add((Component)content, "Center");
        GridLayout3 gl3 = new GridLayout3(5, content);
        for (int i = 0; i < 20; ++i) {
            JButton jb = new JButton(GridLayout3.getRandomString());
            if (i == 2) {
                gl3.insertLineBreakAfterNextComponent();
                jb.setBackground(Color.red);
            }
            gl3.add(jb);
        }
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static String getRandomString() {
        int len = (int)(Math.random() * 30.0) + 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append("" + (char)(97 + i));
        }
        return sb.toString();
    }

    public void fillSouth() {
        this.insertLineBreakAfterNextComponent();
        this.constr.weighty = 100.0;
        this.add("");
    }
}

