/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status.mon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public final class GUIUtils {
    public static JTextPane createExplanationArea(String expl) {
        JTextPane tp = new JTextPane();
        tp.setEditable(false);
        tp.setText(expl);
        if (expl.startsWith("<html>")) {
            tp.setContentType("text/html");
            tp.setText(expl);
        }
        tp.setBackground(GUIUtils.giveYellowTouch(UIManager.getColor("Panel.background")));
        tp.setBorder(new EmptyBorder(5, 5, 5, 5));
        tp.setCaretPosition(0);
        return tp;
    }

    public static Color giveYellowTouch(Color c2) {
        int avg = (c2.getRed() + c2.getGreen() + c2.getBlue()) / 3;
        if (avg < 100) {
            int oldb = c2.getBlue();
            return new Color(c2.getRed(), c2.getGreen(), oldb > 128 ? oldb * 3 / 4 : oldb * 4 / 3);
        }
        int oldb = c2.getBlue();
        return new Color(c2.getRed(), c2.getGreen(), oldb > 128 ? oldb * 3 / 4 : oldb * 4 / 3);
    }

    public static JDialog createJDialog(Window parent, String title, boolean modal) {
        JDialog f = new JDialog(parent, title, modal ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.MODELESS);
        return f;
    }

    public static void setButtonSizeFix(AbstractButton btn1, int w, int h) {
        Dimension dim = new Dimension(w, h);
        btn1.setPreferredSize(dim);
        btn1.setMaximumSize(dim);
        btn1.setMinimumSize(dim);
    }

    public static JButton createSquareButton(String text, ImageIcon icon) {
        return GUIUtils.createSquareButton(text, icon, -1);
    }

    public static JButton createSquareButton(String text, ImageIcon icon, int _dim) {
        JButton btn = new JButton(text, icon);
        btn.putClientProperty("JComponent.sizeVariant", "small");
        btn.setMargin(new Insets(0, 1, 0, 1));
        int dim = _dim < 0 ? btn.getPreferredSize().height : _dim;
        btn.setPreferredSize(new Dimension(dim, dim));
        return btn;
    }

    public static JToggleButton createSquareToggleButton(String text, ImageIcon icon) {
        JToggleButton btn = new JToggleButton(text, icon);
        btn.putClientProperty("JComponent.sizeVariant", "small");
        btn.setMargin(new Insets(0, 1, 0, 1));
        int dim = btn.getPreferredSize().height;
        btn.setPreferredSize(new Dimension(dim, dim));
        return btn;
    }

    public static JPanel wrapLeft(Component c2) {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(c2);
        return p;
    }

    public static JLabel getTinyLabel(String txt) {
        return new JLabel(txt){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getFont("smallFont"));
            }
        };
    }

    public static JCheckBox getTinyJCheckBox(String txt) {
        return new JCheckBox(txt){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getFont("smallFont"));
            }
        };
    }

    public static JComboBox getTinyJComboBox(Object[] txt) {
        return new JComboBox(txt){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getFont("smallFont"));
            }
        };
    }

    public static JRadioButton getTinyJRadioButton(String txt) {
        return new JRadioButton(txt){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getFont("smallFont"));
            }
        };
    }

    public static JButton getTinyJButton(String txt) {
        return GUIUtils.getTinyJButton(txt, null);
    }

    public static JButton getTinyJButton(String txt, Icon icon) {
        return new JButton(txt, icon){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getFont("smallFont"));
            }
        };
    }

    public static JToggleButton getTinyJToggleButton(String txt, ImageIcon icon) {
        return new JToggleButton(txt, icon){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getFont("smallFont"));
            }
        };
    }

    public static final JLabel getDefaultLabel(String txt) {
        JLabel l = new JLabel(txt);
        return l;
    }
}

