/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status;

import ch.bruker.jac.servicegui.AppState;
import ch.bruker.jac.servicegui.GlobalPanel;
import ch.bruker.jac.servicegui.Tab;
import ch.bruker.jac.servicegui.data.io.Source;
import ch.bruker.jac.servicegui.img.Images;
import ch.bruker.jac.servicegui.status.StatusPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatusTab
extends Tab {
    private static final ImageIcon SPINNER_ICON = new ImageIcon(Images.class.getResource("spinner.gif"));
    final AppState state;
    private StatusPanel statusPanel;
    protected Source source;
    private final JLabel spinner = new JLabel(SPINNER_ICON);
    private boolean busy = false;
    final boolean developerGui;

    public StatusTab(AppState appState, Source source, boolean developerGui) {
        this.source = source;
        this.state = appState;
        this.developerGui = developerGui;
        if (this.statusPanel != null) {
            this.state.updates.unregister(this.statusPanel);
        }
        this.statusPanel = this.state.system.createStatusPanel(this);
        this.state.updates.register(this.statusPanel);
        this.setLayout(new GridBagLayout());
        this.removeAll();
        this.spinner.setVisible(false);
        GlobalPanel nav = new GlobalPanel(this.state, this.spinner);
        this.state.updates.register(nav);
        this.add((Component)nav, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 10, 10));
        this.add((Component)this.statusPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 10, 10));
    }

    public void setBusy(boolean busy) {
        this.spinner.setVisible(busy);
        this.busy = busy;
    }

    public void bindChangeListener() {
        ((JTabbedPane)this.getParent()).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (StatusTab.this.isVisible()) {
                    StatusTab.this.statusPanel.reload();
                }
            }
        });
    }

    public boolean isBusy() {
        return this.busy;
    }
}

