/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.status;

import ch.bruker.jac.config.JacPublicDefinitions;
import ch.bruker.jac.servicegui.GuiMode;
import ch.bruker.jac.servicegui.data.CacheUpdate;
import ch.bruker.jac.servicegui.data.Header;
import ch.bruker.jac.servicegui.status.StatusTab;
import ch.bruker.jac.servicegui.status.ui.UIView;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.joda.time.DateTime;

public class StatusPanel
extends JPanel {
    final StatusTab statusTab;
    private boolean usingAlternate = false;
    UIView userView;
    UIView serviceView;
    UIView developerView;
    UIView userView_;
    UIView serviceView_;
    UIView developerView_;
    private UIView view;

    public StatusPanel(StatusTab statusTab) {
        this.statusTab = statusTab;
    }

    public void reload() {
        if (this.statusTab == null) {
            return;
        }
        this.selectView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.this.setLayout(new GridBagLayout());
                StatusPanel.this.removeAll();
                StatusPanel.this.repaint();
            }
        });
        this.statusTab.state.doAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    if (StatusPanel.this.view.isUnPopulated()) {
                        StatusPanel.this.view.bind(StatusPanel.this.statusTab.source, StatusPanel.this.statusTab.state);
                        StatusPanel.this.view.populate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JPanel panel = new JPanel(new GridBagLayout());
                            panel.add((Component)StatusPanel.this.view, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                            panel.add(Box.createGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                            JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
                            scrollPane.getVerticalScrollBar().setUnitIncrement(30);
                            scrollPane.getHorizontalScrollBar().setUnitIncrement(30);
                            StatusPanel.this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
                            StatusPanel.this.view.updateLabels();
                            StatusPanel.this.view.updateActive();
                            StatusPanel.this.view.updateValues();
                            StatusPanel.this.revalidate();
                            StatusPanel.this.repaint();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    private void selectView() {
        this.usingAlternate = this.useAlternate();
        if (!this.usingAlternate) {
            switch (this.statusTab.state.getUserLevel()) {
                case USER: {
                    this.view = this.userView;
                    break;
                }
                case SERVICE: {
                    this.view = this.serviceView;
                    break;
                }
                case DEVELOPER: {
                    this.view = this.developerView;
                }
            }
        } else {
            switch (this.statusTab.state.getUserLevel()) {
                case USER: {
                    this.view = this.userView_;
                    break;
                }
                case SERVICE: {
                    this.view = this.serviceView_;
                    break;
                }
                case DEVELOPER: {
                    this.view = this.developerView_;
                }
            }
        }
    }

    @Subscribe
    public void handleUserLevelUpdate(JacPublicDefinitions.UserLevel userLevel) {
        if (this.lazy()) {
            return;
        }
        this.reload();
    }

    @Subscribe
    public void handleCursorUpdate(DateTime instant) {
        if (this.lazy()) {
            return;
        }
        if (this.view.isUnPopulated()) {
            return;
        }
        if (this.usingAlternate != this.useAlternate()) {
            this.reload();
        }
        this.view.updateActive();
    }

    @Subscribe
    public void handleHeaderUpdate(Header header) {
        if (this.lazy()) {
            return;
        }
        this.view.updateLabels();
    }

    @Subscribe
    public void handleCacheUpdate(CacheUpdate cacheUpdate) {
        if (this.lazy()) {
            return;
        }
        if (this.statusTab.state.isMode(GuiMode.TRACKING)) {
            return;
        }
        if (!cacheUpdate.span.contains(this.statusTab.state.getCursor())) {
            return;
        }
        this.view.updateValues();
    }

    private boolean lazy() {
        return !this.statusTab.isActive();
    }

    @Subscribe
    public void handleModeUpdate(GuiMode mode) {
        if (this.lazy()) {
            return;
        }
        this.view.updateActive();
    }

    boolean useAlternate() {
        return false;
    }
}

