/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.net;

import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.util.BUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SubnetScanner {
    private static final int TIMEOUT = 200;

    public static void main(String[] args) {
        InterfaceAddress ifc = SubnetScanner.getNetworkInterface("10.");
        if (ifc == null) {
            return;
        }
        long start = System.currentTimeMillis();
        List<InetAddress> reachable = SubnetScanner.scanSubnet256(ifc);
        SGUtils.log(reachable.toString(), new Object[0]);
        SGUtils.log(System.currentTimeMillis() - start + "ms", new Object[0]);
    }

    public static List<InetAddress> scanSubnet256(InterfaceAddress interfaceAddress) throws IllegalArgumentException {
        InetAddress baseAddress = interfaceAddress.getAddress();
        if (baseAddress instanceof Inet6Address) {
            throw new IllegalArgumentException("Scanning does not work for IPv6");
        }
        int subnetSize = 255;
        List<InetAddress> ipAddresses = SubnetScanner.getSubnetAddresses(baseAddress, subnetSize);
        final List<InetAddress> reachableIps = Collections.synchronizedList(new Vector());
        int nThreads = subnetSize - 2;
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(subnetSize - 2);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(nThreads, nThreads, 1L, TimeUnit.SECONDS, queue);
        for (final InetAddress ipAddress : ipAddresses) {
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    if (SubnetScanner.ipExists(ipAddress.getHostAddress(), 200)) {
                        reachableIps.add(ipAddress);
                    }
                }
            });
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        reachableIps.remove(interfaceAddress.getAddress());
        return reachableIps;
    }

    public static List<InetAddress> getSubnetAddresses(InetAddress baseAddress, int subnetSize) {
        if (baseAddress instanceof Inet6Address) {
            throw new IllegalArgumentException("Scanning does not work for IPv6");
        }
        if (subnetSize > 256) {
            throw new IllegalArgumentException("Subnet is too large to scan");
        }
        ArrayList<InetAddress> ipAddresses = new ArrayList<InetAddress>();
        for (int i = 1; i < subnetSize; ++i) {
            byte[] ipAddressBytes = baseAddress.getAddress();
            ipAddressBytes[3] = (byte)i;
            try {
                InetAddress ipAddress = InetAddress.getByAddress(ipAddressBytes);
                ipAddresses.add(ipAddress);
                continue;
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        return ipAddresses;
    }

    public static InterfaceAddress getNetworkInterface(String prefix) {
        try {
            for (NetworkInterface netIf : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress ia : netIf.getInterfaceAddresses()) {
                    if (!ia.getAddress().getHostAddress().startsWith(prefix)) continue;
                    return ia;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    private static boolean ipExists(String ipAddress, int msTimeout) {
        int sTimeout = Math.min(1, msTimeout / 1000);
        String cmd = BUtil.isWindows ? "ping -n 1 -i 2 -w " + msTimeout : "ping -c 1 -t 1 -w " + sTimeout;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd + " " + ipAddress);
            int retValue = p.waitFor();
            if (!BUtil.isWindows) {
                return retValue == 0;
            }
            if (retValue != 0) {
                return false;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains("ms") || !line.contains("TTL=")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

