/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.net;

import ch.bruker.jac.servicegui.Jac;
import ch.bruker.jac.servicegui.JacHandle;
import ch.bruker.jac.servicegui.JacServiceGui;
import ch.bruker.jac.servicegui.SGUtils;
import ch.bruker.jac.servicegui.net.SubnetScanner;
import ch.bruker.jac.servicegui.systems.Groups;
import ch.bruker.jac.servicegui.systems.JacType;
import ch.bruker.util.Bis;
import ch.bruker.util.NewOptionsListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class JacDeviceScanner {
    public static final int PORT_RANGE_START = 20002;
    public static final int PORT_RANGE_END = 20013;
    public static final int SCP_PORT_RANGE_START = 20022;
    public static final int SCP_PORT_RANGE_END = 20033;
    private static final File NAT_GATEWAYS_FILE = new File(JacServiceGui.USER_HOME, "jac_servicegui/nat_gateways.config");
    private static final File NAT_GATEWAY_ONLY_FILE = new File(JacServiceGui.USER_HOME, "jac_servicegui/nat_gateway_only.config");
    private static final String PROXY_PATH_CFPU = "/proxy/cfpu";
    private static final String LOCAL_PORT_CFPU = "10.236.99.64";
    private final BlockingQueue<JacHandle> jacHandles = new LinkedBlockingQueue<JacHandle>();
    private final JacType systemTypeToFilter;
    private final List<String> natGateways = new ArrayList<String>();
    private boolean natOnly = false;
    private NewOptionsListener listener;
    private ExecutorService executor;
    private Thread waitForScanCompletionThread;

    public JacDeviceScanner(JacType systemTypeToFilter) {
        this(systemTypeToFilter, null);
    }

    public JacDeviceScanner(JacType systemTypeToFilter, NewOptionsListener listener) {
        this.systemTypeToFilter = systemTypeToFilter;
        this.listener = listener;
        this.readPersistentNatGatewayList();
        this.readPersistentNatGatewayOnlySetting();
    }

    private static String getWebcontent(String urlName, int msTimeout) {
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL(urlName).openConnection();
            con.setReadTimeout(msTimeout);
            con.setConnectTimeout(msTimeout);
            con.setRequestMethod("GET");
            if (con.getResponseCode() == 200) {
                String content = JacDeviceScanner.streamToString(con.getInputStream(), Charset.forName("UTF-8"));
                return content;
            }
        }
        catch (ConnectException e) {
        }
        catch (BindException e) {
        }
        catch (NoRouteToHostException e) {
        }
        catch (SocketTimeoutException e) {
        }
        catch (SocketException e) {
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        return null;
    }

    private static String streamToString(InputStream input, Charset encoding) throws IOException {
        int DEFAULT_BUFFER_SIZE = 4096;
        int EOF = -1;
        InputStreamReader in = new InputStreamReader(input, encoding);
        StringBuilder output = new StringBuilder();
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            output.append(buffer, 0, n);
        }
        return output.toString();
    }

    private void readPersistentNatGatewayOnlySetting() {
        if (NAT_GATEWAY_ONLY_FILE.exists()) {
            try {
                this.natOnly = (Boolean)SGUtils.load(NAT_GATEWAY_ONLY_FILE);
            }
            catch (Exception e) {
                SGUtils.log("Warning: Scan Remote Spectrometers Only configuration file cannot be read.", new Object[0]);
            }
        } else {
            SGUtils.log("No Scan Remote Spectrometers Only configuration file found. Using default = false.", new Object[0]);
            this.natOnly = false;
        }
    }

    private void storePersistentNatGatewayOnlySetting() {
        SGUtils.store(this.natOnly, NAT_GATEWAY_ONLY_FILE);
    }

    public List<String> getNatGatewayList() {
        return this.natGateways;
    }

    private void readPersistentNatGatewayList() {
        if (NAT_GATEWAYS_FILE.exists()) {
            try {
                List list = (List)SGUtils.load(NAT_GATEWAYS_FILE);
                for (String natGateway : list) {
                    this.natGateways.add(natGateway);
                }
            }
            catch (Exception e) {
                SGUtils.log("Warning: List of remote spectrometers is corrupt.", new Object[0]);
            }
        } else {
            SGUtils.log("Warning: No list of remote spectrometers found. Using default.", new Object[0]);
            this.natGateways.add("149.236.99.9");
            this.storePersistentNatGatewayList();
        }
    }

    private void storePersistentNatGatewayList() {
        SGUtils.store(this.natGateways, NAT_GATEWAYS_FILE);
    }

    public void scanForConnectedSystems(InetAddress forceIpAddress, int forcePort, String forceProxyPath) {
        String SUBNET_PREFIX = "149.236.99";
        Vector<Serializable> ipAddresses = new Vector<Serializable>();
        if (forceIpAddress != null) {
            if (forcePort == 0) {
                SGUtils.log("Scanning for a connected system at an explicitly specified IP address: %s", forceIpAddress);
                ipAddresses.add(forceIpAddress);
            } else {
                SGUtils.log("Scanning for a connected system at an explicitly specified IP address: %s:%d", forceIpAddress, forcePort);
                ipAddresses.add(new InetSocketAddress(forceIpAddress, forcePort));
            }
        } else {
            SGUtils.log("Scanning network for a connected system", new Object[0]);
            SGUtils.log("Including NAT gateways in scan: %s", this.natGateways);
            for (String natGateway : this.natGateways) {
                for (int port = 20002; port <= 20013; ++port) {
                    ipAddresses.add(new InetSocketAddress(natGateway, port));
                }
            }
            if (!this.natOnly) {
                InterfaceAddress ifc = SubnetScanner.getNetworkInterface("149.236.99");
                if (ifc != null) {
                    SGUtils.log("Including subnet %s in scan", ifc.getAddress());
                    ipAddresses.addAll(SubnetScanner.getSubnetAddresses(ifc.getAddress(), 256));
                }
                ipAddresses.addAll(Groups.getStaticIPAddresses());
                ipAddresses.addAll(Groups.getLegacyIPAddresses());
            }
        }
        if (forceProxyPath != null) {
            SGUtils.log("Scanning for a connected system at an explicitly specified proxy path: %s", forceProxyPath);
        }
        this.scan(ipAddresses, forceProxyPath);
    }

    private void scan(List<?> ipAddresses, String forceProxyPath) {
        if (ipAddresses.size() == 0) {
            return;
        }
        this.executor = Executors.newCachedThreadPool();
        this.fireStarted("State: Scanning network for connected systems\u2026");
        Vector<String> proxyPaths = null;
        if (forceProxyPath != null) {
            proxyPaths = new Vector<String>();
            proxyPaths.add(forceProxyPath);
        }
        this.executeScan(ipAddresses, proxyPaths);
        this.waitForScanCompletionThread = new Thread(new Runnable(){
            int cnt = 0;

            @Override
            public void run() {
                while (!JacDeviceScanner.this.executor.isTerminated()) {
                    ++this.cnt;
                    if (!JacDeviceScanner.this.executor.isTerminated() && this.cnt > 40) {
                        JacDeviceScanner.this.executor.shutdown();
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                JacDeviceScanner.this.fireDone("State: Scanning complete");
            }
        }, "WaitForScanCompletion");
        this.waitForScanCompletionThread.setDaemon(true);
        this.waitForScanCompletionThread.start();
    }

    private void executeScan(List<?> ipAddresses, List<String> proxyPaths) {
        for (Object object : ipAddresses) {
            int port;
            InetAddress ipAddress;
            if (object instanceof InetAddress) {
                ipAddress = (InetAddress)object;
                port = 80;
            } else {
                InetSocketAddress socketAddress = (InetSocketAddress)object;
                if (socketAddress.getAddress() != null) {
                    ipAddress = socketAddress.getAddress();
                } else if (socketAddress.getHostName() != null) {
                    InetAddress resolvedAddress = null;
                    try {
                        resolvedAddress = InetAddress.getByName(socketAddress.getHostName());
                    }
                    catch (UnknownHostException e) {
                        SGUtils.log("Warning: Unknown host: " + socketAddress.getHostName(), new Object[0]);
                    }
                    ipAddress = resolvedAddress;
                } else {
                    ipAddress = null;
                }
                port = socketAddress.getPort();
            }
            if (proxyPaths != null) {
                for (String proxyPath : proxyPaths) {
                    this.executeScanTask(ipAddress, port, proxyPath);
                }
                continue;
            }
            this.executeScanTask(ipAddress, port, "");
        }
    }

    private void executeScanTask(final InetAddress ipAddress, final int port, final String proxyPath) {
        String ID_XML_PAGE = "BrukerDeviceId.xml";
        int TIMEOUT_MS = 40000;
        this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    long time = System.currentTimeMillis();
                    if (ipAddress != null) {
                        try {
                            JacHandle jacHandle;
                            boolean isJacBis;
                            String identifier = "http://" + ipAddress.getHostAddress() + ":" + port + proxyPath + "/" + "BrukerDeviceId.xml";
                            String brukerDeviceIdXml = JacDeviceScanner.getWebcontent(identifier, 40000);
                            if (brukerDeviceIdXml == null || !brukerDeviceIdXml.toLowerCase().contains("$bis")) break block14;
                            Bis bis = new Bis(brukerDeviceIdXml.getBytes(Charset.forName("UTF-8")));
                            boolean bl = isJacBis = bis.bisGroup != null && "JAC".equalsIgnoreCase(bis.bisGroup.getBisType());
                            if (!isJacBis) break block14;
                            Jac instance = Jac.fromBis(bis);
                            if (JacDeviceScanner.this.systemTypeToFilter != null && !instance.type.equals((Object)JacDeviceScanner.this.systemTypeToFilter)) break block14;
                            if (proxyPath.isEmpty()) {
                                jacHandle = new JacHandle(ipAddress, port, instance);
                            } else {
                                String localIp = "";
                                if (proxyPath.equals(JacDeviceScanner.PROXY_PATH_CFPU)) {
                                    localIp = JacDeviceScanner.LOCAL_PORT_CFPU;
                                }
                                jacHandle = new JacHandle(ipAddress, port, proxyPath, localIp, instance);
                            }
                            boolean isNew = false;
                            BlockingQueue blockingQueue = JacDeviceScanner.this.jacHandles;
                            synchronized (blockingQueue) {
                                boolean bl2 = isNew = !JacDeviceScanner.this.jacHandles.contains(jacHandle);
                                if (isNew && jacHandle.jac.type != null) {
                                    JacDeviceScanner.this.jacHandles.add(jacHandle);
                                }
                            }
                            if (isNew) {
                                if (jacHandle.jac.type != null) {
                                    JacDeviceScanner.this.fireNewOptionAvailable(jacHandle);
                                    SGUtils.log("Found new JAC device: %s:%d%s in: %dms", ipAddress, port, proxyPath, System.currentTimeMillis() - time);
                                    if (jacHandle.jac.type == JacType.MMS_BMU_53_CF) {
                                        Vector<String> proxyPath2 = new Vector<String>();
                                        proxyPath2.add(JacDeviceScanner.PROXY_PATH_CFPU);
                                        Vector<InetSocketAddress> l = new Vector<InetSocketAddress>();
                                        l.add(new InetSocketAddress(ipAddress, port));
                                        JacDeviceScanner.this.executeScan(l, proxyPath2);
                                    }
                                } else {
                                    SGUtils.log("Found new JAC device (not supported by this Service Gui version, type: " + (Object)((Object)jacHandle.jac.type) + " @" + ipAddress + ":" + port + proxyPath + " in: " + (System.currentTimeMillis() - time) + "ms", new Object[0]);
                                }
                            }
                        }
                        catch (Exception e) {
                            SGUtils.log("Error while scanning for device %s:%d. %s", ipAddress, port, e);
                        }
                    }
                }
            }
        });
    }

    public void abort() {
        this.executor.shutdownNow();
    }

    private void fireStarted(String message) {
        if (this.listener != null) {
            this.listener.started(message);
        }
    }

    private void fireNewOptionAvailable(JacHandle jacHandle) {
        if (this.listener != null) {
            this.listener.newOptionAvailable(jacHandle);
        }
    }

    private void fireDone(String message) {
        if (this.listener != null) {
            this.listener.done(message);
        }
    }

    public Queue<JacHandle> waitAndGetConnectedSystems() {
        try {
            this.executor.awaitTermination(6L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.jacHandles;
    }

    public JacHandle waitForFirst() {
        try {
            return this.jacHandles.poll(6L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void natGatewayAdded(String natGateway) {
        this.natGateways.add(natGateway);
        this.storePersistentNatGatewayList();
        SGUtils.log("Scanning new NAT gateway: %s", natGateway);
        Vector<InetSocketAddress> ipAddresses = new Vector<InetSocketAddress>();
        for (int port = 20002; port <= 20013; ++port) {
            ipAddresses.add(new InetSocketAddress(natGateway, port));
        }
        this.scan(ipAddresses, null);
    }

    public void natGatewayRemoved(String natGateway) {
        this.natGateways.remove(natGateway);
        this.storePersistentNatGatewayList();
    }

    public void natGatewayOnlyScan(boolean natOnly) {
        this.natOnly = natOnly;
        this.storePersistentNatGatewayOnlySetting();
        if (!natOnly) {
            this.reScan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reScan() {
        BlockingQueue<JacHandle> blockingQueue = this.jacHandles;
        synchronized (blockingQueue) {
            this.jacHandles.clear();
        }
        this.listener.clear("Re-Scanning");
        this.scanForConnectedSystems(null, 0, null);
    }

    public boolean getNatGatewayOnlyScan() {
        return this.natOnly;
    }

    public void setListener(NewOptionsListener listener) {
        this.listener = listener;
    }
}

