/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.net;

import ch.bruker.jac.servicegui.net.AvailablePortFinder;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class DeviceDiscoverer {
    public static final String DEFAULT_MULTICAST_ADDRESS = "230.0.0.2";
    public static final int DEFAULT_LISTENING_PORT = 4446;
    public static final int DEFAULT_REPLY_PORT = 4445;
    private static final int DISCOVER_TIMEOUT_MS = 200;

    public static List<InetAddress> discoverDevices(String serviceId) {
        return DeviceDiscoverer.discoverDevices(serviceId, "");
    }

    public static List<InetAddress> discoverDevices(String serviceId, String ipAddressPrefix) {
        Vector<InetAddress> devices = new Vector<InetAddress>();
        try {
            block2: for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                ArrayList<InetAddress> addresses = Collections.list(ni.getInetAddresses());
                for (InetAddress address : addresses) {
                    String srcAddress = address.getHostAddress();
                    if (!srcAddress.startsWith(ipAddressPrefix)) continue;
                    devices.addAll(DeviceDiscoverer.discoverDevices(serviceId, srcAddress, DEFAULT_MULTICAST_ADDRESS, 4446, 4445));
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InetAddress> discoverDevices(String serviceId, String srcAddress, String multicastAddress, int servicePort, int replyPort) throws IOException {
        int sendPort = AvailablePortFinder.getNextAvailable(servicePort);
        DatagramSocket socket = new DatagramSocket(sendPort, InetAddress.getByName(srcAddress));
        int availReplyPort = AvailablePortFinder.getNextAvailable(replyPort);
        DatagramSocket replySocket = new DatagramSocket(availReplyPort, InetAddress.getByName(srcAddress));
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            byte[] buf = (serviceId + "#" + availReplyPort).getBytes();
            replySocket.setSoTimeout(200);
            InetAddress group = InetAddress.getByName(multicastAddress);
            DatagramPacket packet = new DatagramPacket(buf, buf.length, group, servicePort);
            socket.send(packet);
            packet = new DatagramPacket(new byte[1024], 1024);
            while (true) {
                replySocket.receive(packet);
                String ip = new String(packet.getData(), 0, packet.getLength());
                result.add(InetAddress.getByName(ip));
            }
        }
        catch (SocketTimeoutException ste) {
            socket.close();
            replySocket.close();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                socket.close();
                replySocket.close();
            }
        }
        return result;
    }
}

