/*
 * Decompiled with CFR 0.152.
 */
package ch.bruker.jac.servicegui.graphical;

import ch.bruker.jac.servicegui.data.DiscreteSample;
import ch.bruker.jac.servicegui.data.Sample;
import ch.bruker.jac.servicegui.data.cache.Descriptor;
import ch.bruker.jac.servicegui.graphical.PanelState;
import ch.bruker.jac.servicegui.graphical.Plot;
import ch.bruker.jac.servicegui.graphical.PlotPanel;
import ch.bruker.jac.servicegui.graphical.ShapeBuffer;
import com.google.common.collect.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.UIManager;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class StatePlot
extends Plot {
    private static final int HEIGHT = 40;
    private static final int MARGIN = 5;
    private static final int STATE_NR_WIDTH = 20;

    public StatePlot(Descriptor descriptor, PanelState state) {
        super(descriptor, state);
    }

    @Override
    public void draw(Graphics2D g, PlotPanel target) {
        AffineTransform current = g.getTransform();
        g.transform(this.getOffset());
        super.draw(g, target);
        g.setTransform(current);
    }

    @Override
    public boolean intersects(Rectangle2D target) {
        AffineTransform t = this.getOffset();
        try {
            t.invert();
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
        Shape target_ = t.createTransformedShape(target);
        return super.intersects(target_.getBounds2D());
    }

    private AffineTransform getOffset() {
        AffineTransform t = new AffineTransform();
        int idx = this.state.getStatePlotIdx(this);
        t.translate(0.0, idx * 45 + 8);
        return t;
    }

    @Override
    public Range<Double> getClippingRange() {
        return Range.all();
    }

    @Override
    ShapeBuffer render(PlotPanel target) {
        ShapeBuffer buffer = new ShapeBuffer(target, this.state.app);
        Path2D.Float boxes = new Path2D.Float();
        Path2D.Float edges = new Path2D.Float();
        Path2D.Float labels = new Path2D.Float();
        int SUBSAMPLING = 2;
        int msPerPixel = (int)(this.state.app.getScope().toDurationMillis() / (long)target.getWidth());
        Duration overscan = new Duration((long)msPerPixel * 200L);
        Interval renderScope = new Interval((ReadableInstant)this.state.app.getScope().getStart().minus(overscan), (ReadableInstant)this.state.app.getScope().getEnd().plus(overscan));
        int count = (target.getWidth() + 400) / SUBSAMPLING;
        ArrayList<Sample> samples = this.state.app.cachedSamples(this.parId, renderScope, count);
        samples.add(new DiscreteSample(0, true, -1));
        int pxl = -200;
        int previousCut = 0;
        DiscreteSample previousSample = new DiscreteSample(0, true, -1);
        String previousLabel = "";
        for (Sample s : samples) {
            if (s.isVoid()) {
                pxl += SUBSAMPLING;
                continue;
            }
            DiscreteSample sample = s.isAbsent() ? new DiscreteSample(Integer.MIN_VALUE, false, Sample.ABSENT.n) : (DiscreteSample)s;
            if (!sample.glitch && sample.equals(previousSample)) {
                pxl += SUBSAMPLING;
                continue;
            }
            if (!previousSample.isAbsent()) {
                int space;
                float arcw = 20.0f;
                int right = pxl - 3;
                int left = previousCut - 3;
                if (right - left > 4) {
                    RoundRectangle2D.Float rect = new RoundRectangle2D.Float(left, 0.0f, right - left, 40.0f, arcw, arcw);
                    boxes.append(rect, false);
                    edges.append(rect, false);
                } else {
                    int center = (left + right) / 2;
                    edges.append(new Line2D.Float(center, 0.0f, center, 40.0f), false);
                }
                if (left < 0) {
                    left = 0;
                }
                if (right > target.getWidth()) {
                    right = target.getWidth();
                }
                if ((space = right - left) > 14) {
                    float x;
                    String stateNrStr = String.format("%d", previousSample.state);
                    Font bold = UIManager.getDefaults().getFont("Label.font").deriveFont(14.0f);
                    GlyphVector nr = bold.createGlyphVector(target.getFontMetrics(bold).getFontRenderContext(), stateNrStr);
                    Font plain = bold.deriveFont(0);
                    GlyphVector l = plain.createGlyphVector(target.getFontMetrics(plain).getFontRenderContext(), previousLabel);
                    Rectangle2D lBounds = l.getVisualBounds();
                    Rectangle2D nrBounds = nr.getVisualBounds();
                    float y = (float)((double)(target.getFontMetrics(bold).getHeight() / 2) + 17.2);
                    if ((double)space < lBounds.getWidth() + 20.0) {
                        x = (float)((double)left + ((double)space - nrBounds.getWidth()) / 2.0);
                        labels.append(nr.getOutline(x, y), false);
                    } else {
                        x = (float)((double)left + ((double)space - nrBounds.getWidth() - 5.0 - lBounds.getWidth()) / 2.0);
                        labels.append(nr.getOutline(x, y), false);
                        labels.append(l.getOutline((float)((double)(x + 5.0f) + nrBounds.getWidth()), y), false);
                    }
                }
            }
            previousCut = pxl;
            previousSample = sample;
            previousLabel = this.state.app.sampleLabel(this.parId, sample, target.map(pxl));
            pxl += SUBSAMPLING;
        }
        buffer.fillLight.add(boxes);
        buffer.stroke.add(edges);
        buffer.fillDark.add(labels);
        return buffer;
    }
}

